/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.print;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.nightlabs.config.Config;
import org.nightlabs.config.ConfigException;
import org.nightlabs.config.ConfigModule;
import org.nightlabs.config.InitException;
import org.nightlabs.print.DelegatingDocumentPrinter;
import org.nightlabs.print.DocumentPrinterDelegateConfig;

public class DelegatingDocumentPrinterCfMod
extends ConfigModule {
    private static final Logger logger = Logger.getLogger(DelegatingDocumentPrinter.class);
    private static final long serialVersionUID = 1L;
    private Map<String, DocumentPrinterDelegateConfig> printConfigs;

    @Override
    public void init() throws InitException {
        super.init();
        if (this.printConfigs == null) {
            this.printConfigs = new HashMap<String, DocumentPrinterDelegateConfig>();
            this.initFromProperties();
        }
    }

    private void initFromProperties() {
        if (this.getClass().getResource("documentprinterdelegates.properties") == null) {
            logger.warn((Object)"Could not init initialize SystemCallPrinterCfMod from Properties as no resource documentprinterdelegates.properties could be found in the package org.nightlabs.print");
        }
        Properties props = new Properties();
        try {
            props.load(this.getClass().getResourceAsStream("documentprinterdelegates.properties"));
        }
        catch (IOException e) {
            logger.error((Object)"Could not initialize SystemCallPrinterCfMod from Properties. Loading properties failed", (Throwable)e);
            this.printConfigs.clear();
        }
        HashMap<String, String> fileExts = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key;
            if (!(entry.getKey() instanceof String) || (key = (String)entry.getKey()).indexOf(46) >= 0) continue;
            fileExts.put(key, (String)entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : fileExts.entrySet()) {
            String type = (String)entry.getValue();
            if (type.equalsIgnoreCase("systemcall")) {
                String commandPattern = props.getProperty(entry + ".commandPattern");
                String parameterPattern = props.getProperty(entry + ".parameterPattern");
                SystemCallDelegateConfig config = new SystemCallDelegateConfig();
                config.setCommandPattern(commandPattern != null ? commandPattern : "");
                config.setParameterPattern(parameterPattern != null ? parameterPattern : "");
                this.printConfigs.put((String)entry.getKey(), config);
                continue;
            }
            if (!type.equalsIgnoreCase("externalengine")) continue;
            String className = props.getProperty(entry + ".className");
            ExternalEngineDelegateConfig config = new ExternalEngineDelegateConfig();
            config.setClassName(className != null ? className : "");
            this.printConfigs.put((String)entry.getKey(), config);
        }
    }

    public Map<String, DocumentPrinterDelegateConfig> getPrintConfigs() {
        return this.printConfigs;
    }

    public DocumentPrinterDelegateConfig getPrintConfig(String fileExt) {
        return this.getPrintConfigs().get(fileExt);
    }

    public void setPrintConfig(String fileExt, DocumentPrinterDelegateConfig printConfig) {
        this.printConfigs.put(fileExt, printConfig);
        this.setChanged();
    }

    public void setPrintConfigs(Map<String, DocumentPrinterDelegateConfig> printConfigs) {
        this.printConfigs = printConfigs;
        this.setChanged();
    }

    public static DelegatingDocumentPrinterCfMod sharedInstance() {
        if (!Config.isSharedInstanceExisting()) {
            return null;
        }
        try {
            return (DelegatingDocumentPrinterCfMod)Config.sharedInstance().createConfigModule(DelegatingDocumentPrinterCfMod.class);
        }
        catch (ConfigException e) {
            throw new RuntimeException(e);
        }
    }

    public static class ExternalEngineDelegateConfig
    implements DocumentPrinterDelegateConfig {
        private String className;

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }
    }

    public static class SystemCallDelegateConfig
    implements DocumentPrinterDelegateConfig {
        private String commandPattern;
        private String parameterPattern;
        private int expectedReturnValue = 0;

        public String getCommandPattern() {
            return this.commandPattern;
        }

        public void setCommandPattern(String commandPattern) {
            this.commandPattern = commandPattern;
        }

        public String getParameterPattern() {
            return this.parameterPattern;
        }

        public void setParameterPattern(String parameterPattern) {
            this.parameterPattern = parameterPattern;
        }

        public int getExpectedReturnValue() {
            return this.expectedReturnValue;
        }

        public void setExpectedReturnValue(int expectedReturnValue) {
            this.expectedReturnValue = expectedReturnValue;
        }
    }
}

