/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.i18n.unit;

import java.util.Locale;
import org.nightlabs.i18n.I18nText;
import org.nightlabs.i18n.I18nTextBuffer;
import org.nightlabs.i18n.unit.IUnit;
import org.nightlabs.util.Utils;

public class Unit
implements IUnit {
    protected String unitID = "millimetre";
    protected String symbol = "mm";
    protected I18nText i18nText = new I18nTextBuffer();
    protected double factor = 1.0;

    protected Unit() {
    }

    public Unit(String unitID, String name, String unitSymbol, double factor) {
        this.unitID = unitID;
        this.i18nText.setText(Locale.getDefault().getLanguage(), name);
        this.symbol = unitSymbol;
        this.factor = factor;
    }

    @Override
    public String getUnitID() {
        return this.unitID;
    }

    @Override
    public String getUnitSymbol() {
        return this.symbol;
    }

    @Override
    public I18nText getName() {
        return this.i18nText;
    }

    @Override
    public double getFactor() {
        return this.factor;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IUnit)) {
            return false;
        }
        IUnit u = (IUnit)obj;
        return u.getUnitID().equals(this.getUnitID());
    }

    @Override
    public int hashCode() {
        return Utils.hashCode(this.unitID);
    }
}

