/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.eclipse.ui.pdfviewer.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public final class Util {
    private static File tempDir = null;

    private Util() {
    }

    public static boolean equals(Object obj0, Object obj1) {
        if (obj0 instanceof Object[] && obj1 instanceof Object[]) {
            return obj0 == obj1 || Arrays.equals((Object[])obj0, (Object[])obj1);
        }
        return obj0 == obj1 || obj0 != null && obj0.equals(obj1);
    }

    public static boolean equals(long l0, long l1) {
        return l0 == l1;
    }

    public static boolean equals(int i0, int i1) {
        return i0 == i1;
    }

    public static int hashCode(long l) {
        return (int)(l ^ l >>> 32);
    }

    public static int hashCode(Object obj) {
        return obj == null ? 0 : obj.hashCode();
    }

    public static File getTempDir() {
        if (tempDir == null) {
            tempDir = new File(System.getProperty("java.io.tmpdir"));
        }
        return tempDir;
    }

    public static long transferStreamData(InputStream in, OutputStream out, long inputOffset, long inputLen) throws IOException {
        int bytesRead;
        int transferred = 0;
        byte[] buf = new byte[4096];
        if (inputOffset > 0L && in.skip(inputOffset) != inputOffset) {
            throw new IOException("Input skip failed (offset " + inputOffset + ")");
        }
        while ((bytesRead = inputLen >= 0L ? in.read(buf, 0, (int)Math.min((long)buf.length, inputLen - (long)transferred)) : in.read(buf)) > 0) {
            out.write(buf, 0, bytesRead);
            if (inputLen < 0L || (long)(transferred += bytesRead) < inputLen) continue;
        }
        out.flush();
        return transferred;
    }

    public static long transferStreamData(InputStream in, OutputStream out) throws IOException {
        return Util.transferStreamData(in, out, 0L, -1L);
    }
}

