/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.eclipse.ui.pdfviewer;

import java.awt.geom.Dimension2D;

public class Dimension2DDouble
extends Dimension2D {
    private volatile boolean readOnly;
    private double width;
    private double height;

    public Dimension2DDouble() {
    }

    public Dimension2DDouble(double width, double height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    private void assertNotReadOnly() {
        if (this.readOnly) {
            throw new UnsupportedOperationException("This instance of Dimension2DDouble is read-only!");
        }
    }

    public void setWidth(double width) {
        this.assertNotReadOnly();
        this.width = width;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.assertNotReadOnly();
        this.height = height;
    }

    @Override
    public void setSize(double width, double height) {
        this.assertNotReadOnly();
        this.width = width;
        this.height = height;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass() && !(obj instanceof Dimension2D)) {
            return false;
        }
        Dimension2D o = (Dimension2D)obj;
        return this.width == o.getWidth() && this.height == o.getHeight();
    }

    public int hashCode() {
        long wbits = Double.doubleToLongBits(this.width);
        long hbits = Double.doubleToLongBits(this.height);
        return (int)(wbits ^ wbits >>> 32) * 31 ^ (int)(hbits ^ hbits >>> 32);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + '@' + Integer.toHexString(System.identityHashCode(this)) + '[' + this.width + ',' + this.height + ']';
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }
}

