/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.menu;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.ObjectUsageAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.IDDataObject;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBasePatient;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XBaseEncounter;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.BaseView;
import ca.infodata.ofys.ui.controls.ControlsPlugin;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.ICanBeRefreshed;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.controls.ITreeElements2;
import ca.infodata.ofys.ui.controls.ITreeElementsPastille;
import ca.infodata.ofys.ui.controls.form.IReferenceControl;
import ca.infodata.ofys.ui.controls.plugins.searchview.BaseSearchView;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.IPastilleInfo;
import ca.infodata.ofys.ui.library.IRefreshFont;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.menu.BaseInput;
import ca.infodata.ofys.ui.menu.DecoratingColumnLabelProvider;
import ca.infodata.ofys.ui.menu.DossierPlugin;
import ca.infodata.ofys.ui.menu.MyTreeViewer;
import ca.infodata.ofys.ui.menu.TreeContent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ISizeProvider;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;

public class RdvsView
extends BaseView
implements ICanBeRefreshed,
IRefreshFont,
ISizeProvider {
    private static final Logger logger = Logger.getLogger(RdvsView.class.getName());
    protected MyTreeViewer treeViewer;
    protected ITreeElements currentSelection;
    private int fontIncrement = 2;
    protected int viewWidth = 0;
    private List<String> menuOrderList = new ArrayList<String>();

    public void setFocus() {
    }

    public void dispose() {
        ResourceGetter.removeListener((IRefreshFont)this);
        super.dispose();
    }

    public void createMyPartControl(Composite parent) {
        this.initMenuElementOrderList();
        RdvsView.setPage((IWorkbenchPage)this.getSite().getPage());
        ResourceGetter.addListener((IRefreshFont)this);
        this.fillToolBar();
        try {
            parent.setLayout((Layout)new FillLayout());
            this.treeViewer = new MyTreeViewer(parent, 65540);
            this.treeViewer.getTree().setFont(ResourceGetter.getFontNormal((int)this.fontIncrement));
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
            DossierPlugin.getDefault().setTreeViewer(this.treeViewer);
            BaseInput input = new BaseInput(this.menuOrderList);
            TreeContent content = new TreeContent();
            parent.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Control c = (Control)e.getSource();
                    int actualSize = c.getSize().x;
                    if (correctionWidth == Integer.MIN_VALUE) {
                        correctionWidth = RdvsView.this.viewWidth - actualSize;
                    }
                    try {
                        RdvsView.this.viewWidth = actualSize + correctionWidth;
                        RdvsView.this.settings.put("viewMainLeftWidth", RdvsView.this.viewWidth);
                        System.out.println("put viewWidth = " + RdvsView.this.viewWidth);
                    }
                    catch (Exception e2) {
                        logger.log(Level.WARNING, "Failed to store sizeDossierView user preferences", e2);
                    }
                }
            });
            parent.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                }
            });
            ILabelDecorator decorator = DossierPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator();
            this.treeViewer.setContentProvider((IContentProvider)content);
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingColumnLabelProvider(content, decorator));
            this.treeViewer.setInput(input);
            this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent e) {
                    StructuredSelection selection = (StructuredSelection)e.getSelection();
                    if (selection != null) {
                        RdvsView.this.doubleClick((ITreeElements)selection.getFirstElement());
                    }
                }
            });
            this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent e) {
                    StructuredSelection selection = (StructuredSelection)e.getSelection();
                    if (selection != null) {
                        RdvsView.this.currentSelection = (ITreeElements)selection.getFirstElement();
                    }
                }
            });
            this.treeViewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    TreeItem[] selectedItem;
                    Tree tree = (Tree)e.widget;
                    e.doit = false;
                    if (UI.CTRL((KeyEvent)e) && (e.keyCode == 99 || e.keyCode == 67)) {
                        RdvsView.this.currentSelection.doKeyListener((Control)e.widget, null);
                    } else if (UI.CR((KeyEvent)e) && (selectedItem = tree.getSelection()) != null && selectedItem.length > 0) {
                        TreeItem t = selectedItem[0];
                        RdvsView.this.doubleClick((ITreeElements)t.getData());
                    }
                }
            });
            this.treeViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (UI.rightClick((MouseEvent)e)) {
                        if (RdvsView.this.currentSelection != null) {
                            RdvsView.this.currentSelection.showContextMenu((Control)e.widget);
                        }
                    } else {
                        Tree tree = (Tree)e.widget;
                        TreeItem[] selectedItem = tree.getSelection();
                        if (selectedItem != null && selectedItem.length > 0) {
                            TreeItem t = selectedItem[0];
                            Object data = t.getData();
                            if (!t.getExpanded() || data instanceof IReferenceControl) {
                                RdvsView.this.refresh(data);
                            } else {
                                t.setExpanded(false);
                            }
                            if (data != null && data instanceof ITreeElements && ((ITreeElements)data).hasChildren()) {
                                tree.setSelection(new TreeItem[0]);
                            }
                        }
                    }
                }
            });
            this.treeViewer.getTree().addListener(42, new Listener(){

                public void handleEvent(Event event) {
                    ITreeElements treeElement;
                    TreeItem item = (TreeItem)event.item;
                    Object oo = item.getData();
                    if (oo instanceof ITreeElements && (treeElement = (ITreeElements)item.getData()).getChildrenNumberForPastille() > 0) {
                        int fontDecrease;
                        boolean isPastileInfo = oo instanceof IPastilleInfo;
                        int x = event.x + event.width;
                        int itemDiametre = RdvsView.this.treeViewer.getTree().getItemHeight() - 3;
                        int y = event.y + 1;
                        try {
                            event.gc.setAntialias(1);
                        }
                        catch (Exception exception) {}
                        try {
                            event.gc.setTextAntialias(1);
                        }
                        catch (Exception exception) {}
                        if (!isPastileInfo) {
                            if (treeElement instanceof ITreeElementsPastille) {
                                Color pastilleColor = ((ITreeElementsPastille)treeElement).getPastilleColor();
                                if (pastilleColor != null) {
                                    event.gc.setBackground(pastilleColor);
                                }
                            } else {
                                event.gc.setBackground(ResourceGetter.getColor((RGB)ResourceGetter.RED_WARNING_COLOR));
                            }
                        }
                        int n = fontDecrease = UI.OS_MAC ? -5 : -3;
                        if (isPastileInfo) {
                            event.gc.drawOval(x, y, itemDiametre, itemDiametre);
                            event.gc.setForeground(ResourceGetter.getColor((int)0, (int)0, (int)0));
                            event.gc.setFont(ResourceGetter.getFontNormal((int)fontDecrease));
                        } else {
                            event.gc.fillOval(x, y, itemDiametre, itemDiametre);
                            event.gc.setForeground(ResourceGetter.getColor((int)255, (int)255, (int)255));
                            event.gc.setFont(ResourceGetter.getFontBold((int)fontDecrease));
                        }
                        String texte = String.valueOf(treeElement.getChildrenNumberForPastille());
                        Point fontSize = event.gc.textExtent(texte);
                        int fontH = fontSize.y;
                        int fontW = fontSize.x;
                        --fontDecrease;
                        while (fontSize.x >= itemDiametre - 2) {
                            if (isPastileInfo) {
                                event.gc.setFont(ResourceGetter.getFontNormal((int)(--fontDecrease)));
                            } else {
                                event.gc.setFont(ResourceGetter.getFontBold((int)(--fontDecrease)));
                            }
                            fontSize = event.gc.textExtent(texte);
                        }
                        fontH = fontSize.y;
                        fontW = fontSize.x;
                        float textHeightCorrection = (float)(itemDiametre - fontH) / 2.0f;
                        float halfWidthText = (float)fontW / 2.0f;
                        float debutText = (float)x + (float)itemDiametre / 2.0f;
                        int startTexte = Math.round(debutText - halfWidthText);
                        event.gc.drawString(texte, startTexte, y + Math.round(textHeightCorrection));
                    }
                }
            });
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, "Erreur", e);
        }
    }

    private void fillToolBar() {
        IToolBarManager manager = this.getViewSite().getActionBars().getToolBarManager();
        manager.removeAll();
        Action actionRefresh = new Action(){

            public void run() {
                RdvsView.this.treeViewer.refresh();
            }
        };
        actionRefresh.setImageDescriptor(ImageDescriptor.createFromImage((Image)ResourceGetter.getImage((String)"images/refresh48.gif")));
        actionRefresh.setToolTipText(Messages.getString((String)"DossierPerspective.refreshListe", (String[])new String[0]));
        manager.add((IAction)actionRefresh);
        ControlsPlugin.fillWithContributionManagerExtensions((IContributionManager)manager, (String)"menu");
        manager.update(true);
    }

    protected void doubleClick(ITreeElements selection) {
        block14: {
            String editorClass = selection.getEditorClass();
            if (editorClass != null) {
                try {
                    if (editorClass.startsWith("VIEW:")) {
                        BaseSearchView.openView(Class.forName(editorClass.substring(5)), (Object)selection);
                        break block14;
                    }
                    IEditorInput editorInput = null;
                    try {
                        IEditorInput input = selection.getEditorInput();
                        if (input != null) {
                            IDataObject dataObject;
                            BaseEditor.openEditor((IEditorInput)input, (String)editorClass);
                            editorInput = input;
                            if (editorInput instanceof EditorInput && ((dataObject = ((EditorInput)editorInput).getDataObject()) instanceof XBaseEncounter || dataObject instanceof XBasePatient || dataObject instanceof XBaseProfessionnal) && dataObject.getId() != null) {
                                new IDDataObject(dataObject.getId(), dataObject.getClass(), "");
                                ObjectUsageAccessorClient.getInstance().setObjectUsed(dataObject.hashCode(), Application.get().getGlobalInstances().getSession(), (ICallback)new Callback((IStatusHandler)DefaultStatusHandler.getInstance()), dataObject);
                            }
                        }
                    }
                    catch (Exception e) {
                        String input;
                        try {
                            input = String.valueOf(editorInput);
                        }
                        catch (Exception e2) {
                            input = e2.getMessage();
                        }
                        logger.log(Level.SEVERE, "Failed to open editor " + editorClass + "with input " + input, e);
                        MessageUtil.unexpectedExceptionMsg((Shell)this.getSite().getShell());
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Erreur lors de l'ouverture de l'editeur de user", e);
                }
            } else if (selection instanceof ITreeElements2) {
                ((ITreeElements2)selection).doDoubleClick();
            } else if (selection.hasChildren()) {
                System.out.println("AVANT this.treeViewer.setExpandedState(selection, !this.treeViewer.getExpandedState(selection));");
                this.treeViewer.setExpandedState(selection, !this.treeViewer.getExpandedState(selection));
            }
        }
    }

    public void refresh(Object element) {
        Object[] expendedElements = this.treeViewer.getExpandedElements();
        if (element instanceof IEditorInput) {
            IEditorInput input = (IEditorInput)element;
            int i = 0;
            while (i < expendedElements.length) {
                ITreeElements treeElement = (ITreeElements)expendedElements[i];
                Object[] children = treeElement.getChildren();
                if (children != null) {
                    int j = 0;
                    while (j < children.length) {
                        IEditorInput elementInput = ((ITreeElements)children[j]).getEditorInput();
                        if (elementInput != null && elementInput.equals(input)) {
                            logger.fine("FOUND FOR REFRESH");
                        }
                        ++j;
                    }
                }
                ++i;
            }
        } else if (element instanceof ITreeElements2) {
            if (this.currentSelection != null) {
                if ("ca.infodata.ofys.ui.person.patient.PatientMultiEditor".equals(this.currentSelection.getEditorClass())) {
                    this.treeViewer.refresh(element);
                    this.treeViewer.expandToLevel(element, 1);
                } else if (this.currentSelection instanceof ITreeElements2) {
                    ((ITreeElements2)this.currentSelection).doDoubleClick();
                    this.treeViewer.setSelection(null);
                } else {
                    this.treeViewer.refresh(element);
                    this.treeViewer.expandToLevel(element, 1);
                }
            }
        } else if (element instanceof ITreeElements) {
            this.treeViewer.refresh(element);
            this.treeViewer.expandToLevel(element, 1);
        } else if (element == null) {
            this.treeViewer.refresh();
        }
    }

    private void initMenuElementOrderList() {
        if (this.menuOrderList == null) {
            this.menuOrderList = new ArrayList<String>();
        }
        this.menuOrderList.clear();
        if (this.menuOrderList.size() == 0) {
            this.menuOrderList.add("ca.infodata.ofys.ui.person.menu.element.LastUsedPatientElements");
            this.menuOrderList.add("ca.infodata.ofys.ui.person.menu.element.ActiveProfessionalElement");
            this.menuOrderList.add("ca.infodata.ofys.ui.chat.menu.ListChatMessageElement");
            this.menuOrderList.add("ca.infodata.ofys.ui.task.menu.ListUserTaskElement");
            this.menuOrderList.add("ca.infodata.ofys.ui.dashboard.DashboardElement");
            this.menuOrderList.add("ca.infodata.ofys.ui.dashboard.DashboardElementExtern");
            this.menuOrderList.add("ca.infodata.ofys.ui.appointment.menu.ListTodayAppointments");
            this.menuOrderList.add("");
        }
    }

    public void refreshFont() {
        this.treeViewer.getTree().setFont(ResourceGetter.getFontNormal((int)this.fontIncrement));
        this.treeViewer.refresh();
    }

    public static void refreshViews(final Object element) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (ControlsPlugin.getDefault().getWorkbench() != null && ControlsPlugin.getDefault().getWorkbench().getWorkbenchWindows().length > 0 && ControlsPlugin.getDefault().getWorkbench().getWorkbenchWindows()[0] != null && ControlsPlugin.getDefault().getWorkbench().getWorkbenchWindows()[0].getPages().length > 0 && ControlsPlugin.getDefault().getWorkbench().getWorkbenchWindows()[0].getPages()[0] != null) {
                    IViewReference[] view = ControlsPlugin.getDefault().getWorkbench().getWorkbenchWindows()[0].getPages()[0].getViewReferences();
                    int i = 0;
                    while (i < view.length) {
                        if (view[i].getView(true) instanceof ICanBeRefreshed) {
                            ((ICanBeRefreshed)view[i].getView(true)).refresh(element);
                        }
                        ++i;
                    }
                }
            }
        });
    }

    public int getSizeFlags(boolean width) {
        return width ? 1156 : 0;
    }

    public int computePreferredSize(boolean width, int availableParallel, int availablePerpendicular, int preferredResult) {
        if (width) {
            if (preferredResult == 0 || preferredResult == Integer.MAX_VALUE) {
                return preferredResult;
            }
            this.viewWidth = preferredResult;
            return preferredResult;
        }
        return preferredResult;
    }
}

