/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.laboresults.editor;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.AppointmentAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.LaboResultsAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus;
import ca.infodata.ofys.data.middle.dataobjects.chat.LINK_TYPE;
import ca.infodata.ofys.data.middle.dataobjects.chat.MessageLink;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XBaseLaboResultsProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboResultsProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboResultsProfessionnalStatus;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboResultsText;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.ControlDecorator;
import ca.infodata.ofys.ui.controls.ControlsPlugin;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.combo.MySimpleCombo;
import ca.infodata.ofys.ui.controls.template.completion.TemplateAssistText;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.laboresults.Messages;
import ca.infodata.ofys.ui.laboresults.editor.LaboResultsBrowserComposite;
import ca.infodata.ofys.ui.laboresults.editor.XAppointmentFormatter;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.person.PersonMultiEditorFactory;
import ca.infodata.ofys.ui.person.patient.PatientMultiEditor;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.readhl7.Doit;
import ca.infodata.util1.ByteSerialiser;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.StringUtils;
import difflib.Delta;
import difflib.DiffUtils;
import difflib.Patch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.time.FastDateFormat;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class LaboViewerComposite
extends Composite {
    private static final Logger logger = Logger.getLogger(LaboViewerComposite.class.getName());
    private static final Pattern patternStringToExtract = Pattern.compile("~(.*?)~");
    private FormToolkit toolkit;
    private final Pattern patternNormalStart = Pattern.compile("([<][p][>])");
    private final Pattern patternNormalEnd = Pattern.compile("([<][/][p][>])");
    private final Pattern patternBoldNormalStart = Pattern.compile("([<][b][p][>])");
    private final Pattern patternBoldNormalEnd = Pattern.compile("([<][/][b][p][>])");
    private final Pattern patternItalicStart = Pattern.compile("([<][i][>])");
    private final Pattern patternItalicEnd = Pattern.compile("([<][/][i][>])");
    private final Pattern patternBoldItalicStart = Pattern.compile("([<][b][i][>])");
    private final Pattern patternBoldItalicEnd = Pattern.compile("([<][/][b][i][>])");
    private static final String ERREUR = Messages.getString("ResultatEditor.ERREUR");
    private static final String SIGNER = Messages.getString("ResultatEditor.SIGNER");
    private static final String SIGNE_RETIRE_RESULTAT_LISTE = Messages.getString("ResultatEditor.SIGNE_RETIRE_RESULTAT_LISTE");
    private static final String A_REGLER = Messages.getString("ResultatEditor.A_REGLER");
    private static final String A_REGLER_TTT = Messages.getString("ResultatEditor.A_REGLER_TTT");
    private static final String OPEN_WITH_FILE = Messages.getString("ResultatEditor.OPEN_WITH_FILE");
    private static final String OPEN_WITH_FILE_TTT = Messages.getString("ResultatEditor.OPEN_WITH_FILE_TTT");
    private static final String NOTE_HISTORIQUE = String.valueOf(Messages.getString("LaboResultsControl.NOTES")) + " - " + Messages.getString("BaseResultatEditor.PROCHAIN_RDVS");
    private Font fontCourrier;
    private Font fontCourrierBold;
    private Font fontArial;
    private Font fontArialBold;
    private Font fontTimesItalique;
    private Font fontTimesBoldItalique;
    private Color red;
    private Color black;
    private Color white;
    private SourceViewer viewer;
    private TemplateAssistText txtNote;
    private MyButton cmdSign;
    private MyButton chkToResolve;
    private MyButton chkOpenWithFile;
    private SourceViewer viewerNotesAndHistoric;
    private TabFolder folder;
    private TabItem tabText;
    private TabItem tabHl7;
    private LaboResultsBrowserComposite webBrowserHl7;
    private Composite compHtml;
    private Composite compText;
    private Section sectionGeneral;
    private MyButton btnPlus;
    private MyButton btnDiff;
    private MySimpleCombo<XLaboResultsText> cmbPrevious;
    private String laboToSearch;
    private XLaboResultsText currentLaboResultsText;
    private XLaboResultsProfessionnal xlaboResultProfessionnal;
    private XBaseLaboResultsProfessionnal xbaseLaboResultProfessionnal;
    private boolean isEditable;
    private final Pattern pattern = Pattern.compile("([ ][B][ ])|([ ][H][ ])|([ ][L][ ])");

    public TemplateAssistText getTxtNote() {
        return this.txtNote;
    }

    public void setTxtNote(TemplateAssistText txtNote) {
        this.txtNote = txtNote;
    }

    public MyButton getCmdSign() {
        return this.cmdSign;
    }

    public MyButton getChkToResolve() {
        return this.chkToResolve;
    }

    public MyButton getChkOpenWithFile() {
        return this.chkOpenWithFile;
    }

    public void setXlaboResultProfessionnal(XLaboResultsProfessionnal xlaboResultProfessionnal) {
        this.xlaboResultProfessionnal = xlaboResultProfessionnal;
        this.showDataObject();
    }

    public void setXbaseLaboResultProfessionnal(XBaseLaboResultsProfessionnal xbaseLaboResultProfessionnal) {
        this.xbaseLaboResultProfessionnal = xbaseLaboResultProfessionnal;
    }

    public LaboViewerComposite(Composite parent, FormToolkit toolkit) {
        super(parent, 0);
        this.toolkit = toolkit;
        this.toolkit.adapt((Composite)this);
        this.isEditable = true;
        this.createMyControl(this);
    }

    public LaboViewerComposite(Composite parent, FormToolkit toolkit, boolean isEditable) {
        super(parent, 0);
        this.toolkit = toolkit;
        this.toolkit.adapt((Composite)this);
        this.isEditable = isEditable;
        this.createMyControl(this);
    }

    private void createMyControl(Composite parent) {
        this.fontCourrier = ResourceGetter.getFont((String)"Courier New", (int)14, (int)0, (boolean)true);
        this.fontCourrierBold = ResourceGetter.getFont((String)"Courier New", (int)14, (int)1, (boolean)true);
        this.fontArial = ResourceGetter.getFont((String)"Arial", (int)12, (int)0, (boolean)true);
        this.fontArialBold = ResourceGetter.getFont((String)"Arial", (int)12, (int)1, (boolean)true);
        this.fontTimesItalique = ResourceGetter.getFont((String)"Times", (int)12, (int)2, (boolean)true);
        this.fontTimesBoldItalique = ResourceGetter.getFont((String)"Times", (int)12, (int)3, (boolean)true);
        this.red = ResourceGetter.getColor((int)255, (int)0, (int)0);
        this.black = ResourceGetter.getColor((int)0, (int)0, (int)0);
        this.white = ResourceGetter.getColor((int)255, (int)255, (int)255);
        ResourceGetter.linkResourceWithWidgetLife((Object)this.fontCourrier, (Widget)parent);
        ResourceGetter.linkResourceWithWidgetLife((Object)this.fontCourrierBold, (Widget)parent);
        ResourceGetter.linkResourceWithWidgetLife((Object)this.fontArial, (Widget)parent);
        ResourceGetter.linkResourceWithWidgetLife((Object)this.fontArialBold, (Widget)parent);
        ResourceGetter.linkResourceWithWidgetLife((Object)this.fontTimesItalique, (Widget)parent);
        ResourceGetter.linkResourceWithWidgetLife((Object)this.fontTimesBoldItalique, (Widget)parent);
        ResourceGetter.linkResourceWithWidgetLife((Object)this.red, (Widget)parent);
        ResourceGetter.linkResourceWithWidgetLife((Object)this.black, (Widget)parent);
        ResourceGetter.linkResourceWithWidgetLife((Object)this.white, (Widget)parent);
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        layout.marginHeight = 5;
        parent.setLayout((Layout)layout);
        this.sectionGeneral = this.toolkit.createSection(parent, 0);
        this.sectionGeneral.setText(NOTE_HISTORIQUE);
        this.toolkit.createCompositeSeparator((Composite)this.sectionGeneral);
        Composite compNote = this.toolkit.createComposite(parent, 0);
        this.txtNote = new TemplateAssistText(compNote, 2626, this.toolkit);
        this.txtNote.setType(XCompletionProposalType.LABO_RESULT_NOTE);
        ControlDecorator.decorateWithEditProposal((TemplateAssistText)this.txtNote, (int)16512);
        this.cmdSign = new MyButton(compNote, SIGNER, 8, this.toolkit);
        this.cmdSign.setToolTipText(SIGNE_RETIRE_RESULTAT_LISTE);
        this.chkToResolve = new MyButton(compNote, A_REGLER, 32, this.toolkit);
        this.chkOpenWithFile = new MyButton(compNote, OPEN_WITH_FILE, 32, this.toolkit);
        this.chkOpenWithFile.setToolTipText(OPEN_WITH_FILE_TTT);
        if (!this.isEditable) {
            this.cmdSign.setVisible(false);
            this.chkToResolve.setEnabled(false);
            this.chkOpenWithFile.setEnabled(false);
            this.txtNote.setEditable(false);
        }
        this.btnPlus = new MyButton(compNote, "+", 8, this.toolkit);
        this.cmbPrevious = new MySimpleCombo(compNote, 8, this.toolkit);
        this.cmbPrevious.setLabelProvider((ProviderAR)new ProviderAR<XLaboResultsText, String>(){

            public String get(XLaboResultsText labo) {
                XLaboResultsText main;
                XLaboResultsProfessionnal labop = LaboViewerComposite.this.getLaboResultsProfessionnal();
                XLaboResultsText xLaboResultsText = main = labop == null ? null : labop.getLaboResults();
                if (main != null && labo.getId().equals(main.getId())) {
                    return "*" + labo.getId();
                }
                return String.valueOf(labo.getId());
            }
        });
        this.btnDiff = new MyButton(compNote, "D", 2, this.toolkit);
        this.btnDiff.setToolTipText(Messages.getString("MONTRER_QUE_DIFF"));
        this.viewerNotesAndHistoric = new SourceViewer(compNote, null, 2626);
        this.viewerNotesAndHistoric.setEditable(false);
        this.folder = new TabFolder(parent, 0);
        this.tabText = new TabItem(this.folder, 0);
        this.tabText.setText("Texte");
        this.compText = new Composite((Composite)this.folder, 0);
        this.compText.setLayout((Layout)new FormLayout());
        this.viewer = new SourceViewer(this.compText, null, 2818);
        this.viewer.setEditable(false);
        this.viewer.getTextWidget().setDoubleClickEnabled(true);
        this.tabHl7 = new TabItem(this.folder, 0);
        this.tabHl7.setText("HTML");
        this.compHtml = new Composite((Composite)this.folder, 0);
        this.compHtml.setLayout((Layout)new FillLayout());
        this.tabHl7.setControl((Control)this.compHtml);
        this.tabText.setControl((Control)this.compText);
        this.webBrowserHl7 = new LaboResultsBrowserComposite(this.compHtml, 0);
        Point ptOpen = this.chkOpenWithFile.getControl().computeSize(-1, -1);
        Point ptRegler = this.chkToResolve.getControl().computeSize(-1, -1);
        Point ptSign = this.cmdSign.getControl().computeSize(-1, -1);
        Point ptPrev = this.cmbPrevious.getControl().computeSize(-1, -1);
        float f = 1.0f;
        int iOpen = (int)((float)ptOpen.y * f);
        int iReg = (int)((float)ptRegler.y * f);
        int iSign = (int)((float)ptSign.y * f);
        int iPrev = (int)((float)ptPrev.y * f);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.sectionGeneral.setLayoutData((Object)data);
        FormLayout compNoteLayout = new FormLayout();
        compNoteLayout.spacing = 2;
        compNote.setLayout((Layout)compNoteLayout);
        data = new FormData();
        data.top = new FormAttachment((Control)this.sectionGeneral);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.height = iOpen + iReg + iSign + iPrev + compNoteLayout.spacing * 3;
        compNote.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)compNote, 0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.folder.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.compText.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.compHtml.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)compNote, 2);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.viewer.getTextWidget().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(50, -100);
        data.bottom = new FormAttachment(100);
        this.txtNote.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(this.txtNote.getControl());
        data.width = ptOpen.x + 20;
        data.height = iSign;
        this.cmdSign.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.cmdSign.getControl(), 0);
        data.left = new FormAttachment(this.txtNote.getControl(), 3);
        data.right = new FormAttachment(this.cmdSign.getControl(), 0, 131072);
        data.height = iReg;
        this.chkToResolve.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.chkToResolve.getControl(), 0);
        data.left = new FormAttachment(this.txtNote.getControl(), 3);
        data.right = new FormAttachment(this.cmdSign.getControl(), 0, 131072);
        data.height = iOpen;
        this.chkOpenWithFile.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.chkOpenWithFile.getControl(), 0);
        data.left = new FormAttachment(this.txtNote.getControl());
        data.width = 20;
        data.height = iPrev;
        this.btnPlus.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.chkOpenWithFile.getControl(), 0);
        data.width = 20;
        data.right = new FormAttachment(this.viewerNotesAndHistoric.getControl());
        data.height = iPrev;
        this.btnDiff.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.chkOpenWithFile.getControl(), 0);
        data.left = new FormAttachment(this.btnPlus.getControl(), 0);
        data.right = new FormAttachment(this.btnDiff.getControl());
        data.height = iPrev;
        this.cmbPrevious.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(this.cmdSign.getControl(), 1);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100, 0);
        this.viewerNotesAndHistoric.getControl().setLayoutData((Object)data);
        this.bindValues();
    }

    private void bindValues() {
        this.btnPlus.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XSession session = Application.get().getGlobalInstances().getSession();
                String labNo = LaboViewerComposite.this.getLaboResultsProfessionnal().getLaboResults().getLabNo();
                JobCallback callback = null;
                try {
                    try {
                        callback = new JobCallback(Messages.getString("CHARGEMENT"), (IStatusHandler)DefaultStatusHandler.getInstance()){

                            public void responseReceived(final ReturnObject response) {
                                if (response != null && response.getObj() != null) {
                                    Display.getDefault().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            List list = (List)response.getObj();
                                            LaboViewerComposite.this.cmbPrevious.setItems(list);
                                            LaboViewerComposite.this.cmbPrevious.select((Object)LaboViewerComposite.this.getLaboResultsText());
                                        }
                                    });
                                }
                            }
                        };
                        LaboResultsAccessorClient.getInstance().findPartialLaboResultsText(session, (ICallback)callback, labNo);
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, "Erreur", ex);
                        if (callback != null) {
                            callback.kill();
                        }
                    }
                }
                finally {
                    if (callback != null) {
                        callback.kill();
                    }
                }
            }
        });
        this.btnDiff.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LaboViewerComposite.this.showLaboResultsText();
            }
        });
        this.cmbPrevious.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LaboViewerComposite.this.currentLaboResultsText = (XLaboResultsText)LaboViewerComposite.this.cmbPrevious.getSelection();
                LaboViewerComposite.this.showDataObject();
            }
        });
    }

    private XLaboResultsText getLaboResultsText() {
        XLaboResultsProfessionnal labop = this.getLaboResultsProfessionnal();
        return this.currentLaboResultsText == null ? (labop == null ? null : labop.getLaboResults()) : this.currentLaboResultsText;
    }

    private XLaboResultsText getPrevLaboResultsText() {
        XLaboResultsProfessionnal labop = this.getLaboResultsProfessionnal();
        return labop == null ? null : labop.getPreviousLaboResultsSeen();
    }

    private StyleRange[] getStyleRange(String texte) {
        TextStyle style = new TextStyle();
        String texteR = StringUtils.reverse((String)texte);
        ArrayList<StyleRange> l = new ArrayList<StyleRange>();
        int newStart = 0;
        int textLen = texte.length();
        Matcher m = this.pattern.matcher(texte);
        StyleRange sr = new StyleRange(style);
        sr.start = newStart;
        sr.length = textLen;
        sr.font = this.fontCourrier;
        int horsRange = newStart;
        int startSr1 = -1;
        while (m.find()) {
            StyleRange sra;
            int start = textLen - StringUtils.indexOf((String)texteR, (String)"\n", (int)(textLen - m.start()));
            int fin = StringUtils.indexOf((String)texte, (String)"\n", (int)m.start());
            if (fin <= start || startSr1 == start) continue;
            startSr1 = start;
            if (horsRange + 2 < start) {
                sra = new StyleRange(horsRange, start - horsRange - 1, this.black, null);
                sra.font = this.fontCourrier;
                l.add(sra);
            }
            horsRange = fin + 1;
            sra = new StyleRange(start, fin - start, this.red, null);
            sra.font = this.fontCourrierBold;
            l.add(sra);
        }
        if (horsRange < texte.length()) {
            StyleRange sra = new StyleRange(horsRange, texte.length() - horsRange - 1, this.black, null);
            sra.font = this.fontCourrier;
            l.add(sra);
        }
        StyleRange[] srs = new StyleRange[l.size()];
        int i = 0;
        Iterator iterator = l.iterator();
        while (iterator.hasNext()) {
            StyleRange sr1;
            srs[i] = sr1 = (StyleRange)iterator.next();
            ++i;
        }
        return srs;
    }

    private void setLaboToSearch(String laboToSearch) {
        this.laboToSearch = laboToSearch;
    }

    public String getLaboToSearch() {
        return this.laboToSearch;
    }

    public void showDataObject() {
        XLaboResultsProfessionnal resultProfessionnal = this.getLaboResultsProfessionnal();
        XLaboResultsText laboResultsText = this.getLaboResultsText();
        boolean textEquals = false;
        this.btnDiff.setSelection(false);
        if (resultProfessionnal == null) {
            this.txtNote.getStyledText().setText("");
            this.txtNote.setEnabled(false);
            this.cmdSign.setEnabled(false);
            this.btnDiff.setEnabled(false);
            this.btnDiff.setSelection(false);
            this.cmbPrevious.setEnabled(false);
            this.chkToResolve.setSelection(false);
            this.chkToResolve.setEnabled(false);
            this.chkOpenWithFile.setSelection(false);
            this.chkOpenWithFile.setEnabled(false);
            this.viewerNotesAndHistoric.setDocument(null);
            this.viewer.setDocument(null);
            this.webBrowserHl7.setPatient(null);
            this.webBrowserHl7.setHtml("");
        } else {
            this.sectionGeneral.setText(String.valueOf(NOTE_HISTORIQUE) + " ...");
            this.showFuturAppointments(this.getPatient(), this.sectionGeneral);
            textEquals = MiscUtil.areObjectsEquals((Object)laboResultsText, (Object)resultProfessionnal.getLaboResults());
            this.txtNote.setEnabled(textEquals);
            this.chkToResolve.setEnabled(textEquals);
            this.chkOpenWithFile.setEnabled(textEquals);
            this.cmbPrevious.setEnabled(true);
            this.cmdSign.setEnabled(resultProfessionnal.getSignedDatetime() == null);
            this.btnDiff.setEnabled(true);
            if (textEquals) {
                this.txtNote.setText(resultProfessionnal.getNote());
            }
            this.chkToResolve.setSelection(resultProfessionnal.getStatus().contains(XLaboResultsProfessionnalStatus.TO_RESOLVE));
            this.chkToResolve.setEnabled(this.isEditable);
            this.chkOpenWithFile.setSelection(resultProfessionnal.getStatus().contains(XLaboResultsProfessionnalStatus.OPEN_WITH_FILE));
            this.chkOpenWithFile.setEnabled(this.isEditable);
            String texte = resultProfessionnal.getNotesHistory();
            Matcher matcher = patternStringToExtract.matcher(texte);
            while (matcher.find()) {
                String extractedStringKey = matcher.group(1);
                texte = StringUtils.replace((String)texte, (String)("~" + extractedStringKey + "~"), (String)ca.infodata.ofys.data.middle.dataobjects.Messages.getString((String)extractedStringKey, (String[])new String[0]));
            }
            try {
                StringBuilder newTexte = new StringBuilder();
                TextStyle style = new TextStyle();
                ArrayList<StyleRange> l = new ArrayList<StyleRange>();
                int newStart = 0;
                Matcher mns = this.patternNormalStart.matcher(texte);
                Matcher mne = this.patternNormalEnd.matcher(texte);
                Matcher mbns = this.patternBoldNormalStart.matcher(texte);
                Matcher mbne = this.patternBoldNormalEnd.matcher(texte);
                Matcher mis = this.patternItalicStart.matcher(texte);
                Matcher mie = this.patternItalicEnd.matcher(texte);
                Matcher mbis = this.patternBoldItalicStart.matcher(texte);
                Matcher mbie = this.patternBoldItalicEnd.matcher(texte);
                StyleRange sra = new StyleRange(style);
                int lastSrEnd = 0;
                HashMap<Integer, String> mapText = new HashMap<Integer, String>();
                HashMap<Integer, Font> mapFont = new HashMap<Integer, Font>();
                String temp = "";
                while (mns.find(newStart)) {
                    mne.find(newStart);
                    temp = texte.substring(mns.end(), mne.start());
                    mapText.put(new Integer(mne.start()), temp);
                    mapFont.put(new Integer(mne.start()), this.fontArial);
                    newStart = mne.end();
                }
                newStart = 0;
                while (mbns.find(newStart)) {
                    mbne.find(newStart);
                    temp = texte.substring(mbns.end(), mbne.start());
                    mapText.put(new Integer(mbne.start()), temp);
                    mapFont.put(new Integer(mbne.start()), this.fontArialBold);
                    newStart = mbne.end();
                }
                newStart = 0;
                while (mis.find(newStart)) {
                    mie.find(newStart);
                    temp = texte.substring(mis.end(), mie.start());
                    mapText.put(new Integer(mie.start()), temp);
                    mapFont.put(new Integer(mie.start()), this.fontTimesItalique);
                    newStart = mie.end();
                }
                newStart = 0;
                while (mbis.find(newStart)) {
                    mbie.find(newStart);
                    temp = texte.substring(mbis.end(), mbie.start());
                    mapText.put(new Integer(mbie.start()), temp);
                    mapFont.put(new Integer(mbie.start()), this.fontTimesBoldItalique);
                    newStart = mbie.end();
                }
                ArrayList keys = new ArrayList(mapText.keySet());
                Collections.sort(keys);
                for (Integer ii : keys) {
                    temp = (String)mapText.get(ii);
                    newTexte.append(String.valueOf(temp) + "\n");
                    sra = new StyleRange(lastSrEnd, newTexte.length() - lastSrEnd, this.black, null);
                    sra.font = (Font)mapFont.get(ii);
                    l.add(sra);
                    lastSrEnd = newTexte.length();
                }
                StyleRange[] srs = new StyleRange[l.size()];
                int i = 0;
                Iterator iterator = l.iterator();
                while (iterator.hasNext()) {
                    StyleRange sr1;
                    srs[i] = sr1 = (StyleRange)iterator.next();
                    ++i;
                }
                Document doc = new Document(newTexte.toString());
                this.viewerNotesAndHistoric.setDocument((IDocument)doc);
                this.viewerNotesAndHistoric.getTextWidget().setStyleRanges(srs);
            }
            catch (Exception e) {
                Document doc = new Document(texte);
                this.viewerNotesAndHistoric.setDocument((IDocument)doc);
                this.viewerNotesAndHistoric.getTextWidget().setStyleRanges(null);
                logger.log(Level.SEVERE, ERREUR, e);
            }
            if (!MiscUtil.areObjectsEquals((Object)laboResultsText, (Object)resultProfessionnal.getLaboResults())) {
                this.txtNote.setEnabled(false);
                this.chkToResolve.setEnabled(false);
                this.btnDiff.setEnabled(false);
            }
        }
        this.showLaboResultsText();
    }

    private void showFuturAppointments(IPatient patient, final Section section) {
        block6: {
            if (patient != null && patient.getId() != null) {
                JobCallback callback = new JobCallback(Messages.getString("RECHERCHE"), ControlsPlugin.getDefaultStatusHandler()){

                    public void responseReceived(final ReturnObject response) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!section.isDisposed()) {
                                    if (response == null || response.getObj() == null) {
                                        section.setText(String.valueOf(NOTE_HISTORIQUE) + ca.infodata.ofys.data.middle.dataobjects.Messages.getString((String)"Print.AUCUN", (String[])new String[0]));
                                    } else {
                                        List appointments = (List)response.getObj();
                                        if (appointments == null) {
                                            section.setText(String.valueOf(NOTE_HISTORIQUE) + ca.infodata.ofys.data.middle.dataobjects.Messages.getString((String)"Print.AUCUN", (String[])new String[0]));
                                        } else {
                                            Iterator iterator = appointments.iterator();
                                            while (iterator.hasNext()) {
                                                XAppointment a = (XAppointment)iterator.next();
                                                if (!Boolean.TRUE.equals(a.getIsDeleted()) && a.getPatientStatus() != XPatientStatus.CANCEL && a.getPatientStatus() != XPatientStatus.CANCEL_LESS_24H) continue;
                                                iterator.remove();
                                            }
                                            if (appointments.isEmpty()) {
                                                section.setText(String.valueOf(NOTE_HISTORIQUE) + ca.infodata.ofys.data.middle.dataobjects.Messages.getString((String)"Print.AUCUN", (String[])new String[0]));
                                            } else {
                                                section.setText(String.valueOf(NOTE_HISTORIQUE) + XAppointmentFormatter.format((XAppointment)appointments.get(0), true, true, false, false, true));
                                            }
                                        }
                                    }
                                }
                            }
                        });
                    }
                };
                try {
                    AppointmentAccessorClient.getInstance().findFutureAppointmentsByPatient(((Object)((Object)this)).hashCode(), Application.get().getGlobalInstances().getSession(), (ICallback)callback, patient.getId().intValue());
                }
                catch (CannotConnectToServerException cannotConnectToServerException) {
                    if (callback != null && !callback.killed()) {
                        callback.kill();
                    }
                    break block6;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to find futures appointments for patient " + patient.getId(), e);
                    if (callback != null && !callback.killed()) {
                        callback.kill();
                    }
                    break block6;
                }
            }
            section.setText(String.valueOf(NOTE_HISTORIQUE) + ca.infodata.ofys.data.middle.dataobjects.Messages.getString((String)"Print.AUCUN", (String[])new String[0]));
        }
    }

    private void showLaboResultsText() {
        boolean showDiff = this.btnDiff.getSelection();
        XLaboResultsText result = this.getLaboResultsText();
        if (result == null) {
            this.chkToResolve.setToolTipText("...");
            this.viewer.setDocument(null);
            this.webBrowserHl7.setPatient(null);
            this.webBrowserHl7.setHtml("");
        } else {
            this.webBrowserHl7.setPatient((IPatient)result.getPatient());
            this.chkToResolve.setToolTipText(String.valueOf(A_REGLER_TTT) + " " + (result.getProfessionnal() == null ? "-" : result.getProfessionnal().getName()));
            boolean hasText = false;
            boolean hasHl7 = false;
            if (result.getTextValueCompressed() != null && result.getTextValueCompressed().length > 10) {
                hasText = true;
                String texte = (String)ByteSerialiser.deserialize((byte[])result.getTextValueCompressed());
                if (texte == null) {
                    texte = "Invalid text";
                }
                Document doc = new Document(texte);
                this.viewer.setDocument((IDocument)doc);
                try {
                    this.viewer.getTextWidget().setStyleRanges(this.getStyleRange(texte));
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, ERREUR, e);
                    TextStyle style = new TextStyle();
                    StyleRange sr = new StyleRange(style);
                    sr.start = 0;
                    sr.length = texte.length();
                    sr.font = this.fontCourrier;
                    this.viewer.getTextWidget().setStyleRanges(new StyleRange[]{sr});
                }
            }
            if (result.getHl7ValueCompressed() != null) {
                hasHl7 = true;
                String hl7 = (String)ByteSerialiser.deserialize((byte[])result.getHl7ValueCompressed());
                Doit d = new Doit();
                String htmlText = d.getHtmlFromHl7(hl7);
                String printedBy = String.valueOf(ca.infodata.ofys.data.middle.dataobjects.Messages.getString((String)"PRINTED_BY", (String[])new String[0])) + " " + LibPlugin.getUserName() + " " + FastDateFormat.getInstance((String)(String.valueOf(FormatDateProvider.getFormatDate().toString()) + " HH:mm")).format(new Date()) + " - " + ca.infodata.ofys.data.middle.dataobjects.Messages.getString((String)"CONFIDENTIAL", (String[])new String[0]);
                htmlText = StringUtils.replaceOnce((String)htmlText, (String)"print-by-and-date-time", (String)printedBy);
                Patch patch = null;
                String hl7Prev = "";
                String htmlTextPrev = "";
                if (showDiff) {
                    XLaboResultsText prevResult = this.getPrevLaboResultsText();
                    if (prevResult != null && prevResult.getHl7ValueCompressed() != null) {
                        hl7Prev = (String)ByteSerialiser.deserialize((byte[])prevResult.getHl7ValueCompressed());
                        String splitChar = "([\n]|[\r]|[\r\n])";
                        List<String> original = Arrays.asList(hl7Prev.split(splitChar));
                        String mshLine = "";
                        String pidLine = "";
                        String orcLine = "";
                        for (String os : original) {
                            if (os.startsWith("MSH")) {
                                mshLine = os;
                                continue;
                            }
                            if (os.startsWith("PID")) {
                                pidLine = os;
                                break;
                            }
                            if (!os.startsWith("ORC")) continue;
                            orcLine = os;
                            break;
                        }
                        List<String> revised = Arrays.asList(hl7.split(splitChar));
                        patch = DiffUtils.diff(original, revised);
                        StringBuilder hl7Diff = new StringBuilder();
                        boolean mshDone = false;
                        boolean pidDone = false;
                        boolean orcDone = false;
                        String saut = "\r\n";
                        for (Delta delta : patch.getDeltas()) {
                            for (Object l : delta.getRevised().getLines()) {
                                String sl = (String)l;
                                if (!mshDone) {
                                    if (sl.startsWith("MSH")) {
                                        hl7Diff.append(String.valueOf(sl) + saut);
                                    } else if (!mshDone) {
                                        hl7Diff.append(String.valueOf(mshLine) + saut);
                                    }
                                    mshDone = true;
                                    continue;
                                }
                                if (!pidDone) {
                                    pidDone = true;
                                    if (sl.startsWith("PID")) {
                                        hl7Diff.append(String.valueOf(sl) + saut);
                                        continue;
                                    }
                                    hl7Diff.append(String.valueOf(pidLine) + saut);
                                    if (sl.startsWith("ORC")) {
                                        orcDone = true;
                                    }
                                    hl7Diff.append(String.valueOf(sl) + saut);
                                    continue;
                                }
                                if (!orcDone) {
                                    orcDone = true;
                                    if (sl.startsWith("ORC")) {
                                        hl7Diff.append(String.valueOf(sl) + saut);
                                        continue;
                                    }
                                    hl7Diff.append(String.valueOf(orcLine) + saut);
                                    continue;
                                }
                                hl7Diff.append(String.valueOf(sl) + saut);
                            }
                        }
                        htmlTextPrev = hl7Diff.toString();
                        htmlTextPrev = d.getHtmlFromHl7(htmlTextPrev);
                        htmlTextPrev = StringUtils.replaceOnce((String)htmlTextPrev, (String)"print-by-and-date-time", (String)printedBy);
                        htmlTextPrev = StringUtils.replace((String)htmlTextPrev, (String)"\"#DADAFF\"", (String)"\"#FFFFF0\"");
                        this.loadWebBrowser(htmlTextPrev);
                    } else {
                        this.loadWebBrowser(htmlText);
                    }
                } else {
                    this.loadWebBrowser(htmlText);
                }
                if (Application.get().getGlobalInstances().inDebugMode()) {
                    Document doc = new Document(hl7);
                    this.viewer.setDocument((IDocument)doc);
                }
            }
            if (!(hasText || hasHl7 && Application.get().getGlobalInstances().inDebugMode())) {
                this.viewer.setDocument(null);
            }
            if (!hasHl7) {
                this.webBrowserHl7.setHtml("");
            }
            if (hasText) {
                this.folder.setSelection(this.tabText);
            } else if (hasHl7) {
                this.folder.setSelection(this.tabHl7);
            }
        }
    }

    public Image getEditorTitleImage() {
        return ResourceGetter.getImage((String)"images/pechere.gif");
    }

    private void loadWebBrowser(String htmlText) {
        this.webBrowserHl7.setHtml(htmlText);
    }

    public MessageLink getMessageLink() {
        MessageLink ml = null;
        if (this.getLaboResultsProfessionnal() != null && this.getLaboResultsProfessionnal().getId() != null) {
            ml = new MessageLink(this.getPatient(), LINK_TYPE.LABO, this.getLaboResultsProfessionnal().getId());
        }
        return ml;
    }

    public void openPatient() {
        if (this.getPatient() != null) {
            if (Application.get().getGlobalInstances().getSession() != null && Application.get().getGlobalInstances().getSession().getClientPreferences() != null && Application.get().getGlobalInstances().getSession().getClientPreferences().isMultiplePatientWindows()) {
                PersonMultiEditorFactory.openPatient((IPatient)this.getPatient());
            } else {
                BaseEditor.openEditorSafe((IEditorInput)new EditorInput((IDataObject)this.getPatient()), (String)PatientMultiEditor.class.getName());
            }
        }
    }

    public IPatient getPatient() {
        XBaseLaboResultsProfessionnal baseLabo;
        XLaboResultsText labo2;
        Object patient = null;
        XLaboResultsProfessionnal labo = this.getLaboResultsProfessionnal();
        patient = labo != null ? ((labo2 = labo.getLaboResults()) == null ? null : labo2.getPatient()) : ((baseLabo = this.getBaseLaboResultsProfessionnal()) == null ? null : baseLabo.getPatient());
        return patient;
    }

    private XLaboResultsProfessionnal getLaboResultsProfessionnal() {
        return this.xlaboResultProfessionnal;
    }

    private XBaseLaboResultsProfessionnal getBaseLaboResultsProfessionnal() {
        return this.xbaseLaboResultProfessionnal;
    }

    public MySimpleCombo<XLaboResultsText> getCmbPrevious() {
        return this.cmbPrevious;
    }

    public Control getControl() {
        return this;
    }

    public void setInput(Object input, Object ... args) {
        if (input instanceof XLaboResultsProfessionnal) {
            this.setXlaboResultProfessionnal((XLaboResultsProfessionnal)input);
        }
    }
}

