/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.intro.login;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.ui.controls.FontAwareButton;
import ca.infodata.ofys.ui.library.UI;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class LegalDialog {
    private Shell shell;
    private Browser browser;
    private FontAwareButton btnAccept;
    private FontAwareButton btnCancel;
    private Iterator<String> urlsIterator;
    private int urlsSize;
    private int urlsIndex;

    public LegalDialog(Shell parent, List<String> urls) {
        this.urlsIterator = urls.iterator();
        this.urlsSize = urls.size();
        this.urlsIndex = 0;
        this.shell = new Shell(parent, 67696);
        this.browser = new Browser((Composite)this.shell, 2048);
        this.browser.setUrl(this.urlsIterator.next());
        Label separator = new Label((Composite)this.shell, 258);
        this.btnAccept = new FontAwareButton((Composite)this.shell, 8);
        this.btnAccept.setFont(2, 1);
        this.updateBtnAcceptText();
        this.btnAccept.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LegalDialog.this.onAccept();
            }
        });
        this.btnCancel = new FontAwareButton((Composite)this.shell, 8);
        this.btnCancel.setFont(2, 1);
        this.btnCancel.setText(Messages.getString((String)"NON", (String[])new String[0]));
        this.btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LegalDialog.this.close();
            }
        });
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginRight = 3;
        layout.marginBottom = 5;
        this.shell.setLayout((Layout)layout);
        FormData data = new FormData();
        data.bottom = new FormAttachment(100);
        data.right = new FormAttachment((Control)this.btnCancel);
        this.btnAccept.setLayoutData((Object)data);
        data = new FormData();
        data.bottom = new FormAttachment(100);
        data.right = new FormAttachment(100);
        this.btnCancel.setLayoutData((Object)data);
        data = new FormData();
        data.bottom = new FormAttachment((Control)this.btnAccept);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        separator.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment((Control)separator);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.browser.setLayoutData((Object)data);
        UI.packAsParentDialog((Shell)this.shell, (Composite)this.shell.getParent(), (float)0.7f);
        UI.centerComposite((Composite)this.shell, (Composite)parent);
        this.shell.open();
        UI.waitForWindowToClose((Shell)this.shell);
    }

    protected void updateBtnAcceptText() {
        String suffix = String.format(" (%s " + Messages.getString((String)"DE", (String[])new String[0]).toLowerCase() + " %s)", this.urlsIndex + 1, this.urlsSize);
        this.btnAccept.setText(String.valueOf(Messages.getString((String)"OUI_JE_COMPRENDS_ET_ACCEPTE", (String[])new String[0])) + suffix);
    }

    public void onAccept() {
        if (this.urlsIterator.hasNext()) {
            this.browser.setUrl(this.urlsIterator.next());
            ++this.urlsIndex;
            this.updateBtnAcceptText();
            this.browser.setFocus();
        } else {
            this.onAcceptFinal();
        }
    }

    public abstract void onAcceptFinal();

    public void close() {
        this.shell.close();
    }

    public void setUrl(String url) {
        this.browser.setUrl(url);
    }

    public boolean isDisposed() {
        return this.shell.isDisposed();
    }
}

