/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.intro.login;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.ui.intro.OfysLauncherStreamGobbler;
import ca.infodata.ofys.ui.intro.PerspectiveManager;
import ca.infodata.ofys.ui.library.DaemonThread;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class LauncherTool {
    private static final Logger logger = Logger.getLogger(LauncherTool.class.getName());
    private File installFolder = new File(Platform.getLocation().toString()).getParentFile();
    private File launcherFolder = new File(this.installFolder, "launcher");
    private File launcherFile = new File(this.launcherFolder, "OfysLauncher.jar");
    private String launcherFilePath = this.launcherFile.getAbsolutePath();

    public LauncherTool() {
        if (!this.launcherFile.exists() && !Application.get().getGlobalInstances().inDebugMode()) {
            logger.log(Level.WARNING, "Erreur", String.valueOf(this.launcherFilePath) + " est absent...");
        }
    }

    public boolean isInstalledVersionValid() {
        OfysLauncherStreamGobbler.VersionInfo version;
        boolean valid = this.launcherFilePath != null ? ((version = this.getInstalledVersionInfo()) == null ? true : !Boolean.TRUE.equals(version.mustUpdateNow) && !Boolean.TRUE.equals(version.updateAvailabled)) : true;
        return valid;
    }

    private OfysLauncherStreamGobbler.VersionInfo getInstalledVersionInfo() {
        OfysLauncherStreamGobbler.VersionInfo versionInfo = null;
        if (this.launcherFilePath != null) {
            String[] command = new String[]{"java", "-jar", this.launcherFilePath, "-versioninfo", "-need-normal-stream"};
            try {
                Process proc = Runtime.getRuntime().exec(command);
                final OfysLauncherStreamGobbler errputGobbler = new OfysLauncherStreamGobbler(proc.getErrorStream(), "A ERR");
                DaemonThread errT = new DaemonThread(new Runnable(){

                    @Override
                    public void run() {
                        errputGobbler.getProp();
                    }
                });
                errT.start();
                OfysLauncherStreamGobbler outputGobbler = new OfysLauncherStreamGobbler(proc.getInputStream(), "A OUT");
                versionInfo = outputGobbler.getProp();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Erreur", e);
            }
        }
        return versionInfo;
    }

    public void doRestart() throws Exception {
        if (this.launcherFilePath == null) {
            throw new IllegalStateException("no launcher found");
        }
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            String[] command3 = new String[]{"java", "-jar", this.launcherFilePath, "-wait"};
            Runtime.getRuntime().exec(command3);
            PerspectiveManager.closeAll(true);
            workbench.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to run launcher in restart mode", e);
        }
    }

    public void forceUpdate() throws Exception {
        if (this.launcherFilePath == null) {
            throw new IllegalStateException("no launcher found");
        }
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            String[] command3 = new String[]{"java", "-jar", this.launcherFilePath, "-update-ofys", "-wait"};
            Runtime.getRuntime().exec(command3);
            PerspectiveManager.closeAll(true);
            workbench.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to run launcher in update mode", e);
        }
    }
}

