/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.intro;

import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.ui.intro.IntroPlugin;
import ca.infodata.ofys.ui.library.UI;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class DefaultStatusHandler
implements IStatusHandler {
    private static final Logger logger = Logger.getLogger(DefaultStatusHandler.class.getName());
    private static DefaultStatusHandler instance = new DefaultStatusHandler();

    public static IStatusHandler.State handle(ReturnObject response) {
        try {
            DefaultStatusHandler handler = DefaultStatusHandler.getInstance();
            if (response != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "handler=" + String.valueOf(handler) + " status=" + String.valueOf(response.getStatus()));
                }
                return handler.handle((IStatus)response.getStatus());
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in status handling.", e);
        }
        return IStatusHandler.State.NOT_HANDLED;
    }

    public static DefaultStatusHandler getInstance() {
        return instance;
    }

    public boolean nullOrOkStatus(IStatus status) {
        return status == null || status.isOK();
    }

    public IStatusHandler.State handle(IStatus status) {
        if (this.nullOrOkStatus(status)) {
            return IStatusHandler.State.NOT_HANDLED;
        }
        EnumSet<IStatusHandler.State> state = this.handleSpecialStatuses(status);
        if (state.size() == 1) {
            this.handleBaseStatuses(status, state);
        }
        if (state.contains(IStatusHandler.State.HANDLED_POSITIVE)) {
            return IStatusHandler.State.HANDLED_POSITIVE;
        }
        if (state.contains(IStatusHandler.State.HANDLED_NEGATIVE)) {
            return IStatusHandler.State.HANDLED_NEGATIVE;
        }
        if (state.contains(IStatusHandler.State.HANDLED)) {
            return IStatusHandler.State.HANDLED;
        }
        return IStatusHandler.State.NOT_HANDLED;
    }

    protected void handleBaseStatuses(IStatus status, EnumSet<IStatusHandler.State> state) {
        state.add(this.show(status));
    }

    protected EnumSet<IStatusHandler.State> handleSpecialStatuses(IStatus status) {
        EnumSet<IStatusHandler.State> state = EnumSet.of(IStatusHandler.State.NOT_HANDLED);
        state.add(this.show(status.getStatus("BAD_PASSWORD_BAD_LOGIN")));
        state.add(this.show(status.getStatus("PASSWORD_EXPIRED")));
        state.add(this.show(status.getStatus("SECURITY_VALIDATION_FAILED")));
        state.add(this.show(status.getStatus("SECURITY_AUTOLOG_FAILED")));
        state.add(this.show(status.getStatus("OTHER_SESSION_ON_SAME_STATION")));
        state.add(this.show(status.getStatus("OTHER_SESSION_FOR_SAME_USER_DO_LOGIN")));
        state.add(this.handleOtherSessionForSameUserDoLogout(status));
        state.add(this.handleNoActiveSessionFoundDoLogout(status));
        state.add(this.show(status.getStatus("MAXIMUM_ACTIVE_SESSION_FOR_ROLE_HAS_BEEN_REACHED")));
        state.add(this.show(status.getStatus("CLIENT_DOES_NOT_EXIST")));
        state.add(this.show(status.getStatus(IStatus.Severity.NEED_MORE_INFO)));
        return state;
    }

    private IStatusHandler.State handleOtherSessionForSameUserDoLogout(IStatus pStatus) {
        IStatus status = pStatus.getStatus("OTHER_SESSION_FOR_SAME_USER_DO_LOGOUT");
        if (status != null) {
            this.show(status);
            try {
                UI.genericExecuteCommand((AbstractUIPlugin)IntroPlugin.getDefault(), (String)"ca.infodata.ofys.ui.intro.commands.logoutCommand");
            }
            catch (Exception exception) {}
            return IStatusHandler.State.HANDLED;
        }
        return IStatusHandler.State.NOT_HANDLED;
    }

    private IStatusHandler.State handleNoActiveSessionFoundDoLogout(IStatus pStatus) {
        IStatus status = pStatus.getStatus("NO_ACTIVE_SESSION_FOUND");
        if (status != null) {
            this.show(status);
            try {
                UI.genericExecuteCommand((AbstractUIPlugin)IntroPlugin.getDefault(), (String)"ca.infodata.ofys.ui.intro.commands.logoutCommand");
            }
            catch (Exception exception) {}
            return IStatusHandler.State.HANDLED;
        }
        return IStatusHandler.State.NOT_HANDLED;
    }

    public IStatusHandler.State show(final IStatus status) {
        final IStatusHandler.State[] response = new IStatusHandler.State[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                response[0] = MessageUtil.show((IStatus)status);
            }
        });
        return response[0];
    }
}

