/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.help;

import ca.infodata.ofys.data.dataaccess.service.keyset.KeysetAccessorClient;
import ca.infodata.ofys.ui.help.HelpDialog;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.StringUtils;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class HelpHandler
extends AbstractHandler {
    private static final Logger logger = Logger.getLogger(HelpHandler.class.getName());
    private HelpDialog dialog;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = UI.getWorkbenchShell();
        String activePartId = HandlerUtil.getActivePartId((ExecutionEvent)event);
        String section = event.getParameter("section");
        boolean modal = Boolean.valueOf(event.getParameter("modal"));
        if (StringUtils.isBlank((CharSequence)section)) {
            section = "guide.html";
        }
        String base = "https://osticket.ofys.net/kb/index.php?";
        String url = null;
        if (activePartId != null) {
            try {
                url = KeysetAccessorClient.getInstance().get(activePartId);
            }
            catch (Exception exception) {
                logger.info("no url value for key " + activePartId);
            }
        }
        if (StringUtils.isBlank(url)) {
            url = String.valueOf(base) + section;
        }
        if (this.dialog == null || this.dialog.isDisposed()) {
            this.dialog = new HelpDialog(shell, modal ? 65536 : 0, url);
        } else {
            this.dialog.setUrl(url);
        }
        return null;
    }
}

