/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dsq.controller;

import ca.infodata.dsq.domain.IPrescriptionSummary;
import ca.infodata.dsq.domain.NIU_PRESCRIPTION;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.ui.dsq.RetractPrescriptionAction;
import ca.infodata.ofys.ui.dsq.controller.OEPrescriptionController;
import ca.infodata.ofys.ui.dsq.controller.OERetractControllerCallback;
import ca.infodata.util1.StringUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class OERetractController {
    private static final Logger logger = Logger.getLogger("ca.infodata.ofys.ui.encounter.dsq.controller.RetractOEController");
    private static final String RETRAIT_D_UNE_ORDONNANCE = "Retrait d'une ordonnance";
    private OERetractControllerCallback callback;
    private IPatient patient;
    private JobExtension job;
    private RetractPrescriptionAction retractPrescriptionAction;
    private OEPrescriptionController oePrescriptionController;

    public OERetractController(OERetractControllerCallback callback, RetractPrescriptionAction retractPrescriptionAction, OEPrescriptionController oePrescriptionController) {
        this.callback = callback;
        this.retractPrescriptionAction = retractPrescriptionAction;
        this.oePrescriptionController = oePrescriptionController;
    }

    public void retract(NIU_PRESCRIPTION id) {
        if (this.job == null) {
            this.job = new JobExtension(RETRAIT_D_UNE_ORDONNANCE);
        }
        if (this.job.getState() == 4) {
            this.callback.retract(id, (DsqCallback<Boolean>)new DsqCallback(null, "Op\u00e9ration en cours...", null));
        } else {
            this.job.setId(id);
            this.job.schedule();
        }
    }

    protected void retract2(NIU_PRESCRIPTION id, IProgressMonitor monitor) {
        this.callback.retract(id, this.retract3(id, monitor));
    }

    private DsqCallback<Boolean> retract3(NIU_PRESCRIPTION id, IProgressMonitor monitor) {
        DsqCallback callback;
        block6: {
            callback = new DsqCallback();
            try {
                try {
                    IPrescriptionSummary s = this.oePrescriptionController.get(id);
                    if (s != null) {
                        boolean retracted = this.retractPrescriptionAction.retract(this.patient, s, monitor);
                        callback.result = retracted;
                        break block6;
                    }
                    callback.message = "La prescription n'a pu \u00e8tre trouv\u00e9";
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error", e);
                    callback.message = StringUtils.isBlank((CharSequence)e.getMessage()) ? MessageUtil.UNEXPECTED_ERROR_MESSAGE : e.getMessage();
                    callback.exception = e;
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
        return callback;
    }

    public IPatient getPatient() {
        return this.patient;
    }

    public void setPatient(IPatient patient) {
        this.patient = patient;
    }

    public void clear() {
    }

    final class JobExtension
    extends Job {
        private NIU_PRESCRIPTION id;

        public void setId(NIU_PRESCRIPTION id) {
            this.id = id;
        }

        private JobExtension(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            OERetractController.this.retract2(this.id, monitor);
            return Status.OK_STATUS;
        }
    }
}

