/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dsq.controller;

import ca.infodata.dsq.domain.IPrescriptionSummary;
import ca.infodata.dsq.domain.NIU_PRESCRIPTION;
import ca.infodata.dsq.domain.PrescriptionDrugDetails;
import ca.infodata.dsq.service.dm.DMQRYCSvc.QueryContinuationResult;
import ca.infodata.dsq.signature.Signature;
import ca.infodata.dsq.signature.XmlSignatureI;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.dsq.AbortException;
import ca.infodata.ofys.client.modules.dsq.Alias;
import ca.infodata.ofys.client.modules.dsq.CancelException;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.data.client.dataaccess.DSQAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.controls.IProgressMonitorWithLog;
import ca.infodata.ofys.ui.controls.MySubProgressMonitor;
import ca.infodata.ofys.ui.dsq.BaseDSQAction;
import ca.infodata.ofys.ui.dsq.FindCandidateAction;
import ca.infodata.ofys.ui.dsq.controller.DMPrescriptionControllerCallback;
import ca.infodata.ofys.ui.dsq.controller.QueryContinuationController;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class DMPrescriptionController
extends QueryContinuationController {
    private static final LocalDate MINIMALDATE = LocalDate.from((int)1, (int)1, (int)2007);
    private static final String OBTENTION_DE_L_ORDONNANCE_DETAILLEE = Messages.getString((String)"GetPrescriptionDispensedDetailsAction.OBTENTION_DE_L_ORDONNANCE_DETAILLEE", (String[])new String[0]);
    private static final String OBTENTION_DE_LA_LISTE_DES_ORDONNANCES_RECU_PAR_UN_PHARMACIEN = Messages.getString((String)"ListPatientPrescriptionDispensedAction.OBTENTION_DE_LA_LISTE_DES_ORDONNANCES_RECU_PAR_UN_PHARMACIEN", (String[])new String[0]);
    private static final Logger logger = Logger.getLogger(DMPrescriptionController.class.getName());
    private final DMPrescriptionControllerCallback callback;
    private IPatient patient;
    private LocalDate start = LocalDate.today().plusYear(-1);
    private LocalDate end = LocalDate.today();
    private boolean onlyThoseWithIssue;
    private boolean includeCompletlyDispensed = false;
    private boolean includePartiallyDispensed = true;
    private boolean includeNeverDispensed = true;
    private int limit = 50;
    private List<IPrescriptionSummary> list;
    private QueryContinuationResult lastQCR;
    private Map<NIU_PRESCRIPTION, PrescriptionDrugDetails> prescriptionMapDetail;
    private Job listSummaryJob;
    private JobExtension getDetailJob;
    private FindCandidateAction findCandidateAction;

    public DMPrescriptionController(DMPrescriptionControllerCallback callback, BaseDSQAction dsq, FindCandidateAction findCandidateAction) {
        super(dsq);
        if (callback == null) {
            throw new NullPointerException("callback");
        }
        this.callback = callback;
        this.findCandidateAction = findCandidateAction;
        this.prescriptionMapDetail = new ConcurrentHashMap<NIU_PRESCRIPTION, PrescriptionDrugDetails>();
    }

    public void listSummary() {
        if (this.listSummaryJob == null) {
            this.listSummaryJob = new Job("Sommaire des ordonnances en attente"){

                protected IStatus run(IProgressMonitor monitor) {
                    DMPrescriptionController.this.listSummary2(monitor);
                    return Status.OK_STATUS;
                }
            };
        }
        if (this.listSummaryJob.getState() == 4) {
            this.callback.listSummary((DsqCallback<QueryContinuationResult>)new DsqCallback(null, "Op\u00e9ration en cours...", null));
        } else {
            this.listSummaryJob.schedule();
        }
    }

    protected void listSummary2(IProgressMonitor monitor) {
        if (this.list == null) {
            DsqCallback<QueryContinuationResult> r = this.listSummary3(monitor);
            this.lastQCR = (QueryContinuationResult)r.result;
            if (r.result != null) {
                this.list = new ArrayList<IPrescriptionSummary>(((QueryContinuationResult)r.result).prescriptions);
            }
            this.callback.listSummary(r);
        } else if (this.lastQCR != null && this.lastQCR.originalTotalQuantity > this.list.size()) {
            DsqCallback<QueryContinuationResult> r = this.continueQuery(this.patient, this.lastQCR, this.limit, monitor);
            if (r.result != null) {
                this.lastQCR = (QueryContinuationResult)r.result;
                this.list.addAll(((QueryContinuationResult)r.result).prescriptions);
                QueryContinuationResult r2 = new QueryContinuationResult();
                r2.originalTotalQuantity = this.lastQCR.originalTotalQuantity;
                r2.prescriptions = this.list;
                r2.queryId = ((QueryContinuationResult)r.result).queryId;
                r2.resultTotalQuantity = r2.originalTotalQuantity;
                r2.resultCurrentQuantity = r2.prescriptions.size();
                r2.resultRemainingQuantity = r2.resultTotalQuantity - r2.resultCurrentQuantity;
                this.callback.listSummary((DsqCallback<QueryContinuationResult>)new DsqCallback((Object)r2));
            } else {
                this.callback.listSummary(r);
            }
        } else {
            QueryContinuationResult r2 = new QueryContinuationResult();
            r2.originalTotalQuantity = this.lastQCR.originalTotalQuantity;
            r2.prescriptions = this.list;
            r2.queryId = this.lastQCR.queryId;
            r2.resultTotalQuantity = r2.originalTotalQuantity;
            r2.resultCurrentQuantity = r2.prescriptions.size();
            r2.resultRemainingQuantity = r2.resultTotalQuantity - r2.resultCurrentQuantity;
            this.callback.listSummary((DsqCallback<QueryContinuationResult>)new DsqCallback((Object)r2));
        }
    }

    private DsqCallback<QueryContinuationResult> listSummary3(IProgressMonitor monitor) {
        DsqCallback callback = new DsqCallback();
        try {
            if (this.end == null || this.start == null) {
                callback.message = "Une date de d\u00e9but et une date de fin est requise";
                if (monitor != null) {
                    monitor.done();
                }
                DsqCallback dsqCallback = callback;
                return dsqCallback;
            }
            if (this.end.before((IPartialDate)this.start)) {
                callback.message = "La date de d\u00e9but doit \u00eatre avant la date de fin";
                if (monitor != null) {
                    monitor.done();
                }
                DsqCallback dsqCallback = callback;
                return dsqCallback;
            }
            if (this.start.before((IPartialDate)MINIMALDATE)) {
                callback.message = "La date de d\u00e9but ne peut \u00eatre avant " + MINIMALDATE.formatSlash();
                if (monitor != null) {
                    monitor.done();
                }
                DsqCallback dsqCallback = callback;
                return dsqCallback;
            }
            try {
                if (monitor != null) {
                    monitor.beginTask(OBTENTION_DE_LA_LISTE_DES_ORDONNANCES_RECU_PAR_UN_PHARMACIEN, 2);
                }
                XmlSignatureI signature = null;
                XmlSignatureI signatureNiu = null;
                if (!this.dsq.hasSignatures(this.patient.getId())) {
                    if (!UI.OS_WINDOWS) {
                        throw new AbortException(Messages.getString((String)"ABSENCE_SIGN_DSQ", (String[])new String[0]));
                    }
                    this.dsq.checkIfActionWasCanceled(monitor);
                    Alias alias = this.dsq.getAlias(monitor);
                    this.dsq.checkIfActionWasCanceled(monitor);
                    String niu = this.findCandidateAction.getNiu(this.patient, (IProgressMonitorWithLog)(monitor == null ? null : new MySubProgressMonitor(monitor, 1)));
                    this.dsq.checkIfActionWasCanceled(monitor);
                    signature = this.dsq.getSignatureI(monitor, alias, null);
                    this.dsq.checkIfActionWasCanceled(monitor);
                    signatureNiu = this.dsq.getXmlSignatureI(monitor, alias, null, niu);
                    this.dsq.checkIfActionWasCanceled(monitor);
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                }
                this.dsq.checkIfActionWasCanceled(monitor);
                if (monitor != null) {
                    monitor.subTask("Recherche");
                }
                XSession session = Application.get().getGlobalInstances().getSession();
                ReturnObject r = DSQAccessorClient.getInstance().getPrescriptionOrderSummaryServiceDM(session, this.patient.getId(), this.start, this.end, this.onlyThoseWithIssue, this.includeCompletlyDispensed, this.includePartiallyDispensed, this.includeNeverDispensed, this.limit, (Signature)signature, (Signature)signatureNiu);
                if (r == null) {
                    throw new AbortException("Erreur lors de l'" + OBTENTION_DE_LA_LISTE_DES_ORDONNANCES_RECU_PAR_UN_PHARMACIEN.toLowerCase());
                }
                this.dsq.manageDsqStatus(r.getStatus());
                callback.result = (QueryContinuationResult)r.getObj();
                this.dsq.checkIfActionWasCanceled(monitor);
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                callback.message = MessageUtil.CANNOT_CONNECT_TO_SERVER_MESSAGE;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (AbortException | StatusException e) {
                callback.message = e.getMessage();
            }
            catch (CancelException cancelException) {
            }
            catch (Exception e) {
                callback.exception = e;
                callback.message = StringUtils.isBlank((CharSequence)e.getMessage()) ? MessageUtil.UNEXPECTED_ERROR_MESSAGE : e.getMessage();
                logger.log(Level.SEVERE, "Failed to list dm prescription. patient=" + StringUtils.safeToString((Logger)logger, (Object)this.patient), e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return callback;
    }

    public void getDetail(NIU_PRESCRIPTION id, String context) {
        if (this.getDetailJob == null) {
            this.getDetailJob = new JobExtension(OBTENTION_DE_L_ORDONNANCE_DETAILLEE);
        }
        if (this.getDetailJob.getState() == 4) {
            this.callback.getDetail(id, context, (DsqCallback<PrescriptionDrugDetails>)new DsqCallback(null, "Op\u00e9ration en cours...", null));
        } else {
            this.getDetailJob.setId(id);
            this.getDetailJob.setContext(context);
            this.getDetailJob.schedule();
        }
    }

    protected void getDetail2(NIU_PRESCRIPTION id, String context, IProgressMonitor monitor) {
        PrescriptionDrugDetails d = this.prescriptionMapDetail.get(id);
        if (d == null) {
            DsqCallback<PrescriptionDrugDetails> c = this.getDetail3(id, monitor);
            if (c.result != null) {
                this.prescriptionMapDetail.put(id, (PrescriptionDrugDetails)c.result);
            }
            this.callback.getDetail(id, context, c);
        } else {
            this.callback.getDetail(id, context, (DsqCallback<PrescriptionDrugDetails>)new DsqCallback((Object)d));
        }
    }

    /*
     * Exception decompiling
     */
    private DsqCallback<PrescriptionDrugDetails> getDetail3(NIU_PRESCRIPTION id, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setPatient(IPatient patient) {
        this.patient = patient;
        this.list = null;
        this.lastQCR = null;
        this.prescriptionMapDetail.clear();
    }

    public LocalDate getStart() {
        return this.start;
    }

    public void setStart(LocalDate start) {
        this.start = start;
        this.list = null;
        this.lastQCR = null;
        this.prescriptionMapDetail.clear();
    }

    public LocalDate getEnd() {
        return this.end;
    }

    public void setEnd(LocalDate end) {
        this.end = end;
        this.list = null;
        this.lastQCR = null;
    }

    public boolean isOnlyThoseWithIssue() {
        return this.onlyThoseWithIssue;
    }

    public void setOnlyThoseWithIssue(boolean onlyThoseWithIssue) {
        this.onlyThoseWithIssue = onlyThoseWithIssue;
        this.list = null;
        this.lastQCR = null;
    }

    public boolean isIncludeCompletlyDispensed() {
        return this.includeCompletlyDispensed;
    }

    public void setIncludeCompletlyDispensed(boolean includeCompletlyDispensed) {
        this.includeCompletlyDispensed = includeCompletlyDispensed;
        this.list = null;
        this.lastQCR = null;
    }

    public boolean isIncludePartiallyDispensed() {
        return this.includePartiallyDispensed;
    }

    public void setIncludePartiallyDispensed(boolean includePartiallyDispensed) {
        this.includePartiallyDispensed = includePartiallyDispensed;
        this.list = null;
        this.lastQCR = null;
    }

    public boolean isIncludeNeverDispensed() {
        return this.includeNeverDispensed;
    }

    public void setIncludeNeverDispensed(boolean includeNeverDispensed) {
        this.includeNeverDispensed = includeNeverDispensed;
        this.list = null;
        this.lastQCR = null;
    }

    final class JobExtension
    extends Job {
        private NIU_PRESCRIPTION id;
        private String context;

        public void setId(NIU_PRESCRIPTION id) {
            this.id = id;
        }

        private JobExtension(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            DMPrescriptionController.this.getDetail2(this.id, this.context, monitor);
            return Status.OK_STATUS;
        }

        public void setContext(String context) {
            this.context = context;
        }
    }
}

