/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dsq;

import ca.infodata.dsq.domain.Address;
import ca.infodata.dsq.domain.ILocation;
import ca.infodata.dsq.service.odslds.ServiceDeliveryLocationCriteria;
import ca.infodata.dsq.signature.Signature;
import ca.infodata.dsq.signature.XmlSignatureI;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.dsq.AbortException;
import ca.infodata.ofys.client.modules.dsq.Alias;
import ca.infodata.ofys.client.modules.dsq.CancelException;
import ca.infodata.ofys.data.client.dataaccess.DSQAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.ui.dsq.BaseDSQAction;
import ca.infodata.ofys.ui.dsq.Messages;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.StringUtils;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class FindLocationAction
extends BaseDSQAction
implements IWorkbenchWindowActionDelegate {
    private static final String RESOLUTION_DU_LIEU = Messages.getString("FindLocationAction.RESOLUTION_DU_LIEU");
    private static final Logger logger = Logger.getLogger(FindLocationAction.class.getName());
    private static IAction action;
    private static boolean tempEnable;
    private Image disable;

    static {
        tempEnable = true;
    }

    public void dispose() {
        if (this.disable != null && !this.disable.isDisposed()) {
            this.disable.dispose();
        }
    }

    @Deprecated
    public void run(IAction action) {
        throw new UnsupportedOperationException("dont use this api");
    }

    public List<ILocation> find(XSite site, IProgressMonitor monitor) {
        List locations = null;
        try {
            if (monitor != null) {
                monitor.beginTask(RESOLUTION_DU_LIEU, 3);
            }
            XmlSignatureI signature = null;
            if (!this.hasSignatures(null)) {
                if (!UI.OS_WINDOWS) {
                    throw new AbortException(ca.infodata.ofys.data.middle.dataobjects.Messages.getString((String)"ABSENCE_SIGN_DSQ", (String[])new String[0]));
                }
                Alias alias = this.getAlias(monitor);
                this.checkIfActionWasCanceled(monitor);
                signature = this.getSignatureI(monitor, alias, null);
                this.checkIfActionWasCanceled(monitor);
                if (monitor != null) {
                    monitor.worked(1);
                }
            }
            XSession session = Application.get().getGlobalInstances().getSession();
            try {
                if (monitor != null) {
                    monitor.subTask("Recherche");
                }
                ServiceDeliveryLocationCriteria criteria = new ServiceDeliveryLocationCriteria();
                criteria.setNameContains(site.getNameOfficial());
                criteria.setAddress(new Address(site.getStreet(), site.getPostalCode(), site.getCity() == null ? null : site.getCity().getName(), site.getProvince() == null ? null : site.getProvince().getName(), site.getCountry() == null ? null : site.getCountry().getName(), site.getPhonenumber1()));
                ReturnObject r = DSQAccessorClient.getInstance().findLocation(session, site.getId(), criteria, (Signature)signature);
                if (r == null) {
                    throw new AbortException("Erreur lors de la r\u00e9solution du site au registre");
                }
                if (!r.getStatus().isOkToProceed()) {
                    throw new AbortException(FindLocationAction.getReadTimeoutMessage(r.getStatus().getMessage()));
                }
                locations = (List)r.getObj();
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                MessageUtil.cannotConnectToServerExceptionMsg();
            }
        }
        catch (CancelException e) {
            e.printStackTrace();
        }
        catch (AbortException e) {
            MessageUtil.errorMsg((Shell)this.getShell(), (String)e.getMessage());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to find site to dsq " + StringUtils.safeToString((Logger)logger, (Object)site), e);
            MessageUtil.errorMsg((Shell)this.getShell(), (String)e.getMessage());
        }
        if (monitor != null) {
            monitor.done();
        }
        return locations;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        FindLocationAction.action = action;
        action.setEnabled(tempEnable);
        Image icon = ResourceGetter.getImage((String)"images/enc-icon16.png");
        action.setImageDescriptor(ImageDescriptor.createFromImage((Image)icon));
        this.disable = new Image((Device)Display.getDefault(), icon, 2);
        action.setDisabledImageDescriptor(ImageDescriptor.createFromImage((Image)this.disable));
    }

    public static void setEnabled(boolean value) {
        if (action != null) {
            action.setEnabled(value);
        } else {
            tempEnable = value;
        }
    }
}

