/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.patient.XConsentement;
import ca.infodata.ofys.ui.browser.sonar.SonarWS;
import ca.infodata.ofys.ui.dashboard.DashboardPlugin;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class OpenPatientInOfys5Action
implements IWorkbenchWindowActionDelegate {
    private static IAction action;
    private static boolean tempEnable;
    private Image disable;
    private static String clientUid;
    Timer timer;
    TimerTask task;

    static {
        tempEnable = true;
        clientUid = null;
    }

    public OpenPatientInOfys5Action() {
    }

    public OpenPatientInOfys5Action(boolean isNewEditor) {
    }

    public void dispose() {
        if (this.disable != null && !this.disable.isDisposed()) {
            this.disable.dispose();
        }
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        XPatient patient = Application.get().getPersonPluginController().getCurrentPatient();
        if (patient != null && patient != null && patient.getId() != null) {
            this.openPatientInOfys5(patient);
        }
    }

    private void openPatientInOfys5(final XPatient patient) {
        if (this.hasRightToOpenEncounter((IPatient)patient)) {
            ArrayList<String> uids = new ArrayList<String>();
            boolean foundIt = false;
            for (Map.Entry socket : SonarWS.getInstances().entrySet()) {
                if (!StringUtils.isNotBlank((String)((String)socket.getKey())) || !((SonarWS)socket.getValue()).ping()) continue;
                uids.add((String)socket.getKey());
                if (!((String)socket.getKey()).equals(clientUid)) continue;
                foundIt = true;
                break;
            }
            if (uids.isEmpty()) {
                DashboardPlugin.getDefault().openOfysChrome();
                final ArrayList lstUid = new ArrayList();
                this.timer = new Timer();
                this.task = new TimerTask(){

                    @Override
                    public void run() {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                for (Map.Entry socket : SonarWS.getInstances().entrySet()) {
                                    if (!StringUtils.isNotBlank((String)((String)socket.getKey()))) continue;
                                    lstUid.add((String)socket.getKey());
                                    break;
                                }
                                if (!lstUid.isEmpty()) {
                                    (this).OpenPatientInOfys5Action.this.task.cancel();
                                    (this).OpenPatientInOfys5Action.this.timer.cancel();
                                    OpenPatientInOfys5Action.this.openPatientInOfys5(patient);
                                }
                            }
                        });
                    }
                };
                this.timer.schedule(this.task, 2000L, 2000L);
                return;
            }
            if (!foundIt) {
                clientUid = (String)uids.get(0);
            }
            if (StringUtils.isNotEmpty((String)clientUid)) {
                DashboardPlugin.getDefault().getPatientControllerWeb().openPatientFile(patient, clientUid);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        System.out.println("OpenMostRecentEncounterAction.selectionChanged()");
        OpenPatientInOfys5Action.action = action;
        action.setEnabled(tempEnable);
        Image icon = ResourceGetter.getImage((String)"images/enc-icon16.png");
        action.setImageDescriptor(ImageDescriptor.createFromImage((Image)icon));
        this.disable = new Image((Device)Display.getDefault(), icon, 2);
        action.setDisabledImageDescriptor(ImageDescriptor.createFromImage((Image)this.disable));
    }

    public static void setEnabled(boolean value) {
        if (action != null) {
            action.setEnabled(value);
        } else {
            tempEnable = value;
        }
    }

    private boolean hasRightToOpenEncounter(IPatient patient) {
        boolean ok = true;
        if (patient instanceof XPatient) {
            XPatient xPatient = (XPatient)patient;
            XConsentement consent = new XConsentement();
            boolean showToAll = xPatient.getShowToAllAndConsent(consent, Application.get().getGlobalInstances().getSessionIdUser());
            boolean checkDroit = false;
            if (!showToAll && consent.getDroits() != null) {
                checkDroit = true;
            }
            boolean bl = ok = showToAll || checkDroit && consent.hasRightDossier();
        }
        if (!ok) {
            MessageUtil.warningMsg((Shell)UI.getWorkbenchShell(), (String)Messages.getString((String)"PATIENT_DOES_DOT_CONSENT", (String[])new String[0]));
        }
        return ok;
    }
}

