/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.IApplicationUiPlugin;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBasePatient;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientRecall;
import ca.infodata.ofys.data.middle.dataobjects.chat.MessageLink;
import ca.infodata.ofys.data.middle.dataobjects.communication.XFaxSend;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounter;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XBaseLaboResultsProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboResultsProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboResultsProfessionnalStatus;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.data.middle.dataobjects.scan.XBasePatientImage;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImage;
import ca.infodata.ofys.data.middle.dataobjects.task.XTask;
import ca.infodata.ofys.ui.appointment.editor.recall.PatientRecallEditor2;
import ca.infodata.ofys.ui.appointment.menu.OpenAppointmentAction;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.report2.PrintDialog2;
import ca.infodata.ofys.ui.controls.template.editor.TemplateEditor;
import ca.infodata.ofys.ui.controls.template.editor.XTemplateContainer;
import ca.infodata.ofys.ui.intro.ClientSessionTimeoutTool;
import ca.infodata.ofys.ui.intro.IntroPlugin;
import ca.infodata.ofys.ui.laboresults.editor.LaboResultsEditor;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.PersonMultiEditorFactory;
import ca.infodata.ofys.ui.person.patient.PatientMultiEditor;
import ca.infodata.ofys.ui.person.patient.PatientUtil;
import ca.infodata.ofys.ui.person.print.PatientPrintDialog;
import ca.infodata.ofys.ui.task.wizard.TaskWizard;
import ca.infodata.ofys.ui.task.wizard.TaskWizardDialog;
import ca.infodata.util1.StringUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.time.FastDateFormat;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

class ApplicationUIPluginImp
implements IApplicationUiPlugin {
    private static Logger logger = Logger.getLogger(ApplicationUIPluginImp.class.getName());
    private Clipboard clipboard;

    ApplicationUIPluginImp() {
    }

    public void notifyUserInteraction() {
        ClientSessionTimeoutTool.getInstance().resetTimer();
        IntroPlugin.getDefault().getApplicationTimeoutTool().resetTimer();
    }

    public String getPrintedByNotice() {
        String printedBy = String.valueOf(Messages.getString((String)"PRINTED_BY", (String[])new String[0])) + " " + LibPlugin.getUserName() + " " + FastDateFormat.getInstance((String)(String.valueOf(FormatDateProvider.getFormatDate().toString()) + " HH:mm")).format(new Date()) + " - " + Messages.getString((String)"CONFIDENTIAL", (String[])new String[0]);
        return printedBy;
    }

    public void openTask(final XTask task, final MessageLink link) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                XSession session = Application.get().getGlobalInstances().getSession();
                if (session != null) {
                    if (Application.get().getGlobalInstances().canConnectToServer()) {
                        TaskWizard wiz = null;
                        wiz = task == null ? (link == null ? new TaskWizard() : new TaskWizard(null, link)) : new TaskWizard(task);
                        TaskWizardDialog dialog = new TaskWizardDialog(UI.getWorkbenchShell(), (IWizard)wiz);
                        dialog.open();
                    }
                } else {
                    MessageUtil.cannotConnectToServerExceptionMsg();
                }
            }
        });
    }

    public boolean openAppointmentMultiProfEditor() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                OpenAppointmentAction.openAppointmentMultiProfEditor(null);
            }
        });
        return true;
    }

    public boolean openAppointmentEditor(final XBaseProfessionnal professionnal) {
        if (professionnal == null || !professionnal.isUseAppointment()) {
            return false;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                OpenAppointmentAction.openAppointmentEditor((XBaseProfessionnal)professionnal);
            }
        });
        return true;
    }

    public boolean openTemplateEditor(final Integer type) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    XCompletionProposalType xcpt = XCompletionProposalType.getType((int)type);
                    if (xcpt == null) {
                        xcpt = XCompletionProposalType.EFORM_ADAPTER;
                    }
                    XTemplateContainer xtc = new XTemplateContainer(xcpt, type.intValue());
                    xtc.load();
                    BaseEditor.openEditor((IEditorInput)xtc, (String)TemplateEditor.class.getName());
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Unable to open template editor: type=" + type, e);
                }
            }
        });
        return true;
    }

    public void openPatientEditEditor(final XPatient patient) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PersonMultiEditorFactory.openPatient((IPatient)patient);
            }
        });
    }

    public void openEncounterEditor(XPatient patient) {
    }

    public void openNewRecallEditor(final XPatient patient) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                String editorClass = PatientRecallEditor2.class.getName();
                Object editorInput = null;
                try {
                    XPatientRecall recall = new XPatientRecall();
                    recall.setPatient((IPatient)patient);
                    EditorInput input = new EditorInput((IDataObject)recall);
                    if (input != null) {
                        BaseEditor.openEditor((IEditorInput)input, (String)editorClass);
                    }
                }
                catch (Exception e) {
                    String input;
                    try {
                        input = String.valueOf(editorInput);
                    }
                    catch (Exception e2) {
                        input = e2.getMessage();
                    }
                    logger.log(Level.SEVERE, "Failed to open editor " + editorClass + "with input " + input, e);
                }
            }
        });
    }

    public boolean openNewPatientEditor() {
        try {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (Application.get().getGlobalInstances().getSession() != null && Application.get().getGlobalInstances().getSession().getClientPreferences() != null && Application.get().getGlobalInstances().getSession().getClientPreferences().isMultiplePatientWindows()) {
                        BaseEditor.openEditorSafePlain((IEditorInput)new EditorInput((IDataObject)new XBasePatient()), (String)PatientMultiEditor.class.getName());
                    } else {
                        BaseEditor.openEditorSafePlain((IEditorInput)new EditorInput((IDataObject)new XBasePatient()), (String)PatientMultiEditor.class.getName());
                    }
                }
            });
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void openNewMessage(MessageLink ml) {
    }

    public void openLaboEditor(final XBaseLaboResultsProfessionnal laboResultsProfessionnal) {
        if (laboResultsProfessionnal != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    EnumSet status;
                    EditorInput input = new EditorInput((IDataObject)laboResultsProfessionnal.clone());
                    IEditorPart editor = BaseEditor.openEditorSafe((IEditorInput)input, (String)LaboResultsEditor.class.getName());
                    if (editor != null && !(status = laboResultsProfessionnal.getStatus()).contains(XLaboResultsProfessionnalStatus.SEEN)) {
                        laboResultsProfessionnal.addXLaboResultsProfessionnalStatus(XLaboResultsProfessionnalStatus.SEEN);
                    }
                }
            });
        }
    }

    public void openLaboEditor(final XLaboResultsProfessionnal laboResultsProfessionnal) {
        if (laboResultsProfessionnal != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    EnumSet status;
                    EditorInput input = new EditorInput((IDataObject)laboResultsProfessionnal.clone());
                    IEditorPart editor = BaseEditor.openEditorSafe((IEditorInput)input, (String)LaboResultsEditor.class.getName());
                    if (editor != null && !(status = laboResultsProfessionnal.getStatus()).contains(XLaboResultsProfessionnalStatus.SEEN)) {
                        laboResultsProfessionnal.addXLaboResultsProfessionnalStatus(XLaboResultsProfessionnalStatus.SEEN);
                    }
                }
            });
        }
    }

    public void openPatientImageEditor(final XPatientImage patientImageInfo) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                EditorInput input = new EditorInput((IDataObject)patientImageInfo);
                if (input != null) {
                    BaseEditor.openEditorSafe((IEditorInput)input);
                }
            }
        });
    }

    public void openPatientImageEditor(final XBasePatientImage patientImageInfo) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                EditorInput input = new EditorInput((IDataObject)patientImageInfo);
                if (input != null) {
                    BaseEditor.openEditorSafe((IEditorInput)input);
                }
            }
        });
    }

    public void openFaxEditor(final XFaxSend patientImageInfo) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                EditorInput input = new EditorInput((IDataObject)patientImageInfo);
                if (input != null) {
                    BaseEditor.openEditorSafe((IEditorInput)input);
                }
            }
        });
    }

    public void dispose() {
    }

    public void setCurrentPatient(final Integer idPatient) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                XPatient pat = PatientUtil.getXPatient((Object)idPatient);
                Application.get().getPersonPluginController().setCurrentPatient((IPatient)pat);
            }
        });
    }

    public void openPatientPrintDialog(final IPatient patient) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                XSession session = Application.get().getGlobalInstances().getSession();
                if (session != null) {
                    if (Application.get().getGlobalInstances().canConnectToServer()) {
                        new PatientPrintDialog(UI.getWorkbenchShell(), patient).open();
                    }
                } else {
                    MessageUtil.cannotConnectToServerExceptionMsg();
                }
            }
        });
    }

    public void openEncounterPrintDialog(final XEncounter encounter) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PrintDialog2 dialog = new PrintDialog2(UI.getWorkbenchShell(), (Serializable)encounter);
                UI.centerComposite((Composite)dialog.getShell(), (Composite)UI.getWorkbenchShell());
                dialog.open();
            }
        });
    }

    public void programLaunch(String url) {
        Program.launch((String)url);
    }

    public void copyToClipboard(final String text) {
        try {
            if (StringUtils.isNotEmpty((String)text)) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ApplicationUIPluginImp.this.clipboard == null) {
                            ApplicationUIPluginImp.this.clipboard = new Clipboard(Display.getDefault());
                        }
                        ApplicationUIPluginImp.this.clipboard.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
                    }
                });
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Copy to clipboard error", e);
        }
    }

    public boolean isWindowsDesktop() {
        return LibPlugin.ON_WIN;
    }

    public boolean isOfysProWeb() {
        return false;
    }

    public boolean isOfysProLocal() {
        return true;
    }
}

