/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.bouncycastle.crypto.tls.DefaultTlsCipherFactory;
import org.bouncycastle.crypto.tls.TlsCipher;
import org.bouncycastle.crypto.tls.TlsCipherFactory;
import org.bouncycastle.crypto.tls.TlsClient;
import org.bouncycastle.crypto.tls.TlsClientContext;
import org.bouncycastle.crypto.tls.TlsCompression;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsKeyExchange;
import org.bouncycastle.crypto.tls.TlsNullCompression;
import org.bouncycastle.crypto.tls.TlsSRPKeyExchange;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public abstract class SRPTlsClient
implements TlsClient {
    public static final Integer EXT_SRP = new Integer(12);
    protected TlsCipherFactory cipherFactory;
    protected byte[] identity;
    protected byte[] password;
    protected TlsClientContext context;
    protected int selectedCompressionMethod;
    protected int selectedCipherSuite;

    public SRPTlsClient(byte[] identity, byte[] password) {
        this(new DefaultTlsCipherFactory(), identity, password);
    }

    public SRPTlsClient(TlsCipherFactory cipherFactory, byte[] identity, byte[] password) {
        this.cipherFactory = cipherFactory;
        this.identity = Arrays.clone(identity);
        this.password = Arrays.clone(password);
    }

    @Override
    public void init(TlsClientContext context) {
        this.context = context;
    }

    @Override
    public int[] getCipherSuites() {
        return new int[]{49186, 49183, 49180, 49185, 49182, 49179, 49184, 49181, 49178};
    }

    @Override
    public Hashtable getClientExtensions() throws IOException {
        Hashtable<Integer, byte[]> clientExtensions = new Hashtable<Integer, byte[]>();
        ByteArrayOutputStream srpData = new ByteArrayOutputStream();
        TlsUtils.writeOpaque8(this.identity, srpData);
        clientExtensions.put(EXT_SRP, srpData.toByteArray());
        return clientExtensions;
    }

    @Override
    public short[] getCompressionMethods() {
        return new short[1];
    }

    @Override
    public void notifySessionID(byte[] sessionID) {
    }

    @Override
    public void notifySelectedCipherSuite(int selectedCipherSuite) {
        this.selectedCipherSuite = selectedCipherSuite;
    }

    @Override
    public void notifySelectedCompressionMethod(short selectedCompressionMethod) {
        this.selectedCompressionMethod = selectedCompressionMethod;
    }

    @Override
    public void notifySecureRenegotiation(boolean secureRenegotiation) throws IOException {
    }

    @Override
    public void processServerExtensions(Hashtable serverExtensions) {
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        switch (this.selectedCipherSuite) {
            case 49178: 
            case 49181: 
            case 49184: {
                return this.createSRPKeyExchange(21);
            }
            case 49179: 
            case 49182: 
            case 49185: {
                return this.createSRPKeyExchange(23);
            }
            case 49180: 
            case 49183: 
            case 49186: {
                return this.createSRPKeyExchange(22);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsCompression getCompression() throws IOException {
        switch (this.selectedCompressionMethod) {
            case 0: {
                return new TlsNullCompression();
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsCipher getCipher() throws IOException {
        switch (this.selectedCipherSuite) {
            case 49178: 
            case 49179: 
            case 49180: {
                return this.cipherFactory.createCipher(this.context, 7, 2);
            }
            case 49181: 
            case 49182: 
            case 49183: {
                return this.cipherFactory.createCipher(this.context, 8, 2);
            }
            case 49184: 
            case 49185: 
            case 49186: {
                return this.cipherFactory.createCipher(this.context, 9, 2);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createSRPKeyExchange(int keyExchange) {
        return new TlsSRPKeyExchange(this.context, keyExchange, this.identity, this.password);
    }
}

