/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes.gcm;

import org.bouncycastle.crypto.modes.gcm.GCMExponentiator;
import org.bouncycastle.crypto.modes.gcm.GCMUtil;
import org.bouncycastle.util.Arrays;

public class Tables1kGCMExponentiator
implements GCMExponentiator {
    byte[][] lookupPowX2 = new byte[64][];

    @Override
    public void init(byte[] x) {
        this.lookupPowX2[0] = new byte[16];
        this.lookupPowX2[0][0] = -128;
        this.lookupPowX2[1] = Arrays.clone(x);
        int i = 2;
        while (i != 64) {
            byte[] tmp = Arrays.clone(this.lookupPowX2[i - 1]);
            GCMUtil.multiply(tmp, tmp);
            this.lookupPowX2[i] = tmp;
            ++i;
        }
    }

    @Override
    public void exponentiateX(long pow, byte[] output) {
        byte[] y = GCMUtil.oneAsBytes();
        int powX2 = 1;
        while (pow > 0L) {
            if ((pow & 1L) != 0L) {
                GCMUtil.multiply(y, this.lookupPowX2[powX2]);
            }
            ++powX2;
            pow >>>= 1;
        }
        System.arraycopy(y, 0, output, 0, 16);
    }
}

