/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.IntRecipientInfoGenerator;

class KeyTransIntRecipientInfoGenerator
implements IntRecipientInfoGenerator {
    private TBSCertificateStructure recipientTBSCert;
    private PublicKey recipientPublicKey;
    private ASN1OctetString subjectKeyIdentifier;
    private SubjectPublicKeyInfo info;

    KeyTransIntRecipientInfoGenerator() {
    }

    void setRecipientCert(X509Certificate recipientCert) {
        this.recipientTBSCert = CMSUtils.getTBSCertificateStructure(recipientCert);
        this.recipientPublicKey = recipientCert.getPublicKey();
        this.info = this.recipientTBSCert.getSubjectPublicKeyInfo();
    }

    void setRecipientPublicKey(PublicKey recipientPublicKey) {
        this.recipientPublicKey = recipientPublicKey;
        try {
            this.info = SubjectPublicKeyInfo.getInstance(ASN1Object.fromByteArray(recipientPublicKey.getEncoded()));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("can't extract key algorithm from this key");
        }
    }

    void setSubjectKeyIdentifier(ASN1OctetString subjectKeyIdentifier) {
        this.subjectKeyIdentifier = subjectKeyIdentifier;
    }

    @Override
    public RecipientInfo generate(SecretKey contentEncryptionKey, SecureRandom random, Provider prov) throws GeneralSecurityException {
        RecipientIdentifier recipId;
        AlgorithmIdentifier keyEncryptionAlgorithm = this.info.getAlgorithmId();
        byte[] encryptedKeyBytes = null;
        Cipher keyEncryptionCipher = CMSEnvelopedHelper.INSTANCE.createAsymmetricCipher(keyEncryptionAlgorithm.getObjectId().getId(), prov);
        try {
            keyEncryptionCipher.init(3, (Key)this.recipientPublicKey, random);
            encryptedKeyBytes = keyEncryptionCipher.wrap(contentEncryptionKey);
        }
        catch (GeneralSecurityException generalSecurityException) {
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (ProviderException providerException) {}
        if (encryptedKeyBytes == null) {
            keyEncryptionCipher.init(1, (Key)this.recipientPublicKey, random);
            encryptedKeyBytes = keyEncryptionCipher.doFinal(contentEncryptionKey.getEncoded());
        }
        if (this.recipientTBSCert != null) {
            IssuerAndSerialNumber issuerAndSerial = new IssuerAndSerialNumber(this.recipientTBSCert.getIssuer(), this.recipientTBSCert.getSerialNumber().getValue());
            recipId = new RecipientIdentifier(issuerAndSerial);
        } else {
            recipId = new RecipientIdentifier(this.subjectKeyIdentifier);
        }
        return new RecipientInfo(new KeyTransRecipientInfo(recipId, keyEncryptionAlgorithm, new DEROctetString(encryptedKeyBytes)));
    }
}

