/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.fst;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.spell.TermFreqIterator;
import org.apache.lucene.search.spell.TermFreqPayloadIterator;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.Sort;
import org.apache.lucene.search.suggest.fst.ExternalRefSorter;
import org.apache.lucene.search.suggest.fst.FSTCompletion;
import org.apache.lucene.search.suggest.fst.FSTCompletionBuilder;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.store.OutputStreamDataOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.NoOutputs;

public class FSTCompletionLookup
extends Lookup {
    private static int INVALID_BUCKETS_COUNT = -1;
    private static final int sharedTailLength = 5;
    private int buckets;
    private boolean exactMatchFirst;
    private FSTCompletion higherWeightsCompletion;
    private FSTCompletion normalCompletion;

    public FSTCompletionLookup() {
        this(10, true);
    }

    public FSTCompletionLookup(int buckets, boolean exactMatchFirst) {
        this.buckets = buckets;
        this.exactMatchFirst = exactMatchFirst;
    }

    public FSTCompletionLookup(FSTCompletion completion, boolean exactMatchFirst) {
        this(INVALID_BUCKETS_COUNT, exactMatchFirst);
        this.normalCompletion = new FSTCompletion(completion.getFST(), false, exactMatchFirst);
        this.higherWeightsCompletion = new FSTCompletion(completion.getFST(), true, exactMatchFirst);
    }

    @Override
    public void build(TermFreqIterator tfit) throws IOException {
        if (tfit instanceof TermFreqPayloadIterator) {
            throw new IllegalArgumentException("this suggester doesn't support payloads");
        }
        File tempInput = File.createTempFile(FSTCompletionLookup.class.getSimpleName(), ".input", Sort.defaultTempDir());
        File tempSorted = File.createTempFile(FSTCompletionLookup.class.getSimpleName(), ".sorted", Sort.defaultTempDir());
        Sort.ByteSequencesWriter writer = new Sort.ByteSequencesWriter(tempInput);
        Sort.ByteSequencesReader reader = null;
        ExternalRefSorter sorter = null;
        boolean success = false;
        try {
            BytesRef spare;
            byte[] buffer = new byte[]{};
            ByteArrayDataOutput output = new ByteArrayDataOutput(buffer);
            while ((spare = tfit.next()) != null) {
                if (spare.length + 4 >= buffer.length) {
                    buffer = ArrayUtil.grow(buffer, spare.length + 4);
                }
                output.reset(buffer);
                output.writeInt(FSTCompletionLookup.encodeWeight(tfit.weight()));
                output.writeBytes(spare.bytes, spare.offset, spare.length);
                writer.write(buffer, 0, output.getPosition());
            }
            writer.close();
            Sort.SortInfo info = new Sort().sort(tempInput, tempSorted);
            tempInput.delete();
            sorter = new ExternalRefSorter(new Sort());
            FSTCompletionBuilder builder = new FSTCompletionBuilder(this.buckets, sorter, 5);
            int inputLines = info.lines;
            reader = new Sort.ByteSequencesReader(tempSorted);
            long line = 0L;
            int previousBucket = 0;
            int previousScore = 0;
            ByteArrayDataInput input = new ByteArrayDataInput();
            BytesRef tmp1 = new BytesRef();
            BytesRef tmp2 = new BytesRef();
            while (reader.read(tmp1)) {
                input.reset(tmp1.bytes);
                int currentScore = input.readInt();
                int bucket = line > 0L && currentScore == previousScore ? previousBucket : (int)(line * (long)this.buckets / (long)inputLines);
                previousScore = currentScore;
                previousBucket = bucket;
                tmp2.bytes = tmp1.bytes;
                tmp2.offset = input.getPosition();
                tmp2.length = tmp1.length - input.getPosition();
                builder.add(tmp2, bucket);
                ++line;
            }
            this.higherWeightsCompletion = builder.build();
            this.normalCompletion = new FSTCompletion(this.higherWeightsCompletion.getFST(), false, this.exactMatchFirst);
            success = true;
        }
        catch (Throwable throwable) {
            if (success) {
                IOUtils.close(reader, writer, sorter);
            } else {
                IOUtils.closeWhileHandlingException(reader, writer, sorter);
            }
            tempInput.delete();
            tempSorted.delete();
            throw throwable;
        }
        if (success) {
            IOUtils.close(reader, writer, sorter);
        } else {
            IOUtils.closeWhileHandlingException(reader, writer, sorter);
        }
        tempInput.delete();
        tempSorted.delete();
    }

    private static int encodeWeight(long value) {
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("cannot encode value: " + value);
        }
        return (int)value;
    }

    @Override
    public List<Lookup.LookupResult> lookup(CharSequence key, boolean higherWeightsFirst, int num) {
        List<FSTCompletion.Completion> completions = higherWeightsFirst ? this.higherWeightsCompletion.lookup(key, num) : this.normalCompletion.lookup(key, num);
        ArrayList<Lookup.LookupResult> results = new ArrayList<Lookup.LookupResult>(completions.size());
        CharsRef spare = new CharsRef();
        for (FSTCompletion.Completion c : completions) {
            spare.grow(c.utf8.length);
            UnicodeUtil.UTF8toUTF16(c.utf8, spare);
            results.add(new Lookup.LookupResult(spare.toString(), c.bucket));
        }
        return results;
    }

    public Object get(CharSequence key) {
        int bucket = this.normalCompletion.getBucket(key);
        return bucket == -1 ? null : Long.valueOf(bucket);
    }

    @Override
    public synchronized boolean store(OutputStream output) throws IOException {
        block3: {
            try {
                if (this.normalCompletion != null && this.normalCompletion.getFST() != null) break block3;
            }
            catch (Throwable throwable) {
                IOUtils.close(output);
                throw throwable;
            }
            IOUtils.close(output);
            return false;
        }
        this.normalCompletion.getFST().save(new OutputStreamDataOutput(output));
        IOUtils.close(output);
        return true;
    }

    @Override
    public synchronized boolean load(InputStream input) throws IOException {
        try {
            this.higherWeightsCompletion = new FSTCompletion(new FST<Object>(new InputStreamDataInput(input), NoOutputs.getSingleton()));
            this.normalCompletion = new FSTCompletion(this.higherWeightsCompletion.getFST(), false, this.exactMatchFirst);
        }
        catch (Throwable throwable) {
            IOUtils.close(input);
            throw throwable;
        }
        IOUtils.close(input);
        return true;
    }
}

