/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SortField;

public class Sort {
    public static final Sort RELEVANCE = new Sort();
    public static final Sort INDEXORDER = new Sort(SortField.FIELD_DOC);
    SortField[] fields;

    public Sort() {
        this(SortField.FIELD_SCORE);
    }

    public Sort(SortField field) {
        this.setSort(field);
    }

    public Sort(SortField ... fields) {
        this.setSort(fields);
    }

    public void setSort(SortField field) {
        this.fields = new SortField[]{field};
    }

    public void setSort(SortField ... fields) {
        this.fields = fields;
    }

    public SortField[] getSort() {
        return this.fields;
    }

    public Sort rewrite(IndexSearcher searcher) throws IOException {
        boolean changed = false;
        SortField[] rewrittenSortFields = new SortField[this.fields.length];
        int i = 0;
        while (i < this.fields.length) {
            rewrittenSortFields[i] = this.fields[i].rewrite(searcher);
            if (this.fields[i] != rewrittenSortFields[i]) {
                changed = true;
            }
            ++i;
        }
        return changed ? new Sort(rewrittenSortFields) : this;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < this.fields.length) {
            buffer.append(this.fields[i].toString());
            if (i + 1 < this.fields.length) {
                buffer.append(',');
            }
            ++i;
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Sort)) {
            return false;
        }
        Sort other = (Sort)o;
        return Arrays.equals(this.fields, other.fields);
    }

    public int hashCode() {
        return 1168832101 + Arrays.hashCode(this.fields);
    }

    boolean needsScores() {
        SortField[] sortFieldArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            SortField sortField = sortFieldArray[n2];
            if (sortField.getType() == SortField.Type.SCORE) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

