/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.viewer.celleditors;

import ca.infodata.ofys.ui.controls.viewer.AutoTabNextModifyListener;
import ca.infodata.ofys.ui.controls.viewer.SelectAllText;
import ca.infodata.ofys.ui.controls.viewer.TabNextAutoKeyListener;
import ca.infodata.ofys.ui.controls.viewer.celleditors.MyTextCellEditor;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.LocalDate;
import java.util.Calendar;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class DateTextCellEditor
extends MyTextCellEditor {
    static LocalDate dateIdem;

    public DateTextCellEditor(Composite arg0) {
        super(arg0);
        TextChangeListener list = new TextChangeListener();
        this.getControl().addListener(25, (Listener)list);
        this.getControl().addListener(1, (Listener)list);
        this.getControl().addListener(15, (Listener)list);
        this.getControl().addListener(16, (Listener)list);
        this.getControl().addListener(31, (Listener)list);
        ((Text)this.getControl()).setTextLimit(10);
        ((Text)this.getControl()).addModifyListener((ModifyListener)AutoTabNextModifyListener.getInstance());
        ((Text)this.getControl()).addKeyListener(TabNextAutoKeyListener.getInstance());
        ((Text)this.getControl()).addFocusListener((FocusListener)new SelectAllText());
    }

    protected String addZero(String jour) {
        if (jour.length() < 2) {
            jour = "0" + jour;
        }
        return jour;
    }

    protected class TextChangeListener
    implements Listener {
        protected TextChangeListener() {
        }

        public void handleEvent(Event event) {
            if (event.type == 25) {
                char eventChar = String.valueOf(event.character).toUpperCase().charAt(0);
                if ((eventChar < '0' || eventChar > '9') && eventChar != "-".toCharArray()[0] && eventChar != '\b' && eventChar != '\u007f' && eventChar != '\u0000') {
                    event.doit = false;
                }
            } else if (event.type == 1) {
                boolean isPeriodOk;
                char eventChar = String.valueOf(event.character).charAt(0);
                String theText = ((Text)DateTextCellEditor.this.getControl()).getText();
                LocalDate date = LocalDate.fromCalendar((Calendar)DateUtil.ctod((String)theText));
                boolean hasKey = true;
                switch (eventChar) {
                    case 'T': 
                    case 't': {
                        date = LocalDate.today();
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        break;
                    }
                    case 'X': 
                    case 'x': {
                        date = date.plusDay(1);
                        break;
                    }
                    case 'Z': 
                    case 'z': {
                        date = date.plusDay(-1);
                        break;
                    }
                    case 'S': 
                    case 's': {
                        date = date.plusDay(7);
                        break;
                    }
                    case 'A': 
                    case 'a': {
                        date = date.plusDay(-7);
                        break;
                    }
                    case 'W': 
                    case 'w': {
                        date = date.plusMonth(1);
                        break;
                    }
                    case 'Q': 
                    case 'q': {
                        date = date.plusMonth(-1);
                        break;
                    }
                    case 'M': 
                    case 'm': {
                        date = date.withDay(1);
                        break;
                    }
                    case 'H': 
                    case 'h': {
                        date = date.withDay(date.getMonthEnd());
                        break;
                    }
                    case 'I': 
                    case 'i': {
                        if (dateIdem == null) break;
                        date = dateIdem;
                        break;
                    }
                    default: {
                        hasKey = false;
                    }
                }
                if (hasKey && (isPeriodOk = true)) {
                    String ss = DateUtil.dtoc((Calendar)date.toCalendar());
                    ((Text)event.widget).setText(ss);
                    dateIdem = date;
                }
            } else if (event.type == 15) {
                if (((Text)event.widget).getText().trim().length() == 0) {
                    // empty if block
                }
            } else if (event.type == 31) {
                if (((Text)event.widget).getText().trim().length() > 0 && ((Text)event.widget).getText().trim().length() < 10) {
                    Calendar dateToPut = Calendar.getInstance();
                    String s = ((Text)event.widget).getText().trim();
                    if ((s = s.replaceAll("[^0-9]", "")).length() <= 2) {
                        s = String.valueOf(StringUtils.leftPad((String)String.valueOf(dateToPut.get(1)), (int)4, (char)'0')) + "-" + StringUtils.leftPad((String)String.valueOf(dateToPut.get(2) + 1), (int)2, (char)'0') + "-" + StringUtils.leftPad((String)s, (int)2, (char)'0');
                        ((Text)event.widget).setText(s);
                    }
                    if (s.length() <= 4) {
                        if (s.length() == 3) {
                            s = "0" + s;
                        }
                        s = String.valueOf(s.substring(0, 2)) + "-" + s.substring(2, 4);
                        ((Text)event.widget).setText(String.valueOf(StringUtils.leftPad((String)String.valueOf(dateToPut.get(1)), (int)4, (char)'0')) + "-" + StringUtils.leftPad((String)s, (int)4, (char)'0'));
                    }
                }
            } else {
                int cfr_ignored_0 = event.type;
            }
        }
    }
}

