/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.util;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.ui.controls.util.DialogSettings3;
import java.io.Serializable;

public class UserDialogSettings3
extends DialogSettings3 {
    private String keyPrefix;

    public UserDialogSettings3(String section) {
        super(section);
        this.setKeyPrefix(this.getClientCodeUserNamePrefixFromSession());
    }

    public String getClientCodeUserNamePrefixFromSession() {
        XSession session = Application.get().getGlobalInstances().getSession();
        if (session == null) {
            return "";
        }
        try {
            return String.valueOf(session.getClient().getClientCode()) + "." + session.getUser().getName() + ".";
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getClientCodePrefixFromSession() {
        XSession session = Application.get().getGlobalInstances().getSession();
        if (session == null) {
            return "";
        }
        try {
            return String.valueOf(session.getClient().getClientCode()) + ".";
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void setKeyPrefix(String prefix) {
        this.keyPrefix = prefix == null ? "" : prefix;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    @Override
    public String get(String key) {
        if (this.hasNewKey(key)) {
            key = this.getNewKey(key);
        }
        return super.get(key);
    }

    private boolean hasNewKey(String key) {
        return super.hasKey(this.getNewKey(key));
    }

    private String getNewKey(String key) {
        if (key == null) {
            return null;
        }
        if (key.startsWith(this.keyPrefix)) {
            return key;
        }
        return String.valueOf(this.keyPrefix) + key;
    }

    @Override
    public boolean hasKey(String key) {
        return this.hasNewKey(key) || super.hasKey(key);
    }

    @Override
    public Serializable getSerializable(String key) {
        if (this.hasNewKey(key)) {
            key = this.getNewKey(key);
        }
        return super.getSerializable(key);
    }

    @Override
    public void putIntArray(String key, int[] value) {
        super.putIntArray(key, value);
    }

    @Override
    public int[] getIntArray(String key) {
        if (this.hasNewKey(key)) {
            key = this.getNewKey(key);
        }
        return super.getIntArray(key);
    }

    @Override
    public String[] getArray(String key) {
        if (this.hasNewKey(key)) {
            key = this.getNewKey(key);
        }
        return super.getArray(key);
    }

    @Override
    public boolean getBoolean(String key) {
        if (this.hasNewKey(key)) {
            key = this.getNewKey(key);
        }
        return super.getBoolean(key);
    }

    @Override
    public boolean getBoolean(String key, boolean def) {
        if (this.hasNewKey(key)) {
            key = this.getNewKey(key);
        }
        return super.getBoolean(key, def);
    }

    @Override
    public double getDouble(String key) throws NumberFormatException {
        if (this.hasNewKey(key)) {
            key = this.getNewKey(key);
        }
        return super.getDouble(key);
    }

    @Override
    public float getFloat(String key) throws NumberFormatException {
        if (this.hasNewKey(key)) {
            key = this.getNewKey(key);
        }
        return super.getFloat(key);
    }

    @Override
    public int getIntSafe(String key, int def) {
        if (this.hasNewKey(key)) {
            key = this.getNewKey(key);
        }
        return super.getIntSafe(key, def);
    }

    @Override
    public int getInt(String key) throws NumberFormatException {
        if (this.hasNewKey(key)) {
            key = this.getNewKey(key);
        }
        return super.getInt(key);
    }

    @Override
    public long getLong(String key) throws NumberFormatException {
        if (this.hasNewKey(key)) {
            key = this.getNewKey(key);
        }
        return super.getLong(key);
    }

    @Override
    public void put(String key, Serializable value) {
        super.put(key, value);
    }

    @Override
    public void put(String key, double value) {
        super.put(key, value);
    }

    @Override
    public void put(String key, float value) {
        super.put(key, value);
    }

    @Override
    public void put(String key, int value) {
        super.put(key, value);
    }

    @Override
    public void put(String key, long value) {
        super.put(key, value);
    }

    @Override
    public void put(String key, String[] value) {
        String[] oldValue = this.getArray(key);
        this.beforePutEvent(key, oldValue, value);
        super.put(this.getNewKey(key), value);
        this.afterPutEvent(key, oldValue, value);
    }

    @Override
    public final void put(String key, String value) {
        String oldValue = this.get(key);
        this.beforePutEvent(key, oldValue, value);
        super.put(this.getNewKey(key), value);
        this.afterPutEvent(key, oldValue, value);
    }

    protected void beforePutEvent(String key, String oldValue, String value) {
    }

    protected void beforePutEvent(String key, String[] oldValue, String[] value) {
    }

    protected void afterPutEvent(String key, String oldValue, String value) {
    }

    protected void afterPutEvent(String key, String[] oldValue, String[] value) {
    }

    @Override
    public void put(String key, boolean value) {
        super.put(key, value);
    }

    @Override
    protected DialogSettings3 newDialogSettings3(String sectionName) {
        return new UserDialogSettings3(sectionName);
    }

    @Override
    public void removeItem(String key) {
        super.removeItem(key);
        super.removeItem(this.getNewKey(key));
    }
}

