/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.textAssistant;

import ca.infodata.ofys.ui.controls.IControl;
import ca.infodata.ofys.ui.library.IRefreshFont;
import ca.infodata.ofys.ui.library.ResourceGetter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AssistText
implements IControl,
IRefreshFont {
    private static final Logger logger = Logger.getLogger(AssistText.class.getName());
    private int fontSizeIncrement = 0;
    private int fontStyle = 0;
    private Color color = ResourceGetter.getColor((int)128, (int)128, (int)128);
    protected SourceViewer viewer;
    private IDocument document = new Document("");
    private StyledText control;
    private FormToolkit toolkit = null;
    private Color backgroundColor = null;
    protected boolean assistSessionStarted;

    public AssistText(Composite parent, int style, FormToolkit toolkit) {
        this(parent, style | (toolkit == null ? 0 : toolkit.getBorderStyle()));
        if (toolkit != null) {
            toolkit.paintBordersFor((Composite)this.control);
        }
        this.toolkit = toolkit;
        this.backgroundColor = this.getControl().getBackground();
    }

    public AssistText(Composite parent, int style) {
        this.viewer = new SourceViewer(parent, null, style);
        this.viewer.setDocument(this.document);
        this.control = this.viewer.getTextWidget();
        this.control.setDoubleClickEnabled(true);
        this.setFont(this.fontSizeIncrement, this.fontStyle);
        this.control.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    AssistText.this.control.setSelection(AssistText.this.control.getCaretOffset());
                    e.doit = true;
                }
            }
        });
        this.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ResourceGetter.dispose((Object)AssistText.this.color);
            }
        });
        this.control.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int textLimit = ((StyledText)e.widget).getTextLimit();
                if (textLimit != -1 && ((StyledText)e.widget).getText().length() > textLimit) {
                    ((StyledText)e.widget).setText(((StyledText)e.widget).getText().substring(0, textLimit));
                }
            }
        });
    }

    @Override
    public Control getControl() {
        return this.viewer.getTextWidget();
    }

    public StyledText getStyledText() {
        return this.viewer.getTextWidget();
    }

    public String getText() {
        return this.viewer.getTextWidget().getText();
    }

    public void setTextKeepSelection(String text) {
        this.setText(text);
    }

    public void setText(String text) {
        int oldCaretOffset;
        if (text == null) {
            text = "";
        }
        StyledText control = this.viewer.getTextWidget();
        int newCaretOffset = oldCaretOffset = control.getCaretOffset();
        String oldText = this.document.get();
        try {
            this.document.set(text);
            this.control.notifyListeners(24, new Event());
            newCaretOffset = text.length() < oldCaretOffset ? text.length() : oldCaretOffset;
            control.setCaretOffset(newCaretOffset);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                control.setCaretOffset(newCaretOffset + 1);
            }
            catch (Exception exception) {
                try {
                    control.setCaretOffset(newCaretOffset - 1);
                }
                catch (Exception e3) {
                    logger.log(Level.WARNING, "Failed to seText on assistText. oldText=" + oldText + ", oldTextLength=" + (oldText == null ? 0 : oldText.length()) + ", newText=" + text + ", newTextLength=" + text.length() + ", oldCaretOffset=" + oldCaretOffset + " newCaretOffset=" + newCaretOffset, e3);
                }
            }
        }
    }

    public Object getData(String key) {
        return this.viewer.getControl().getData(key);
    }

    public void setData(String key, Object value) {
        this.viewer.getControl().setData(key, value);
    }

    public void setEditable(boolean editable) {
        if (this.toolkit != null) {
            if (editable) {
                this.getControl().setBackground(this.backgroundColor);
            } else {
                this.getControl().setBackground(this.toolkit.getColors().getColor("DISABLED_BACKGROUND_COLOR"));
            }
        }
        this.getStyledText().setEditable(editable);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.toolkit != null) {
            if (enabled && this.control.getEditable()) {
                this.getControl().setBackground(this.backgroundColor);
            } else {
                this.getControl().setBackground(this.toolkit.getColors().getColor("DISABLED_BACKGROUND_COLOR"));
            }
        }
        this.getControl().setEnabled(enabled);
    }

    public void setFont(int fontSizeIncrement, int fontStyle) {
        this.fontSizeIncrement = fontSizeIncrement;
        this.fontStyle = fontStyle;
        this.control.setFont(ResourceGetter.getFont((int)fontSizeIncrement, (int)fontStyle));
    }

    public void refreshFont() {
        this.setFont(this.fontSizeIncrement, this.fontStyle);
    }
}

