/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.template.editor;

import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.template.XTemplate;
import ca.infodata.ofys.ui.controls.MyMessageDialogBuilder;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.MyText;
import ca.infodata.ofys.ui.controls.template.TemplateAccessorClient;
import ca.infodata.ofys.ui.controls.template.editor.TemplateTextControl;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TemplateTextDialog
extends MyMessageDialogBuilder {
    private XTemplate template;
    private TemplateAccessorClient accessor;
    private MyText txtName;
    private TemplateTextControl templateTextControl;

    public TemplateTextDialog(Shell shell, XTemplate template, TemplateAccessorClient accessor) {
        this.template = template;
        this.accessor = accessor;
        this.setButtonLabels("Ajouter comme nouveau", "Sauvegarder", "Supprimer", "Annuler");
        this.setDefaultButton(-1);
        this.setParent(shell);
        this.setTitle(template.getName());
    }

    @Override
    protected boolean buttonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                return this.saveAsNew();
            }
            case 1: {
                return this.save();
            }
            case 2: {
                return this.delete();
            }
            case 3: {
                return this.cancel();
            }
        }
        return true;
    }

    private boolean cancel() {
        return true;
    }

    private boolean delete() {
        if (this.template.getId() != null && this.template.getId() != -1) {
            try {
                this.accessor.delete(this.template.getId());
            }
            catch (Exception e) {
                MessageUtil.warningMsg((Shell)this.txtName.getShell(), (String)e.getMessage());
                return false;
            }
        }
        return true;
    }

    private boolean save() {
        this.template.setName(this.txtName.getText().trim());
        this.template.setText(this.templateTextControl.getText());
        try {
            this.accessor.save(this.template);
        }
        catch (Exception e) {
            MessageUtil.warningMsg((Shell)this.txtName.getShell(), (String)e.getMessage());
            return false;
        }
        return true;
    }

    private boolean saveAsNew() {
        this.template.setId(null);
        return this.save();
    }

    @Override
    protected Control createCustomArea(Composite parent) {
        MyLabel lblName = new MyLabel(parent, 16384);
        lblName.setText("Nom");
        this.txtName = new MyText(parent, 2052);
        this.txtName.setText(this.template.getName());
        this.templateTextControl = new TemplateTextControl(parent, 0);
        this.templateTextControl.setText(this.template.getText());
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        lblName.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(lblName.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.txtName.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.txtName.getControl(), 15);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.height = 400;
        this.templateTextControl.setLayoutData(data);
        return parent;
    }

    @Override
    protected boolean customShouldTakeFocus() {
        return true;
    }
}

