/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.template.editor;

import ca.infodata.ofys.client.modules.template.DDate;
import ca.infodata.ofys.client.modules.template.DField;
import ca.infodata.ofys.client.modules.template.DList;
import ca.infodata.ofys.client.modules.template.DNum;
import ca.infodata.ofys.client.modules.template.DRaw;
import ca.infodata.ofys.client.modules.template.DText;
import ca.infodata.ofys.client.modules.template.TemplateDefinitionParser;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.template.editor.DDateDialog;
import ca.infodata.ofys.ui.controls.template.editor.DListDialog;
import ca.infodata.ofys.ui.controls.template.editor.DNumDialog;
import ca.infodata.ofys.ui.controls.template.editor.DTextDialog;
import ca.infodata.ofys.ui.controls.template.editor.TemplateListDialog;
import ca.infodata.ofys.ui.controls.template.editor.XTemplateContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.PaintObjectEvent;
import org.eclipse.swt.custom.PaintObjectListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TemplateTextControl
extends Composite {
    static final char[] values = new char[]{'\u0391', '\u0392', '\u0393', '\u0394', '\u0395', '\u0396', '\u0397', '\u0398', '\u0399', '\u039a', '\u039b', '\u039c', '\u039d', '\u039e', '\u039f', '\u03a0', '\u03a1', '\u03a2', '\u03a3', '\u03a4', '\u03a5', '\u03a6', '\u03a7', '\u03a8', '\u03a9', '\u03aa', '\u03ab', '\u03ac', '\u03ad', '\u03ae', '\u03af', '\u03b0', '\u03b1', '\u03b2', '\u03b3', '\u03b4', '\u03b5', '\u03b6', '\u03b7', '\u03b8', '\u03b9', '\u03ba', '\u03bb', '\u03bc', '\u03bd', '\u03be', '\u03bf'};
    private StyledText styledText;
    private MyButton btnAddDate;
    private MyButton btnAddText;
    private MyButton btnAddNum;
    private MyButton btnAddList;
    private MyButton btnAddDField;
    private int nextValue;
    private final ConcurrentLinkedQueue<Data> datas;
    private XCompletionProposalType type;
    private final Map<Integer, Data> styleMapData;
    private final Map<Data, StyleRange> dataMapStyle;
    private Color background;
    private Color border;
    private Font fontBold;
    private boolean settext;
    private XTemplateContainer templateContainer;

    public TemplateTextControl(Composite parent, int style) {
        this(parent, style, null);
    }

    public TemplateTextControl(Composite parent, int style, FormToolkit toolkit) {
        super(parent, style);
        this.background = new Color((Device)parent.getDisplay(), 50, 50, 255);
        this.border = new Color((Device)parent.getDisplay(), 0, 0, 0);
        Font font = this.getFont();
        FontData fontData = font.getFontData()[0];
        this.fontBold = new Font((Device)parent.getDisplay(), fontData.getName(), fontData.getHeight(), fontData.getStyle() | 1);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TemplateTextControl.this.background.dispose();
                TemplateTextControl.this.border.dispose();
                TemplateTextControl.this.fontBold.dispose();
            }
        });
        this.datas = new ConcurrentLinkedQueue();
        this.dataMapStyle = new HashMap<Data, StyleRange>();
        this.styleMapData = new HashMap<Integer, Data>();
        this.styledText = new StyledText((Composite)this, 2880);
        this.btnAddText = new MyButton(this, "+Texte", 8, toolkit);
        this.btnAddText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateTextControl.this.addField((DField)new DText());
            }
        });
        this.btnAddDate = new MyButton(this, "+Date", 8, toolkit);
        this.btnAddDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateTextControl.this.addField((DField)new DDate());
            }
        });
        this.btnAddNum = new MyButton(this, "+Nombre", 8, toolkit);
        this.btnAddNum.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateTextControl.this.addField((DField)new DNum());
            }
        });
        this.btnAddList = new MyButton(this, "+Liste", 8, toolkit);
        this.btnAddList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateTextControl.this.addField((DField)new DList());
            }
        });
        this.btnAddDField = new MyButton(this, "+Mod\u00e8le", 8, toolkit);
        this.btnAddDField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TemplateTextControl.this.checkFieldCountLimit()) {
                    int caret = TemplateTextControl.this.styledText.getCaretOffset();
                    int topPixel = TemplateTextControl.this.styledText.getTopPixel();
                    TemplateListDialog dialog = new TemplateListDialog(TemplateTextControl.this.getShell(), TemplateTextControl.this.templateContainer);
                    int r = dialog.buildAndOpen();
                    if (r == 0) {
                        TemplateTextControl.this.styledText.setRedraw(false);
                        if (dialog.getField() != null) {
                            Data data = new Data();
                            data.field = dialog.getField();
                            TemplateTextControl templateTextControl = TemplateTextControl.this;
                            int n = templateTextControl.nextValue;
                            templateTextControl.nextValue = n + 1;
                            data.value = values[n];
                            data.end = data.start = caret;
                            TemplateTextControl.this.datas.add(data);
                            String sData = String.valueOf(data.value);
                            TemplateTextControl.this.styledText.insert(sData);
                            TemplateTextControl.this.setText(TemplateTextControl.this.getText());
                            TemplateTextControl.this.styledText.setTopPixel(topPixel);
                            TemplateTextControl.this.styledText.setCaretOffset(caret + sData.length());
                        } else if (dialog.getTemplate() != null) {
                            String text = dialog.getTemplate().getText();
                            TemplateDefinitionParser parser = new TemplateDefinitionParser();
                            List list = parser.parseNewFormat(text);
                            StringBuilder newText = new StringBuilder(100);
                            if (TemplateTextControl.this.checkFieldCountLimit(list.size())) {
                                int start = 0;
                                int i = 0;
                                while (i < list.size()) {
                                    DField f = (DField)list.get(i);
                                    if (f instanceof DRaw) {
                                        newText.append(((DRaw)f).raw);
                                    } else {
                                        Data data = new Data();
                                        data.field = f;
                                        TemplateTextControl templateTextControl = TemplateTextControl.this;
                                        int n = templateTextControl.nextValue;
                                        templateTextControl.nextValue = n + 1;
                                        data.value = values[n];
                                        start = data.end = (data.start = start);
                                        TemplateTextControl.this.datas.add(data);
                                        newText.append(data.value);
                                    }
                                    ++i;
                                }
                                TemplateTextControl.this.styledText.insert(newText.toString());
                                TemplateTextControl.this.setText(TemplateTextControl.this.getText());
                                TemplateTextControl.this.styledText.setTopPixel(topPixel);
                                TemplateTextControl.this.styledText.setCaretOffset(caret + newText.length());
                            }
                        }
                        TemplateTextControl.this.styledText.setRedraw(true);
                    }
                }
            }
        });
        this.styledText.addLineStyleListener(new LineStyleListener(){

            public void lineGetStyle(LineStyleEvent e) {
                ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
                for (Data data : TemplateTextControl.this.datas) {
                    int index = e.lineText.indexOf(data.value);
                    if (index == -1) continue;
                    StyleRange style = (StyleRange)TemplateTextControl.this.dataMapStyle.get(data);
                    if (style == null) {
                        style = new StyleRange();
                        TemplateTextControl.this.dataMapStyle.put(data, style);
                        data.index = -1;
                    }
                    if (data.index != index) {
                        if (style.metrics != null) {
                            TemplateTextControl.this.styleMapData.remove(TemplateTextControl.this.hashStyle(style));
                        }
                        data.index = index;
                        style.start = e.lineOffset + index;
                        style.length = 1;
                        GC gc = new GC((Drawable)TemplateTextControl.this.styledText.getDisplay());
                        gc.setFont(TemplateTextControl.this.fontBold);
                        Point size = gc.textExtent(data.field.name, 1);
                        gc.dispose();
                        int ascent = 2 * size.y / 3;
                        int descent = size.y - ascent;
                        style.metrics = new GlyphMetrics(ascent, descent, size.x);
                        TemplateTextControl.this.styleMapData.put(TemplateTextControl.this.hashStyle(style), data);
                    }
                    styles.add(style);
                }
                e.styles = styles.toArray(new StyleRange[styles.size()]);
            }
        });
        this.styledText.addPaintObjectListener(new PaintObjectListener(){

            public void paintObject(PaintObjectEvent event) {
                Data data = (Data)TemplateTextControl.this.styleMapData.get(TemplateTextControl.this.hashStyle(event.style));
                if (data != null) {
                    data.paintControl(event);
                }
            }
        });
        this.styledText.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                for (Data data : TemplateTextControl.this.datas) {
                    boolean old = data.mouseOver;
                    boolean bl = data.mouseOver = data.rect != null && data.rect.contains(e.x, e.y);
                    if (old == data.mouseOver || data.rect == null) continue;
                    TemplateTextControl.this.styledText.redraw(data.rect.x, data.rect.y, data.rect.width, data.rect.height, false);
                }
            }
        });
        this.styledText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                for (Data data : TemplateTextControl.this.datas) {
                    if (data.rect == null || !data.rect.contains(e.x, e.y)) continue;
                    data.widgetSelected(e);
                }
            }
        });
        this.styledText.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent e) {
                block9: {
                    String c;
                    block8: {
                        if (e.keyCode != 8 && e.keyCode != 127) break block8;
                        int caret = TemplateTextControl.this.styledText.getCaretOffset();
                        Point sel = TemplateTextControl.this.styledText.getSelection();
                        String c2 = null;
                        String text = TemplateTextControl.this.styledText.getText();
                        if (text.length() <= 0) break block9;
                        if (sel.x == sel.y) {
                            System.out.println(text.length());
                            c2 = e.keyCode == 8 && caret != 0 ? TemplateTextControl.this.styledText.getText(caret - 1, caret - 1) : (sel.x == text.length() && e.keyCode == 127 ? "" : TemplateTextControl.this.styledText.getText(caret, caret));
                        } else {
                            c2 = TemplateTextControl.this.styledText.getText(sel.x, sel.y - 1);
                            caret = sel.y;
                        }
                        if (!c2.contains("\n")) {
                            for (Data data : TemplateTextControl.this.datas) {
                                StyleRange style = (StyleRange)TemplateTextControl.this.dataMapStyle.get(data);
                                if (style == null || style.start + 1 <= caret) continue;
                                if (style.metrics != null) {
                                    Data dataRemoved = (Data)TemplateTextControl.this.styleMapData.remove(TemplateTextControl.this.hashStyle(style));
                                    System.out.println(dataRemoved);
                                }
                                style.start -= c2.length();
                                TemplateTextControl.this.styleMapData.put(TemplateTextControl.this.hashStyle(style), data);
                            }
                        }
                        break block9;
                    }
                    if (e.character != '\u0000' && (c = String.valueOf(e.character)).length() > 0) {
                        int caret = TemplateTextControl.this.styledText.getCaretOffset();
                        for (Data data : TemplateTextControl.this.datas) {
                            StyleRange style = (StyleRange)TemplateTextControl.this.dataMapStyle.get(data);
                            if (style == null || style.start <= caret) continue;
                            if (style.metrics != null) {
                                TemplateTextControl.this.styleMapData.remove(TemplateTextControl.this.hashStyle(style));
                            }
                            style.start += c.length();
                            TemplateTextControl.this.styleMapData.put(TemplateTextControl.this.hashStyle(style), data);
                        }
                    }
                }
            }
        });
        this.styledText.addExtendedModifyListener(new ExtendedModifyListener(){

            public void modifyText(ExtendedModifyEvent e) {
                if (TemplateTextControl.this.settext) {
                    return;
                }
                Iterator iterator = TemplateTextControl.this.datas.iterator();
                while (iterator.hasNext()) {
                    Data data = (Data)iterator.next();
                    if (e.replacedText.indexOf(data.value) == -1) continue;
                    iterator.remove();
                }
                if (e.replacedText.indexOf("\n") != -1) {
                    int caret = TemplateTextControl.this.styledText.getCaretOffset();
                    int topPixel = TemplateTextControl.this.styledText.getTopPixel();
                    TemplateTextControl.this.styledText.setRedraw(false);
                    TemplateTextControl.this.setText(TemplateTextControl.this.getText());
                    TemplateTextControl.this.styledText.setTopPixel(topPixel);
                    TemplateTextControl.this.styledText.setCaretOffset(caret);
                    TemplateTextControl.this.styledText.setRedraw(true);
                }
            }
        });
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        this.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        this.btnAddText.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.btnAddText.getControl());
        this.btnAddNum.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.btnAddNum.getControl());
        this.btnAddDate.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.btnAddDate.getControl());
        this.btnAddList.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.btnAddList.getControl());
        this.btnAddDField.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.btnAddList.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.styledText.setLayoutData((Object)data);
    }

    protected void removeAll(Collection<Data> list) {
        this.datas.removeAll(list);
        for (Data data : list) {
            StyleRange style = this.dataMapStyle.remove(data);
            if (style == null) continue;
            this.styleMapData.remove(this.hashStyle(style));
        }
    }

    public void addField(DField f) {
        if (this.checkFieldCountLimit()) {
            int caret = this.styledText.getCaretOffset();
            int topPixel = this.styledText.getTopPixel();
            int r = this.openDialog(f);
            if (r == 0) {
                try {
                    try {
                        this.styledText.setRedraw(false);
                        Data data = new Data();
                        data.field = f;
                        data.value = values[this.nextValue++];
                        data.end = data.start = caret;
                        this.datas.add(data);
                        String sData = String.valueOf(data.value);
                        this.styledText.insert(sData);
                        this.setText(this.getText());
                        this.styledText.setTopPixel(topPixel);
                        this.styledText.setCaretOffset(caret + sData.length());
                    }
                    catch (Exception e) {
                        MessageUtil.show((Shell)this.getShell(), (Exception)e);
                        this.styledText.setRedraw(true);
                    }
                }
                finally {
                    this.styledText.setRedraw(true);
                }
            }
        }
    }

    private boolean checkFieldCountLimit() {
        return this.checkFieldCountLimit(1);
    }

    private boolean checkFieldCountLimit(int nomberOfFieldsToAdd) {
        if (this.nextValue + nomberOfFieldsToAdd >= values.length) {
            MessageUtil.warningMsg((Shell)this.getShell(), (String)Messages.getString((String)"TemplateTextControl.LIMITE_DAJOUT_DE_CONTROLE_ATTEINTE", (String[])new String[]{String.valueOf(values.length)}));
            return false;
        }
        return true;
    }

    private int openDialog(DField f) {
        if (f instanceof DText) {
            return new DTextDialog(this.getShell(), (DText)f, this.type).buildAndOpen();
        }
        if (f instanceof DList) {
            return new DListDialog(this.getShell(), (DList)f, this.type).buildAndOpen();
        }
        if (f instanceof DNum) {
            return new DNumDialog(this.getShell(), (DNum)f, this.type).buildAndOpen();
        }
        if (f instanceof DDate) {
            return new DDateDialog(this.getShell(), (DDate)f, this.type).buildAndOpen();
        }
        return 1;
    }

    protected int hashStyle(StyleRange style) {
        int hash = 13;
        hash *= style.start;
        return hash *= style.metrics.hashCode();
    }

    public void setText(String text) {
        this.datas.clear();
        this.styleMapData.clear();
        this.dataMapStyle.clear();
        this.nextValue = 0;
        TemplateDefinitionParser parser = new TemplateDefinitionParser();
        List list = parser.isFormatMedo(text) ? parser.parseMedo(text) : parser.parseNewFormat(text);
        StringBuilder newText = new StringBuilder(100);
        int start = 0;
        int i = 0;
        while (i < list.size()) {
            DField f = (DField)list.get(i);
            if (f instanceof DRaw) {
                newText.append(((DRaw)f).raw);
            } else {
                Data data = new Data();
                data.field = f;
                data.value = values[this.nextValue++];
                start = data.end = (data.start = start);
                this.datas.add(data);
                newText.append(data.value);
            }
            ++i;
        }
        this.settext = true;
        this.styledText.setText(newText.toString());
        this.settext = false;
    }

    public String getText() {
        String text = this.styledText.getText();
        for (Data data : this.datas) {
            text = text.replace(String.valueOf(data.value), data.field.format());
        }
        return text;
    }

    public StyledText getControl() {
        return this.styledText;
    }

    public final XCompletionProposalType getType() {
        return this.type;
    }

    public final void setType(XCompletionProposalType type) {
        this.type = type;
    }

    public final void setTemplateContainer(XTemplateContainer templateContainer) {
        this.templateContainer = templateContainer;
    }

    public static void main(String[] args) {
        String text = "${Salut;999}salut${Hey merde;1/2/3}Oupss ";
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        TemplateTextControl control = new TemplateTextControl((Composite)shell, 0, null);
        control.setText(text);
        shell.pack();
        shell.setSize(400, 400);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    protected class Data {
        char value;
        int start;
        int end;
        Rectangle rect;
        int index = -1;
        boolean mouseOver;
        DField field;

        protected Data() {
        }

        public String toString() {
            return "Data [start=" + this.start + ", end=" + this.end + ", value=" + this.value + ", field=" + this.field + "]";
        }

        public void widgetSelected(MouseEvent e) {
            int caret = TemplateTextControl.this.styledText.getCaretOffset();
            int topPixel = TemplateTextControl.this.styledText.getTopPixel();
            int r = TemplateTextControl.this.openDialog(this.field);
            if (r == 0) {
                TemplateTextControl.this.styledText.setRedraw(false);
                TemplateTextControl.this.setText(TemplateTextControl.this.getText());
                TemplateTextControl.this.styledText.setTopPixel(topPixel);
                TemplateTextControl.this.styledText.setSelection(caret);
                TemplateTextControl.this.styledText.setRedraw(true);
            }
        }

        public void paintControl(PaintObjectEvent event) {
            GC gc = event.gc;
            Font oldFont = gc.getFont();
            Color oldForeground = gc.getForeground();
            gc.setFont(TemplateTextControl.this.fontBold);
            gc.setForeground(this.mouseOver ? TemplateTextControl.this.background : TemplateTextControl.this.border);
            int x = event.x;
            int y = event.y;
            String text = this.field.name;
            Point size = gc.textExtent(text);
            gc.drawLine(x, y + size.y, x + size.x, y + size.y);
            gc.drawText(text, x, y, true);
            gc.setForeground(oldForeground);
            gc.setFont(oldFont);
            if (this.rect == null) {
                this.rect = new Rectangle(x, y, size.x, size.y);
            } else {
                this.rect.x = x;
                this.rect.y = y;
                this.rect.height = size.y;
                this.rect.width = size.x;
            }
        }

        public int hashCode() {
            return this.value;
        }
    }
}

