/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.template.editor;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.template.DField;
import ca.infodata.ofys.client.modules.template.DRaw;
import ca.infodata.ofys.client.modules.template.TemplateDefinitionParser;
import ca.infodata.ofys.client.modules.template.TypeDeDonnee;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPreValidator2;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescriptionDomains;
import ca.infodata.ofys.data.middle.dataobjects.template.XTemplate;
import ca.infodata.ofys.ui.controls.BaseSectionSwitchTable;
import ca.infodata.ofys.ui.controls.IBaseEditor2;
import ca.infodata.ofys.ui.controls.ListTable;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyText;
import ca.infodata.ofys.ui.controls.template.TemplateAccessorClient;
import ca.infodata.ofys.ui.controls.template.TemplateAssistTextDialog;
import ca.infodata.ofys.ui.controls.template.editor.TemplateTextControl;
import ca.infodata.ofys.ui.controls.template.editor.XTemplateContainer;
import ca.infodata.ofys.ui.controls.template.editor.XTemplateWrapper;
import ca.infodata.ofys.ui.controls.webbrowser.AdvancedBrowser;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.IPair;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TemplateEditorControl
extends BaseSectionSwitchTable<XTemplateWrapper>
implements IPreValidator2<XTemplateWrapper> {
    private static final Logger logger = Logger.getLogger(TemplateEditorControl.class.getName());
    private MyText txtCompletionName;
    private TemplateTextControl txtCompletionResult;
    private MyButton chkPartager;
    private MyButton btnSee;
    private XTemplateWrapper current;
    private XCompletionProposalType type;
    private int typeValue;
    private String error;

    public TemplateEditorControl(Composite parent, IBaseEditor2 editor, FormToolkit toolkit, XTemplateContainer templateContainer) {
        super(parent, editor, ListTable.TOP | ListTable.HIDE_UP_DOWN, toolkit);
        this.type = templateContainer == null ? null : templateContainer.getType();
        this.typeValue = templateContainer == null ? null : templateContainer.getTypeValue();
        this.txtCompletionResult.setType(this.type);
        this.setTemplateContainer(templateContainer);
    }

    public void setTemplateContainer(XTemplateContainer templateContainer) {
        this.txtCompletionResult.setTemplateContainer(templateContainer);
    }

    @Override
    public void createEditionControl(Composite parent) {
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        this.txtCompletionName = new MyText(parent, Messages.getString((String)"NOM", (String[])new String[0]), 0, this.toolkit);
        this.txtCompletionName.setTextLimit(100);
        this.chkPartager = new MyButton(parent, "Partager ?", 32, this.toolkit);
        this.btnSee = new MyButton(parent, Messages.getString((String)"VOIR", (String[])new String[0]), 8, this.toolkit);
        this.txtCompletionResult = new TemplateTextControl(parent, 0, this.toolkit);
        this.addColumn(50, "ID");
        this.addColumn(200, Messages.getString((String)"NOM", (String[])new String[0]));
        this.addColumn(400, Messages.getString((String)"RESULTAT", (String[])new String[0]));
        this.addColumn(50, "Partager?");
        this.setLabelProvider(new ProviderAR<XTemplateWrapper, String[]>(){

            public String[] get(XTemplateWrapper t) {
                TemplateDefinitionParser parser = new TemplateDefinitionParser();
                String text = t.getText();
                List list = parser.isFormatMedo(text) ? parser.parseMedo(text) : parser.parseNewFormat(text);
                StringBuilder newText = new StringBuilder(100);
                int i = 0;
                while (i < list.size()) {
                    DField f = (DField)list.get(i);
                    if (f instanceof DRaw) {
                        newText.append(((DRaw)f).raw);
                    } else {
                        newText.append("[" + f.name + "]");
                    }
                    ++i;
                }
                return new String[]{String.valueOf(t.getId()), t.getName(), newText.toString(), Boolean.FALSE.equals(t.getTemplate().getIsClientPrivate()) ? "Oui" : "Non"};
            }
        });
        this.txtCompletionName.addModifyListener(new BaseSectionSwitchTable.SwitchTableModifyListener(this){

            @Override
            public void sectionEdited(Event e) {
                TemplateEditorControl.this.current.setName(TemplateEditorControl.this.txtCompletionName.getText().trim());
            }
        });
        this.chkPartager.addSelectionListener(new BaseSectionSwitchTable.SwitchTableModifyListener(this){

            @Override
            public void sectionEdited(Event e) {
                TemplateEditorControl.this.current.getTemplate().setIsClientPrivate(Boolean.valueOf(Boolean.FALSE.equals(TemplateEditorControl.this.chkPartager.getSelection())));
            }
        });
        this.btnSee.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = TemplateEditorControl.this.txtCompletionResult.getText();
                String resultat = "";
                if (text.startsWith("<html>")) {
                    AdvancedBrowser adbr = new AdvancedBrowser(TemplateEditorControl.this.txtCompletionResult.getShell(), text);
                    adbr.open();
                    if (adbr.isOkPressed()) {
                        resultat = adbr.getHtml();
                    }
                    if (resultat.length() > 0) {
                        String[] t = resultat.split(",");
                        String r = resultat.substring(1);
                        if (t.length == 8) {
                            r = "Qt " + t[1] + "\n ";
                            r = String.valueOf(r) + "Jr/Dy " + t[2] + "\n ";
                            r = String.valueOf(r) + "Fmt " + XPrescriptionDomains.getOnlyDrugForm((Integer)Integer.valueOf(t[3])).description() + "\n ";
                            r = String.valueOf(r) + "Rx " + Integer.valueOf(t[4]) + "\n ";
                            r = String.valueOf(r) + "Pos " + t[5] + "\n ";
                            r = String.valueOf(r) + "Rte " + XPrescriptionDomains.getOnlyRouteAndSiteDesc((Integer)Integer.valueOf(t[6])) + "\n ";
                            resultat = r = String.valueOf(r) + "Frq " + t[7];
                        }
                        MessageDialog.openInformation((Shell)TemplateEditorControl.this.txtCompletionResult.getShell(), (String)"Canevas posologique", (String)resultat);
                    }
                } else {
                    ShellAdapter shellAdapter;
                    final TemplateAssistTextDialog win = new TemplateAssistTextDialog(TemplateEditorControl.this.txtCompletionResult.getShell(), "", text);
                    IPair<Shell, Integer> rep = win.buildAndOpen2(shellAdapter = new ShellAdapter(){

                        public void shellActivated(ShellEvent shellevent) {
                            for (Control list : win.getLstListe()) {
                                if (list.isDisposed()) continue;
                                list.notifyListeners(13, new Event());
                            }
                        }
                    });
                    if ((Integer)rep.getSecond() == 0 && !win.getLstDonnees().isEmpty()) {
                        List<TemplateAssistTextDialog.Donnee> donnees = win.getLstDonnees();
                        HashMap dxs = new HashMap();
                        for (TemplateAssistTextDialog.Donnee dd : donnees) {
                            if (!dd.getType().equals((Object)TypeDeDonnee.DX) || !StringUtils.isNotEmpty((String)dd.getValue())) continue;
                            if (dxs.isEmpty()) {
                                dxs.put(dd.getType(), new ArrayList());
                            }
                            ((List)dxs.get(dd.getType())).add(dd.getValue());
                        }
                        if (!dxs.isEmpty()) {
                            List texts = (List)dxs.get(TypeDeDonnee.DX);
                            String textDx = "";
                            for (String s : texts) {
                                textDx = String.valueOf(textDx) + s + ", ";
                            }
                            textDx = StringUtils.removeAccent((String)textDx).toUpperCase().replace(" ET ", ", ");
                        }
                    }
                }
            }
        });
        this.addListSelectionChangeListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XTemplateWrapper xtw = (XTemplateWrapper)((Object)TemplateEditorControl.this.getFirstSelectedItem());
                if (xtw != null && Application.get().getGlobalInstances().getSession().getClient().getId().equals(xtw.getTemplate().getClientId())) {
                    TemplateEditorControl.this.setBtnDeleteEnabled(true);
                } else {
                    TemplateEditorControl.this.setBtnDeleteEnabled(false);
                }
            }
        });
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(50);
        this.txtCompletionName.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.txtCompletionName.getControl());
        this.chkPartager.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(0, UI.getAjustedPosition());
        data.left = new FormAttachment(this.chkPartager.getControl(), 5);
        data.right = new FormAttachment(95);
        this.btnSee.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.txtCompletionName.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(95);
        data.height = 280;
        this.txtCompletionResult.setLayoutData(data);
    }

    @Override
    protected String getTitle() {
        return Messages.getString((String)"ASSISTANT_DE_COMPLETION", (String[])new String[0]);
    }

    @Override
    protected XTemplateWrapper initializeNewDataObject() {
        XTemplateWrapper t = new XTemplateWrapper(new XTemplate(), XTemplateWrapper.XTemplateLevel.MINE);
        t.setType(this.typeValue);
        t.getTemplate().setIsClientPrivate(Boolean.valueOf(false));
        return t;
    }

    @Override
    protected void setFirstFocus() {
        this.txtCompletionName.forceFocus();
    }

    @Override
    protected void showDataObject(XTemplateWrapper selection) {
        this.current = selection;
        if (selection == null) {
            this.txtCompletionName.setText(null);
            this.txtCompletionResult.setText(null);
            this.chkPartager.setSelection(false);
            this.chkPartager.setEnabled(true);
            this.btnSee.setEnabled(false);
        } else {
            this.txtCompletionName.setText(selection.getName());
            this.txtCompletionResult.setText(selection.getText());
            this.txtCompletionName.setFocus();
            this.chkPartager.setSelection(Boolean.FALSE.equals(selection.getTemplate().getIsClientPrivate()));
            if (selection.getTemplate().getUserId() != null && Application.get().getGlobalInstances().getSession().getUser().getId().equals(selection.getTemplate().getUserId()) || selection.getId() == null) {
                this.chkPartager.setEnabled(true);
            } else {
                this.chkPartager.setEnabled(false);
            }
            this.btnSee.setEnabled(true);
        }
    }

    @Override
    protected int getInternalSectionStyle() {
        return 64;
    }

    public boolean validForSave(XTemplateWrapper e) {
        e.getTemplate().setText(this.txtCompletionResult.getText());
        if (StringUtils.isBlank((CharSequence)e.getName())) {
            this.error = Messages.getString((String)"ENTREZ_LE_NOM_DU_GABARIT", (String[])new String[0]);
            return false;
        }
        if (StringUtils.isBlank((CharSequence)e.getText())) {
            this.error = Messages.getString((String)"ENTREZ_LE_TEXTE_DU_GABARIT", (String[])new String[0]);
            return false;
        }
        return true;
    }

    public boolean validForDelete(XTemplateWrapper e) {
        return true;
    }

    public boolean validForEdition(XTemplateWrapper e) {
        return true;
    }

    public String getError() {
        return this.error;
    }

    @Override
    protected IPreValidator2<XTemplateWrapper> getPreValidatorNewInstance2() {
        return this;
    }

    public XCompletionProposalType getType() {
        return this.type;
    }

    public void setType(XCompletionProposalType type) {
        this.type = type;
    }

    @Override
    protected boolean saving(XTemplateWrapper t) {
        if (t != null && t.isDirty()) {
            try {
                TemplateAccessorClient instance = TemplateAccessorClient.getInstance();
                t.setTemplate(instance.save(t.getTemplate()));
                return true;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "failed to save template " + StringUtils.safeToString((Logger)logger, (Object)t.getTemplate()), e);
                MessageUtil.show((Shell)this.getShell(), (Exception)e);
            }
        }
        return false;
    }

    @Override
    protected boolean deleting(XTemplateWrapper t) {
        if (t != null) {
            try {
                t.getTemplate().setIsActif(Boolean.valueOf(false));
                TemplateAccessorClient instance = TemplateAccessorClient.getInstance();
                instance.save(t.getTemplate());
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                MessageUtil.show((Shell)this.getShell(), (Exception)e);
            }
        }
        return false;
    }

    public int getTypeValue() {
        return this.typeValue;
    }

    public void setTypeValue(int typeValue) {
        this.typeValue = typeValue;
    }
}

