/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.report2.properties;

import java.awt.print.Paper;

class PaperWrapper {
    String name;
    String prettyName;
    Paper paper;
    double height;
    double width;
    double imageableHeight;
    double imageableWidth;
    double imageableX;
    double imageableY;

    public PaperWrapper(String name, String prettyName, Paper paper) {
        this.name = name;
        this.prettyName = prettyName;
        this.height = paper.getHeight();
        this.width = paper.getWidth();
        this.imageableHeight = paper.getImageableHeight();
        this.imageableWidth = paper.getImageableWidth();
        this.imageableX = paper.getImageableX();
        this.imageableY = paper.getImageableY();
    }

    public String toString() {
        return "PaperWrapper [width=" + this.width + ", height=" + this.height + ", imageableX=" + this.imageableX + ", imageableY=" + this.imageableY + ", imageableWidth=" + this.imageableWidth + ", imageableHeight=" + this.imageableHeight + ", name=" + this.name + "]";
    }

    public boolean sameAs(double pfWidth, double pfHeight) {
        if (!this.isSame(pfWidth, this.width)) {
            return false;
        }
        return this.isSame(pfHeight, this.height);
    }

    private boolean isSame(double a, double b) {
        int a2 = (int)a;
        int b2 = (int)b;
        int diff = Math.abs(a2 - b2);
        return diff < 5;
    }

    public int hashCode() {
        int result = 1;
        long temp = Double.doubleToLongBits(this.height);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.imageableHeight);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.imageableWidth);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.imageableX);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.imageableY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.width);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PaperWrapper other = (PaperWrapper)obj;
        if (Double.doubleToLongBits(this.height) != Double.doubleToLongBits(other.height)) {
            return false;
        }
        if (Double.doubleToLongBits(this.imageableHeight) != Double.doubleToLongBits(other.imageableHeight)) {
            return false;
        }
        if (Double.doubleToLongBits(this.imageableWidth) != Double.doubleToLongBits(other.imageableWidth)) {
            return false;
        }
        if (Double.doubleToLongBits(this.imageableX) != Double.doubleToLongBits(other.imageableX)) {
            return false;
        }
        if (Double.doubleToLongBits(this.imageableY) != Double.doubleToLongBits(other.imageableY)) {
            return false;
        }
        return Double.doubleToLongBits(this.width) == Double.doubleToLongBits(other.width);
    }
}

