/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.report2;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.middle.dataobjects.XFinishedReport;
import ca.infodata.ofys.data.middle.dataobjects.XReportContainer;
import ca.infodata.ofys.data.middle.dataobjects.XReportReturnContainer;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IReport;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.PageFormat2;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.PrintMode;
import ca.infodata.ofys.ui.browser.HtmlBrowserTools;
import ca.infodata.ofys.ui.browser.HtmlPdfViewerResource;
import ca.infodata.ofys.ui.browser.HtmlResource;
import ca.infodata.ofys.ui.library.file.FileUtil;
import ca.infodata.ofys.ui.pdf.PrintPdfX;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;
import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfReader;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.time.FastDateFormat;
import org.eclipse.swt.program.Program;

public class ReportCallback
extends JobCallback {
    private static final Logger logger = Logger.getLogger(ReportCallback.class.getName());
    private Object dataObject;
    private XReportContainer reportContainer;
    private XReportReturnContainer reportReturnContainer;
    private boolean showInPdf = true;
    public transient XFinishedReport finishedReport = null;
    public transient Integer numberOfDocuments = null;

    public ReportCallback(String titre, boolean showInPdf, boolean useInternalPdfViewer, IStatusHandler statusHandler) {
        super(titre, statusHandler);
        this.showInPdf = showInPdf;
    }

    public ReportCallback(String titre, boolean showInPdf, boolean useInternalPdfViewer, XFinishedReport fr, Integer nd, IStatusHandler statusHandler) {
        super(titre, statusHandler);
        this.showInPdf = showInPdf;
        this.finishedReport = fr;
        this.numberOfDocuments = nd;
    }

    public void responseReceived(ReturnObject response) {
        if (response == null || response.getObj() == null) {
            return;
        }
        try {
            boolean hasCsv;
            XReportReturnContainer container;
            this.reportReturnContainer = container = (XReportReturnContainer)response.getObj();
            Map pdfReports = container.getPdfTypeXFinishedReport();
            boolean hasPdf = !pdfReports.isEmpty();
            Map csvReports = container.getCsvTypeXFinishedReport();
            boolean bl = hasCsv = !csvReports.isEmpty();
            if (hasPdf) {
                for (Map.Entry entry : pdfReports.entrySet()) {
                    File docFile = null;
                    if ((((XFinishedReport)entry.getValue()).getDocument() == null || ((XFinishedReport)entry.getValue()).getDocument().length == 0) && ((XFinishedReport)entry.getValue()).getProperties().getValue("localDocumentfileName", null) != null) {
                        docFile = new File((String)((XFinishedReport)entry.getValue()).getProperties().getValue("localDocumentfileName", null));
                    }
                    if (this.showInPdf) {
                        if (docFile != null && docFile.exists()) {
                            this.show(docFile);
                            continue;
                        }
                        if (this.finishedReport != null) {
                            this.finishedReport.addDocument(((XFinishedReport)entry.getValue()).getDocument());
                            if (this.numberOfDocuments == null || this.numberOfDocuments.intValue() != this.finishedReport.getDocuments().size()) continue;
                            if (this.finishedReport.getDocuments().size() > 1) {
                                byte[] document = ReportCallback.joinPdfs((Iterable<byte[]>)this.finishedReport);
                                this.finishedReport.getDocuments().clear();
                                this.finishedReport.addDocument(document);
                            }
                            this.show((IReport)entry.getKey(), this.finishedReport);
                            continue;
                        }
                        this.show((IReport)entry.getKey(), (XFinishedReport)entry.getValue());
                        continue;
                    }
                    if (docFile != null && docFile.exists()) {
                        ReportCallback.print((IReport)entry.getKey(), docFile);
                        continue;
                    }
                    ReportCallback.print((IReport)entry.getKey(), (XFinishedReport)entry.getValue());
                }
            }
            if (hasCsv) {
                for (Map.Entry entry : csvReports.entrySet()) {
                    ReportCallback.showWithExternalViewer((IReport)entry.getKey(), (XFinishedReport)entry.getValue());
                }
            }
            Map xmlReports = container.getXmlTypeXFinishedReport();
            for (Map.Entry entry : xmlReports.entrySet()) {
                ReportCallback.showWithExternalViewer((IReport)entry.getKey(), (XFinishedReport)entry.getValue());
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in Callback response. " + this.toString(), e);
        }
    }

    private void show(IReport ireport, XFinishedReport finishedReport) {
        ReportCallback.showWithExternalViewer(ireport, finishedReport);
    }

    private void show(File f) {
        ReportCallback.showWithExternalViewer(f);
    }

    private static void showWithExternalViewer(File file) {
        Program.launch((String)file.getAbsolutePath());
        try {
            TimeUnit.MILLISECONDS.sleep(300L);
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "", e);
        }
    }

    public static void showWithExternalViewer(IReport ireport, XFinishedReport finishedReport) {
        List<File> files = ReportCallback.writeOnDisk(ireport, finishedReport);
        for (File file : files) {
            Program.launch((String)file.getAbsolutePath());
            try {
                TimeUnit.MILLISECONDS.sleep(300L);
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "", e);
            }
        }
    }

    public static void showWithExternalViewerHtml(IReport ireport, XFinishedReport finishedReport) {
        List<HtmlResource> resources = ReportCallback.getHtmlResources(ireport, finishedReport);
        for (HtmlResource resource : resources) {
            Program.launch((String)resource.getUrl());
            try {
                TimeUnit.MILLISECONDS.sleep(300L);
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "", e);
            }
        }
    }

    private static List<HtmlResource> getHtmlResources(IReport ireport, XFinishedReport finishedReport) {
        String output = finishedReport.getProperties().getOutput("pdf");
        String extension = "xml".equals(output) ? ".xml" : ".pdf";
        ArrayList<HtmlResource> files = new ArrayList<HtmlResource>();
        int i = 0;
        for (byte[] document : finishedReport) {
            String fileName = String.valueOf(ireport.getName()) + ++i + "_" + ReportCallback.getFormattedDateTimeForFileName() + extension;
            fileName = ReportCallback.formatForOSFileSystem(fileName);
            try {
                boolean recentViewer = (Boolean)Application.get().getPreferencesPluginController().getUserProp("user_settings_UseNewPDFViewer");
                HtmlPdfViewerResource htmlResource = HtmlBrowserTools.newHtmlPdfViewerResource((String)fileName, (byte[])document, (boolean)false, (boolean)recentViewer);
                files.add((HtmlResource)htmlResource);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return files;
    }

    private static List<File> writeOnDisk(IReport ireport, XFinishedReport finishedReport) {
        String subFolder;
        String extension;
        String output = finishedReport.getProperties().getOutput("pdf");
        if ("xml".equals(output)) {
            extension = ".xml";
            subFolder = "/temp/xml/";
        } else if ("csv".equals(output)) {
            extension = ".txt";
            subFolder = "/temp/csv/";
        } else {
            extension = ".pdf";
            subFolder = "/temp/pdf/";
        }
        ArrayList<File> files = new ArrayList<File>();
        int i = 0;
        for (byte[] document : finishedReport) {
            String fileName = String.valueOf(ireport.getName()) + ++i + "_" + ReportCallback.getFormattedDateTimeForFileName() + extension;
            fileName = ReportCallback.formatForOSFileSystem(fileName);
            fileName = String.valueOf(subFolder) + fileName;
            logger.info("Writing " + ireport.getName() + " " + i + " to file " + fileName);
            File file = FileUtil.saveToFileRelativeFromHome((String)fileName, (byte[])document);
            if (file != null) {
                files.add(file);
                continue;
            }
            logger.log(Level.SEVERE, "FileUtil.saveToFileRelativeFromHome returned file null", new Exception("File name = " + fileName));
        }
        return files;
    }

    private static String formatForOSFileSystem(String source) {
        source = StringUtils.convertNonAscii((String)source).replace('\'', '_').replace(' ', '_');
        return source;
    }

    private static void print(IReport ireport, XFinishedReport finishedReport) {
        String printer = ireport.getProperties().getPrinter(null);
        int nbCopies = ireport.getProperties().getNumberOfCopies(Integer.valueOf(1));
        PageFormat2 pageFormat2 = (PageFormat2)ireport.getProperties().getValue("pageFormat", null);
        PageFormat pageFormat = pageFormat2 == null ? null : pageFormat2.toPageFormat();
        String info = String.format("Printing... report %s with properties %s", ireport.getName(), ireport.getProperties());
        PrintPdfX.PRINT_MODE printMode = ReportCallback.toPrintPdfXPrintMode(ireport.getPrintMode());
        if (printer == null) {
            logger.log(Level.SEVERE, "Failed to print. There is not printer defined for " + info);
        } else {
            logger.log(Level.INFO, info);
            int printErr = 0;
            try {
                int i = 0;
                for (byte[] document : finishedReport) {
                    logger.log(Level.INFO, "Printing... document " + i);
                    PrintPdfX job = new PrintPdfX(document, printer, String.valueOf(ireport.getName()) + i, nbCopies, pageFormat);
                    job.setPrintMode(printMode);
                    job.print();
                }
            }
            catch (PrinterException e) {
                ++printErr;
                logger.log(Level.SEVERE, "Failed to print " + info, e);
            }
            catch (Exception e) {
                ++printErr;
                logger.log(Level.SEVERE, "Failed to print " + info, e);
            }
            if (printErr > 0) {
                ReportCallback.showWithExternalViewer(ireport, finishedReport);
            }
        }
    }

    private static void print(IReport ireport, File file) {
        String printer = ireport.getProperties().getPrinter(null);
        int nbCopies = ireport.getProperties().getNumberOfCopies(Integer.valueOf(1));
        PageFormat2 pageFormat2 = (PageFormat2)ireport.getProperties().getValue("pageFormat", null);
        PageFormat pageFormat = pageFormat2 == null ? null : pageFormat2.toPageFormat();
        String info = String.format("Printing... report %s with properties %s", ireport.getName(), ireport.getProperties());
        PrintPdfX.PRINT_MODE printMode = ReportCallback.toPrintPdfXPrintMode(ireport.getPrintMode());
        if (printer == null) {
            logger.log(Level.SEVERE, "Failed to print. There is not printer defined for " + info);
        } else {
            logger.log(Level.INFO, info);
            boolean printOk = false;
            try {
                int i = 0;
                logger.log(Level.INFO, "Printing... document " + i);
                PrintPdfX job = new PrintPdfX(file, printer, String.valueOf(ireport.getName()) + i, nbCopies, pageFormat);
                job.setPrintMode(printMode);
                job.print();
                printOk = true;
            }
            catch (PrinterException e) {
                logger.log(Level.SEVERE, "Failed to print " + info, e);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to print " + info, e);
            }
            if (!printOk) {
                ReportCallback.showWithExternalViewer(file);
            }
        }
    }

    private static PrintPdfX.PRINT_MODE toPrintPdfXPrintMode(PrintMode printMode) {
        if (printMode == PrintMode.ACTUAL_SIZE) {
            return PrintPdfX.PRINT_MODE.ACTUAL_SIZE;
        }
        if (printMode == PrintMode.FIT) {
            return PrintPdfX.PRINT_MODE.FIT;
        }
        return null;
    }

    public static String getFormattedDateTimeForFileName() {
        FastDateFormat format = FastDateFormat.getInstance((String)"yyyy_MM_dd_HH_mm_ss", (Locale)Locale.getDefault());
        return format.format(new Date(DateUtil.newCalendar().getTimeInMillis()));
    }

    public String toString() {
        return String.format("ReportCallback [functionName=%s, showInPdf=%s, wasUsedOnServer=%s, processMessages=%s, getDataObject()=%s, getReportContainer()=%s, getReportReturnContainer()=%s, killed()=%s]", this.getFunctionName(), this.showInPdf, this.wasUsedOnServer, this.processMessages, this.getDataObject(), this.getReportContainer(), this.getReportReturnContainer(), this.killed());
    }

    public Object getDataObject() {
        return this.dataObject;
    }

    public void setDataObject(Object dataObject) {
        this.dataObject = dataObject;
    }

    public XReportContainer getReportContainer() {
        return this.reportContainer;
    }

    public void setReportContainer(XReportContainer reportContainer) {
        this.reportContainer = reportContainer;
    }

    public XReportReturnContainer getReportReturnContainer() {
        return this.reportReturnContainer;
    }

    public static byte[] joinPdfs(Iterable<byte[]> pdfs) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Document document = new Document();
        PdfCopy pdfCopy = new PdfCopy(document, (OutputStream)outputStream);
        document.open();
        for (byte[] pdf : pdfs) {
            if (pdf == null) continue;
            PdfReader pdfReader = new PdfReader(pdf);
            int n = pdfReader.getNumberOfPages();
            int page = 0;
            while (page < n) {
                pdfCopy.addPage(pdfCopy.getImportedPage(pdfReader, page + 1));
                ++page;
            }
            pdfCopy.freeReader(pdfReader);
            pdfReader.close();
        }
        document.close();
        outputStream.flush();
        outputStream.close();
        return outputStream.toByteArray();
    }
}

