/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.popup;

import ca.infodata.ofys.ui.controls.popup.PopupFeature;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class ListPopupFeature<E>
extends PopupFeature {
    public ListPopupFeature(Control control) {
        super(control);
        this.showPopupDown = true;
    }

    @Override
    protected Shell createPopupControlOverride(Shell parent) {
        Shell shell = new Shell(this.getControl().getShell(), 2048);
        final org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List((Composite)shell, 4);
        List<E> items = this.getItems();
        for (E e : items) {
            list.add(this.getTextForItem(e));
        }
        list.setData(items);
        list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = list.getSelectionIndex();
                if (index == -1) {
                    ListPopupFeature.this.selected(null);
                } else {
                    ListPopupFeature.this.selected(((List)list.getData()).get(index));
                }
            }
        });
        list.setFocus();
        shell.setLayout((Layout)new FillLayout());
        shell.pack();
        return shell;
    }

    @Override
    protected void refreshPopup() {
        if (this.getPopup() != null && !this.getPopup().isDisposed()) {
            List<E> items = this.getItems();
            org.eclipse.swt.widgets.List list = (org.eclipse.swt.widgets.List)this.getPopup().getChildren()[0];
            list.removeAll();
            list.setData(items);
            for (E e : items) {
                list.add(this.getTextForItem(e));
            }
        }
    }

    protected abstract String getTextForItem(E var1);

    protected abstract List<E> getItems();

    protected abstract void selected(E var1);
}

