/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.plugins.searchview;

import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumnChoiceElement;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumnPreferenceLoader;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SearchColumnChoicePopup {
    private Shell popup;
    private SearchColumnChoiceElement[] elements;
    private Table table;
    private boolean isOpen;
    private FormToolkit toolkit;
    private Table baseTable;
    private String preferencesKey;

    public SearchColumnChoicePopup(Event e, SearchColumnChoiceElement[] elements, Table baseTable, String preferencesKey) {
        this.setElements(elements);
        this.baseTable = baseTable;
        this.preferencesKey = preferencesKey;
        this.toolkit = UI.createToolKit((Widget)baseTable);
        this.popup = new Shell(baseTable.getShell(), 2048);
        FormLayout layout = new FormLayout();
        layout.marginBottom = 1;
        layout.marginTop = 1;
        layout.marginLeft = 1;
        layout.marginRight = 1;
        layout.spacing = 1;
        this.popup.setLayout((Layout)layout);
        this.setOpen(false);
        Composite mainComp = new Composite((Composite)this.popup, 0);
        FormLayout layout2 = new FormLayout();
        layout.marginBottom = 1;
        layout.marginTop = 1;
        layout.marginLeft = 1;
        layout.marginRight = 1;
        layout.spacing = 5;
        mainComp.setLayout((Layout)layout2);
        this.table = new Table(mainComp, 32);
        this.table.setLayout((Layout)new FillLayout());
        this.table.setHeaderVisible(false);
        MyButton buUp = new MyButton(mainComp, "\u2191", 524288, this.toolkit);
        MyButton buDw = new MyButton(mainComp, "\u2193", 524288, this.toolkit);
        this.popup.setBackground(ResourceGetter.getColor((int)0, (int)0, (int)0));
        mainComp.setBackground(ResourceGetter.getColor((int)255, (int)255, (int)255));
        FormData data = new FormData();
        data.top = new FormAttachment(5);
        data.left = new FormAttachment(5);
        this.table.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(5);
        data.left = new FormAttachment((Control)this.table, 5);
        data.right = new FormAttachment(100, -5);
        buUp.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(buUp.getControl(), 5);
        data.left = new FormAttachment((Control)this.table, 5);
        data.right = new FormAttachment(100, -5);
        buDw.setLayoutData(data);
        buUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchColumnChoicePopup.this.showDataObject(SearchColumnChoicePopup.this.moveUp());
            }
        });
        buDw.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchColumnChoicePopup.this.showDataObject(SearchColumnChoicePopup.this.moveDown());
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchColumnChoicePopup.this.updateElementsStatus();
            }
        });
        if (UI.OS_MAC) {
            this.popup.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    SearchColumnChoicePopup.this.closePopup();
                }
            });
        }
        this.setPopupListner((Control)baseTable);
        this.showDataObject();
    }

    private void setPopupListner(final Control control) {
        final Listener popupCloseOnMouseDownListener = new Listener(){

            public void handleEvent(Event e) {
                int x = e.x;
                int y = e.y;
                if (!(control.isDisposed() || SearchColumnChoicePopup.this.popup == null || SearchColumnChoicePopup.this.popup.isDisposed() || SearchColumnChoicePopup.this.popup.getClientArea().contains(x, y))) {
                    SearchColumnChoicePopup.this.closePopup();
                }
            }
        };
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                control.getDisplay().removeFilter(3, popupCloseOnMouseDownListener);
                if (SearchColumnChoicePopup.this.popup != null) {
                    SearchColumnChoicePopup.this.popup.dispose();
                    SearchColumnChoicePopup.this.popup = null;
                }
            }
        });
        control.getDisplay().addFilter(3, popupCloseOnMouseDownListener);
    }

    private int moveUp() {
        int selectedIndex = this.table.getSelectionIndex();
        if (selectedIndex > 0 && this.table.getSelectionCount() == 1) {
            this.updateElementsStatus();
            SearchColumnChoiceElement o = this.getElements()[selectedIndex];
            this.getElements()[selectedIndex] = this.getElements()[selectedIndex - 1];
            this.getElements()[selectedIndex - 1] = o;
            --selectedIndex;
            this.savePref();
        }
        return selectedIndex;
    }

    private int moveDown() {
        int selectedIndex = this.table.getSelectionIndex();
        if (selectedIndex < this.getElements().length - 1 && this.table.getSelectionCount() == 1) {
            this.updateElementsStatus();
            SearchColumnChoiceElement o = this.getElements()[selectedIndex];
            this.getElements()[selectedIndex] = this.getElements()[selectedIndex + 1];
            this.getElements()[selectedIndex + 1] = o;
            ++selectedIndex;
            this.savePref();
        }
        return selectedIndex;
    }

    private void updateElementsStatus() {
        int i = 0;
        while (i < this.table.getItemCount()) {
            this.getElements()[i].setActive(this.table.getItem(i).getChecked());
            ++i;
        }
        this.savePref();
    }

    private void savePref() {
        String[][] prefs = new String[this.table.getItemCount()][];
        int[] order = new int[this.table.getItemCount()];
        int i = 0;
        while (i < this.table.getItemCount()) {
            order[i] = this.getElements()[i].getOriginalOrder();
            prefs[i] = new String[]{this.getElements()[i].getColumnName(), "" + this.getElements()[i].isActive(), "" + i, "" + this.getElements()[i].getWidth()};
            ++i;
        }
        this.baseTable.setColumnOrder(order);
        SearchColumnPreferenceLoader.savePref(this.preferencesKey, prefs);
    }

    private void positionPopup(Event e) {
        this.popup.setBounds(e.x, e.y, this.popup.getSize().x, this.popup.getSize().y);
    }

    private void showDataObject() {
        this.showDataObject(0);
    }

    private void showDataObject(int newIndexToSelect) {
        if (this.table != null) {
            this.table.removeAll();
            SearchColumnChoiceElement[] searchColumnChoiceElementArray = this.getElements();
            int n = searchColumnChoiceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                SearchColumnChoiceElement scce = searchColumnChoiceElementArray[n2];
                TableItem ti = new TableItem(this.table, 0);
                ti.setText(scce.getColumnName());
                ti.setChecked(scce.isActive());
                ++n2;
            }
        }
        this.table.setSelection(newIndexToSelect);
    }

    private void closePopup() {
        if (this.popup != null && !this.popup.isDisposed()) {
            this.popup.close();
            this.setOpen(false);
        }
    }

    public void open(Event e) {
        this.popup.pack();
        this.popup.setVisible(true);
        this.popup.open();
        this.setOpen(true);
        this.positionPopup(e);
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setOpen(boolean isOpen) {
        this.isOpen = isOpen;
    }

    public SearchColumnChoiceElement[] getElements() {
        return this.elements;
    }

    public void setElements(SearchColumnChoiceElement[] elements) {
        this.elements = elements;
    }
}

