/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.handlers;

import ca.infodata.ofys.ui.controls.IPrintable;
import ca.infodata.ofys.ui.controls.handlers.AbstractEditionHandler;
import ca.infodata.ofys.ui.controls.handlers.InternalHandlerUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class PrintHandler
extends AbstractEditionHandler {
    private static final Logger logger = Logger.getLogger(PrintHandler.class.getName());

    public PrintHandler() {
        this.registerEnablement();
    }

    public Object execute(ExecutionEvent event) {
        IPrintable part = this.getPrintablePart(event);
        if (part == null) {
            return null;
        }
        try {
            part.print();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error on print " + part.getClass().getName(), e);
        }
        return null;
    }

    @Override
    protected EvaluationResult evaluate(IEvaluationContext context) {
        IWorkbenchWindow window = InternalHandlerUtil.getActiveWorkbenchWindow(context);
        if (window == null) {
            return EvaluationResult.FALSE;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return EvaluationResult.FALSE;
        }
        IPrintable part = this.getPrintablePart(context);
        if (part == null) {
            return EvaluationResult.FALSE;
        }
        if (part != null && part.isPrintAllowed()) {
            return EvaluationResult.TRUE;
        }
        return EvaluationResult.FALSE;
    }
}

