/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.form.combo;

import ca.infodata.util1.ProviderAR;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MySimpleCombo<E> {
    private final Combo myCombo;
    private final ArrayList<E> myItems = new ArrayList();
    private ProviderAR<E, String> labelProvider;
    private final FormToolkit toolkit;

    public MySimpleCombo(Composite parent, int style) {
        this(parent, style, null);
    }

    public MySimpleCombo(Composite parent, int style, FormToolkit formToolkit) {
        this.myCombo = new Combo(parent, style);
        this.myCombo.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                MySimpleCombo.this.dispose();
            }
        });
        this.toolkit = formToolkit;
        if (this.toolkit != null) {
            this.toolkit.adapt((Composite)this.myCombo);
        }
        this.setVisibleItemCount(10);
    }

    public void setLabelProvider(ProviderAR<E, String> labelProvider) {
        if (this.labelProvider != labelProvider) {
            this.labelProvider = labelProvider;
            this.updateAll();
        }
    }

    private String getStringForItem(E item) {
        if (this.labelProvider != null) {
            return (String)this.labelProvider.get(item);
        }
        return String.valueOf(item);
    }

    public void removeAll() {
        this.setItems((List<E>)null);
    }

    public void setItems(E[] elements) {
        this.myItems.clear();
        if (elements != null) {
            E[] EArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                E e = EArray[n2];
                this.myItems.add(e);
                ++n2;
            }
        }
        this.updateAll();
    }

    public void setItems(List<E> col) {
        this.myItems.clear();
        if (col != null) {
            this.myItems.addAll(col);
        }
        this.updateAll();
    }

    public void updateAll() {
        this.myCombo.removeAll();
        String[] items = new String[this.myItems.size()];
        int i = 0;
        while (i < items.length) {
            items[i] = this.getStringForItem(this.myItems.get(i));
            ++i;
        }
        this.myCombo.setItems(items);
        this.myCombo.update();
    }

    public boolean contains(E e) {
        return this.myItems.contains(e);
    }

    public void forceSelect(E e) {
        this.forceSelect(e, false);
    }

    public void forceSelect(E e, boolean keepTextSelection) {
        if (!this.contains(e)) {
            this.add(e);
        }
        this.select(e, keepTextSelection);
    }

    public void selectNone() {
        this.myCombo.deselectAll();
    }

    public void add(E e) {
        this.myItems.add(e);
        this.myCombo.add(this.getStringForItem(e));
    }

    public void select(E e, boolean keepTextSelection) {
        Point selection = this.myCombo.getSelection();
        int indexOf = this.myItems.indexOf(e);
        this.myCombo.select(indexOf);
        if (keepTextSelection) {
            this.myCombo.setSelection(selection);
        }
    }

    public void select(E e) {
        this.select(e, false);
    }

    public E getSelection() {
        int selectionIndex = this.myCombo.getSelectionIndex();
        if (selectionIndex == -1) {
            return null;
        }
        return this.myItems.get(selectionIndex);
    }

    public void setEnabled(boolean enabled) {
        if (this.toolkit != null) {
            if (enabled) {
                this.myCombo.setBackground(this.toolkit.getColors().getBackground());
            } else {
                this.myCombo.setBackground(this.toolkit.getColors().getColor("DISABLED_BACKGROUND_COLOR"));
            }
        }
        this.myCombo.setEnabled(enabled);
    }

    private void dispose() {
        this.myItems.clear();
        this.labelProvider = null;
    }

    public Control getControl() {
        return this.myCombo;
    }

    public void addDisposeListener(DisposeListener listener) {
        this.myCombo.addDisposeListener(listener);
    }

    public void addControlListener(ControlListener listener) {
        this.myCombo.addControlListener(listener);
    }

    public void addDragDetectListener(DragDetectListener listener) {
        this.myCombo.addDragDetectListener(listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.myCombo.addFocusListener(listener);
    }

    public void addHelpListener(HelpListener listener) {
        this.myCombo.addHelpListener(listener);
    }

    public void addKeyListener(KeyListener listener) {
        this.myCombo.addKeyListener(listener);
    }

    public void addListener(int eventType, Listener listener) {
        this.myCombo.addListener(eventType, listener);
    }

    public void addMenuDetectListener(MenuDetectListener listener) {
        this.myCombo.addMenuDetectListener(listener);
    }

    public void addModifyListener(ModifyListener listener) {
        this.myCombo.addModifyListener(listener);
    }

    public void addMouseListener(MouseListener listener) {
        this.myCombo.addMouseListener(listener);
    }

    public void addMouseMoveListener(MouseMoveListener listener) {
        this.myCombo.addMouseMoveListener(listener);
    }

    public void addMouseTrackListener(MouseTrackListener listener) {
        this.myCombo.addMouseTrackListener(listener);
    }

    public void addMouseWheelListener(MouseWheelListener listener) {
        this.myCombo.addMouseWheelListener(listener);
    }

    public void addPaintListener(PaintListener listener) {
        this.myCombo.addPaintListener(listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.myCombo.addSelectionListener(listener);
    }

    public void addTraverseListener(TraverseListener listener) {
        this.myCombo.addTraverseListener(listener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.myCombo.addVerifyListener(listener);
    }

    public void changed(Control[] changed) {
        this.myCombo.changed(changed);
    }

    public void clearSelection() {
        this.myCombo.clearSelection();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return this.myCombo.computeSize(wHint, hHint, changed);
    }

    public Point computeSize(int wHint, int hHint) {
        return this.myCombo.computeSize(wHint, hHint);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        return this.myCombo.computeTrim(x, y, width, height);
    }

    public void copy() {
        this.myCombo.copy();
    }

    public void cut() {
        this.myCombo.cut();
    }

    public void deselect(int index) {
        this.myCombo.deselect(index);
    }

    public void deselectAll() {
        this.myCombo.deselectAll();
    }

    public boolean dragDetect(Event event) {
        return this.myCombo.dragDetect(event);
    }

    public boolean dragDetect(MouseEvent event) {
        return this.myCombo.dragDetect(event);
    }

    public boolean equals(Object obj) {
        return this.myCombo.equals(obj);
    }

    public boolean forceFocus() {
        return this.myCombo.forceFocus();
    }

    public Accessible getAccessible() {
        return this.myCombo.getAccessible();
    }

    public Color getBackground() {
        return this.myCombo.getBackground();
    }

    public Image getBackgroundImage() {
        return this.myCombo.getBackgroundImage();
    }

    public int getBackgroundMode() {
        return this.myCombo.getBackgroundMode();
    }

    public int getBorderWidth() {
        return this.myCombo.getBorderWidth();
    }

    public Rectangle getBounds() {
        return this.myCombo.getBounds();
    }

    public Control[] getChildren() {
        return this.myCombo.getChildren();
    }

    public Rectangle getClientArea() {
        return this.myCombo.getClientArea();
    }

    public Cursor getCursor() {
        return this.myCombo.getCursor();
    }

    public Display getDisplay() {
        return this.myCombo.getDisplay();
    }

    public boolean getDragDetect() {
        return this.myCombo.getDragDetect();
    }

    public boolean getEnabled() {
        return this.myCombo.getEnabled();
    }

    public Font getFont() {
        return this.myCombo.getFont();
    }

    public Color getForeground() {
        return this.myCombo.getForeground();
    }

    public ScrollBar getHorizontalBar() {
        return this.myCombo.getHorizontalBar();
    }

    public String getItem(int index) {
        return this.myCombo.getItem(index);
    }

    public int getItemHeight() {
        return this.myCombo.getItemHeight();
    }

    public String[] getItems() {
        return this.myCombo.getItems();
    }

    public Layout getLayout() {
        return this.myCombo.getLayout();
    }

    public Object getLayoutData() {
        return this.myCombo.getLayoutData();
    }

    public boolean getLayoutDeferred() {
        return this.myCombo.getLayoutDeferred();
    }

    public boolean getListVisible() {
        return this.myCombo.getListVisible();
    }

    public Listener[] getListeners(int eventType) {
        return this.myCombo.getListeners(eventType);
    }

    public Point getLocation() {
        return this.myCombo.getLocation();
    }

    public Menu getMenu() {
        return this.myCombo.getMenu();
    }

    public Monitor getMonitor() {
        return this.myCombo.getMonitor();
    }

    public int getOrientation() {
        return this.myCombo.getOrientation();
    }

    public Composite getParent() {
        return this.myCombo.getParent();
    }

    public Region getRegion() {
        return this.myCombo.getRegion();
    }

    public Point getSelectionPoint() {
        return this.myCombo.getSelection();
    }

    public int getSelectionIndex() {
        return this.myCombo.getSelectionIndex();
    }

    public Shell getShell() {
        return this.myCombo.getShell();
    }

    public Point getSize() {
        return this.myCombo.getSize();
    }

    public int getStyle() {
        return this.myCombo.getStyle();
    }

    public Control[] getTabList() {
        return this.myCombo.getTabList();
    }

    public int getTextHeight() {
        return this.myCombo.getTextHeight();
    }

    public int getTextLimit() {
        return this.myCombo.getTextLimit();
    }

    public String getToolTipText() {
        return this.myCombo.getToolTipText();
    }

    public ScrollBar getVerticalBar() {
        return this.myCombo.getVerticalBar();
    }

    public int getVisibleItemCount() {
        return this.myCombo.getVisibleItemCount();
    }

    public int hashCode() {
        return this.myCombo.hashCode();
    }

    public int indexOf(String string, int start) {
        return this.myCombo.indexOf(string, start);
    }

    public int indexOf(String string) {
        return this.myCombo.indexOf(string);
    }

    public void internal_dispose_GC(int hDC, GCData data) {
        this.myCombo.internal_dispose_GC(hDC, data);
    }

    public int internal_new_GC(GCData data) {
        return this.myCombo.internal_new_GC(data);
    }

    public boolean isDisposed() {
        return this.myCombo.isDisposed();
    }

    public boolean isEnabled() {
        return this.myCombo.isEnabled();
    }

    public boolean isFocusControl() {
        return this.myCombo.isFocusControl();
    }

    public boolean isLayoutDeferred() {
        return this.myCombo.isLayoutDeferred();
    }

    public boolean isListening(int eventType) {
        return this.myCombo.isListening(eventType);
    }

    public boolean isReparentable() {
        return this.myCombo.isReparentable();
    }

    public boolean isVisible() {
        return this.myCombo.isVisible();
    }

    public void layout() {
        this.myCombo.layout();
    }

    public void layout(boolean changed, boolean all) {
        this.myCombo.layout(changed, all);
    }

    public void layout(boolean changed) {
        this.myCombo.layout(changed);
    }

    public void layout(Control[] changed) {
        this.myCombo.layout(changed);
    }

    public void moveAbove(Control control) {
        this.myCombo.moveAbove(control);
    }

    public void moveBelow(Control control) {
        this.myCombo.moveBelow(control);
    }

    public void pack() {
        this.myCombo.pack();
    }

    public void pack(boolean changed) {
        this.myCombo.pack(changed);
    }

    public void paste() {
        this.myCombo.paste();
    }

    public boolean print(GC gc) {
        return this.myCombo.print(gc);
    }

    public void redraw() {
        this.myCombo.redraw();
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.myCombo.redraw(x, y, width, height, all);
    }

    public void removeControlListener(ControlListener listener) {
        this.myCombo.removeControlListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.myCombo.removeDisposeListener(listener);
    }

    public void removeDragDetectListener(DragDetectListener listener) {
        this.myCombo.removeDragDetectListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.myCombo.removeFocusListener(listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.myCombo.removeHelpListener(listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.myCombo.removeKeyListener(listener);
    }

    public void removeListener(int eventType, Listener listener) {
        this.myCombo.removeListener(eventType, listener);
    }

    public void removeMenuDetectListener(MenuDetectListener listener) {
        this.myCombo.removeMenuDetectListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.myCombo.removeModifyListener(listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.myCombo.removeMouseListener(listener);
    }

    public void removeMouseMoveListener(MouseMoveListener listener) {
        this.myCombo.removeMouseMoveListener(listener);
    }

    public void removeMouseTrackListener(MouseTrackListener listener) {
        this.myCombo.removeMouseTrackListener(listener);
    }

    public void removeMouseWheelListener(MouseWheelListener listener) {
        this.myCombo.removeMouseWheelListener(listener);
    }

    public void removePaintListener(PaintListener listener) {
        this.myCombo.removePaintListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.myCombo.removeSelectionListener(listener);
    }

    public void removeTraverseListener(TraverseListener listener) {
        this.myCombo.removeTraverseListener(listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.myCombo.removeVerifyListener(listener);
    }

    public void setBackground(Color color) {
        this.myCombo.setBackground(color);
    }

    public void setBackgroundImage(Image image) {
        this.myCombo.setBackgroundImage(image);
    }

    public void setBackgroundMode(int mode) {
        this.myCombo.setBackgroundMode(mode);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.myCombo.setBounds(x, y, width, height);
    }

    public void setBounds(Rectangle rect) {
        this.myCombo.setBounds(rect);
    }

    public void setCapture(boolean capture) {
        this.myCombo.setCapture(capture);
    }

    public void setCursor(Cursor cursor) {
        this.myCombo.setCursor(cursor);
    }

    public void setData(Object data) {
        this.myCombo.setData(data);
    }

    public void setData(String key, Object value) {
        this.myCombo.setData(key, value);
    }

    public void setDragDetect(boolean dragDetect) {
        this.myCombo.setDragDetect(dragDetect);
    }

    public void setFont(Font font) {
        this.myCombo.setFont(font);
    }

    public void setForeground(Color color) {
        this.myCombo.setForeground(color);
    }

    public void setLayout(Layout layout) {
        this.myCombo.setLayout(layout);
    }

    public void setLayoutData(Object layoutData) {
        this.myCombo.setLayoutData(layoutData);
    }

    public void setLayoutDeferred(boolean defer) {
        this.myCombo.setLayoutDeferred(defer);
    }

    public void setListVisible(boolean visible) {
        this.myCombo.setListVisible(visible);
    }

    public void setLocation(int x, int y) {
        this.myCombo.setLocation(x, y);
    }

    public void setLocation(Point location) {
        this.myCombo.setLocation(location);
    }

    public void setMenu(Menu menu) {
        this.myCombo.setMenu(menu);
    }

    public void setOrientation(int orientation) {
        this.myCombo.setOrientation(orientation);
    }

    public boolean setParent(Composite parent) {
        return this.myCombo.setParent(parent);
    }

    public void setRedraw(boolean redraw) {
        this.myCombo.setRedraw(redraw);
    }

    public void setRegion(Region region) {
        this.myCombo.setRegion(region);
    }

    public void setSelection(Point selection) {
        this.myCombo.setSelection(selection);
    }

    public void setSize(int width, int height) {
        this.myCombo.setSize(width, height);
    }

    public void setSize(Point size) {
        this.myCombo.setSize(size);
    }

    public void setTabList(Control[] tabList) {
        this.myCombo.setTabList(tabList);
    }

    public void setText(String string) {
        this.myCombo.setText(string);
    }

    public void setTextLimit(int limit) {
        this.myCombo.setTextLimit(limit);
    }

    public void setToolTipText(String string) {
        this.myCombo.setToolTipText(string);
    }

    public void setVisible(boolean visible) {
        this.myCombo.setVisible(visible);
    }

    public void setVisibleItemCount(int count) {
        this.myCombo.setVisibleItemCount(count);
    }

    public Point toControl(int x, int y) {
        return this.myCombo.toControl(x, y);
    }

    public Point toControl(Point point) {
        return this.myCombo.toControl(point);
    }

    public Point toDisplay(int x, int y) {
        return this.myCombo.toDisplay(x, y);
    }

    public Point toDisplay(Point point) {
        return this.myCombo.toDisplay(point);
    }

    public String toString() {
        return this.myCombo.toString();
    }

    public boolean traverse(int traversal) {
        return this.myCombo.traverse(traversal);
    }

    public void update() {
        this.myCombo.update();
    }

    public void notifyListeners(int eventType, Event event) {
        this.myCombo.notifyListeners(eventType, event);
    }

    public Object getData() {
        return this.myCombo.getData();
    }

    public Object getData(String key) {
        return this.myCombo.getData(key);
    }

    public int getItemCount() {
        return this.myCombo.getItemCount();
    }

    public String getText() {
        return this.myCombo.getText();
    }

    public boolean getVisible() {
        return this.myCombo.getVisible();
    }

    public boolean setFocus() {
        return this.myCombo.setFocus();
    }
}

