/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.form;

import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.controls.FontAwareLabel;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.MyTable;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumn;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class PaginatedTable<E>
extends Composite {
    private static final Logger logger = Logger.getLogger(Page.class.getName());
    private static final int PAGE_SIZE = 30;
    private MyTable<E> table;
    private ProgressBar loadingProgressBar;
    private Label errorLabel;
    private MyButton btnNextPage;
    private MyButton btnPrevPage;
    private MyLabel lblPage;
    private List<Integer> ids;
    private List<Page> pages = new ArrayList<Page>();
    private int pageIndex;
    private int pageSize = 30;

    public PaginatedTable(Composite parent, int style) {
        super(parent, style);
        FormToolkit toolkit = UI.createToolKit((Widget)this);
        this.loadingProgressBar = new ProgressBar((Composite)this, 65538);
        this.loadingProgressBar.setVisible(false);
        this.errorLabel = new FontAwareLabel((Composite)this, "Erreur", 0x1040040, null);
        this.errorLabel.setVisible(false);
        this.table = new MyTable(this, 68356);
        this.table.setLinesVisible(false);
        this.table.setHeaderVisible(false);
        ProviderAR tableLabelProvider = SearchColumn.toTableLabelProvider(this.createTableColumns());
        this.table.setLabelProvider(tableLabelProvider);
        toolkit.adapt((Composite)this.table.getControl());
        this.btnNextPage = new MyButton(this, ">>", 8, toolkit);
        this.btnNextPage.setEnabled(false);
        this.btnPrevPage = new MyButton(this, "<<", 8, toolkit);
        this.btnPrevPage.setEnabled(false);
        this.lblPage = new MyLabel(this, "", 0x1000000, toolkit);
        this.lblPage.setFont(3, 0);
        toolkit.adapt((Composite)this);
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        this.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment((Control)this.btnNextPage);
        this.table.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.table.getControl(), 0, 0x1000000);
        data.left = new FormAttachment(20);
        data.right = new FormAttachment(80);
        this.loadingProgressBar.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(10);
        data.left = new FormAttachment(10);
        data.right = new FormAttachment(90);
        data.bottom = new FormAttachment((Control)this.btnNextPage);
        this.errorLabel.setLayoutData((Object)data);
        data = new FormData();
        data.bottom = new FormAttachment(100);
        data.right = new FormAttachment(100);
        data.width = 50;
        this.btnNextPage.setLayoutData(data);
        data = new FormData();
        data.bottom = new FormAttachment(100);
        data.left = new FormAttachment(0);
        data.width = 50;
        this.btnPrevPage.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.btnNextPage.getControl(), 0, 0x1000000);
        data.left = new FormAttachment(this.btnPrevPage.getControl());
        data.right = new FormAttachment(this.btnNextPage.getControl());
        this.lblPage.setLayoutData(data);
        this.btnNextPage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaginatedTable.this.next();
            }
        });
        this.btnPrevPage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaginatedTable.this.previous();
            }
        });
    }

    protected List<SearchColumn<E>> createTableColumns() {
        ArrayList<SearchColumn<3>> list = new ArrayList<SearchColumn<3>>();
        SearchColumn e = new SearchColumn<E>(this.table, ""){

            @Override
            public String getText(E e) {
                return String.valueOf(e);
            }
        };
        list.add(e);
        return list;
    }

    protected void previous() {
        if (this.pageIndex > 0) {
            this.pageIndex = Math.max(this.pageIndex - 1, 0);
            this.loadPage(this.pages.get(this.pageIndex));
        }
        this.updateNavigationControls();
    }

    protected void next() {
        if (this.pageIndex < this.pages.size() - 1) {
            this.pageIndex = Math.min(this.pageIndex + 1, this.pages.size() - 1);
            this.loadPage(this.pages.get(this.pageIndex));
        }
        this.updateNavigationControls();
    }

    private void updateNavigationControls() {
        this.btnPrevPage.setEnabled(this.pageIndex > 0);
        this.btnNextPage.setEnabled(this.pageIndex < this.pages.size() - 1);
        if (this.ids == null || this.ids.size() == 0) {
            this.lblPage.setText("Liste vide");
        } else {
            this.lblPage.setText(String.valueOf(this.pages.get((int)this.pageIndex).start) + " \u00e0 " + this.pages.get((int)this.pageIndex).end + " sur " + this.ids.size());
        }
    }

    private void loadPage(Page page) {
        List<Integer> list = this.ids.subList(page.start, page.end);
        this.loadingProgressBar.setVisible(true);
        this.errorLabel.setVisible(false);
        Callback callback = new Callback(){

            public void responseReceived(final ReturnObject response) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PaginatedTable.this.loadingProgressBar.setVisible(false);
                        PaginatedTable.this.table.setEnabled(true);
                        PaginatedTable.this.fill((List)response.getObj());
                    }
                });
            }

            public void exception(final Exception e) {
                super.exception(e);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PaginatedTable.this.loadingProgressBar.setVisible(false);
                        PaginatedTable.this.errorLabel.setText(StringUtils.isBlank((CharSequence)e.getMessage()) ? e.getClass().getName() : e.getMessage());
                        PaginatedTable.this.errorLabel.setVisible(true);
                    }
                });
            }
        };
        callback.showMessage = false;
        try {
            this.loadPage((ICallback)callback, list);
        }
        catch (CannotConnectToServerException cannotConnectToServerException) {
            this.loadingProgressBar.setVisible(false);
            this.errorLabel.setText(MessageUtil.CANNOT_CONNECT_TO_SERVER_MESSAGE);
            this.errorLabel.setVisible(true);
            callback.kill();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to get object from ids " + page, e);
            callback.kill();
            this.loadingProgressBar.setVisible(false);
            this.errorLabel.setText(StringUtils.isBlank((CharSequence)e.getMessage()) ? e.getClass().getName() : e.getMessage());
            this.errorLabel.setVisible(true);
        }
    }

    protected abstract void loadPage(ICallback var1, List<Integer> var2) throws CannotConnectToServerException;

    protected void fill(List<E> list) {
        this.table.setItems(list);
        UI.autoAdjustColumnWidthToContent((Table)this.table.getControl());
    }

    public boolean setFocus() {
        return this.table.setFocus();
    }

    public List<Integer> getIds() {
        return this.ids;
    }

    public void clear() {
        List<Integer> emptyList = Collections.emptyList();
        this.setIds(emptyList);
    }

    public void setIds(List<Integer> list) {
        this.ids = list;
        this.table.removeAll();
        this.pages.clear();
        int total = list.size();
        int pageCount = total / this.pageSize;
        if (total % this.pageSize != 0) {
            ++pageCount;
        }
        int start = 0;
        int i = 0;
        while (i < pageCount) {
            Page page = new Page(start, Math.min(start + this.pageSize, total));
            this.pages.add(page);
            start += this.pageSize;
            ++i;
        }
        this.pageIndex = 0;
        this.updateNavigationControls();
        if (this.pages.size() > 0) {
            this.loadPage(this.pages.get(this.pageIndex));
        }
    }

    public MyTable<E> getTable() {
        return this.table;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        if (pageSize < 1) {
            throw new IllegalArgumentException(String.valueOf(pageSize));
        }
        this.pageSize = pageSize;
    }

    private static class Page {
        final int start;
        final int end;

        public Page(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

