/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.calendar.grid;

import ca.infodata.ofys.ui.controls.calendar.grid.NullCell;
import ca.infodata.ofys.ui.controls.grid.CellRenderer;
import ca.infodata.ofys.ui.controls.grid.Grid;
import ca.infodata.ofys.ui.controls.grid.GridData;
import ca.infodata.ofys.ui.library.ResourceGetter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class NullCellRenderer
implements CellRenderer<NullCell, GridData<?>> {
    private Color colorBackground;
    private Color colorBorder;
    private Font normal = ResourceGetter.getFontNormal();

    @Override
    public void render(NullCell cell, Grid<?, ?> grid, GridData<?> gridData, Rectangle rect, GC gc, boolean selected) {
        if (this.getColorBackground() == null || this.getColorBorder() == null) {
            throw new IllegalStateException("color is null");
        }
        gc.setBackground(this.getColorBackground());
        gc.setForeground(this.getColorBorder());
        gc.setLineWidth(1);
        gc.setFont(this.normal);
        gc.fillRectangle(rect);
        gc.drawRectangle(rect);
    }

    public Color getColorBackground() {
        return this.colorBackground;
    }

    public Color getColorBorder() {
        return this.colorBorder;
    }

    public void setColorBackground(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color cant be null");
        }
        this.colorBackground = color;
    }

    public void setColorBorder(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color cant be null");
        }
        this.colorBorder = color;
    }

    @Override
    public void dispose() {
        if (this.colorBorder != null) {
            ResourceGetter.dispose((Object)this.colorBorder);
        }
        if (this.colorBackground != null) {
            ResourceGetter.dispose((Object)this.colorBackground);
        }
    }
}

