/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.calendar.grid;

import ca.infodata.ofys.ui.controls.calendar.grid.CalendarCell;
import ca.infodata.ofys.ui.controls.grid.Cell;
import ca.infodata.ofys.ui.controls.grid.CellRenderer;
import ca.infodata.ofys.ui.controls.grid.Grid;
import ca.infodata.ofys.ui.controls.grid.GridData;
import ca.infodata.ofys.ui.controls.grid.NormalCellRenderer;
import ca.infodata.ofys.ui.library.IRefreshFont;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.util1.date.LocalDate;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class CalendarCellRenderer
implements CellRenderer<CalendarCell, GridData<?>>,
IRefreshFont {
    private int fontSizeIncrement = 0;
    private int fontStyle = 0;
    private String fontPolicyName;
    private Font font;
    private Color colorText;
    private final Color white;
    private final NormalCellRenderer<Cell> normal;
    Map<Point, Integer> mapFontSize = new HashMap<Point, Integer>();

    public CalendarCellRenderer() {
        Color colorSelection = ResourceGetter.getColor((int)100, (int)100, (int)255);
        Color colorBackground = ResourceGetter.getColor((int)255, (int)255, (int)255);
        Color colorBorder = ResourceGetter.getColor((int)0, (int)0, (int)0);
        this.normal = new NormalCellRenderer(colorSelection, colorBackground, colorBorder);
        this.white = ResourceGetter.getColor((int)255, (int)255, (int)255);
        ResourceGetter.addListener((IRefreshFont)this);
    }

    @Override
    public void render(CalendarCell cell, Grid<?, ?> grid, GridData<?> data, Rectangle rect, GC gc, boolean selected) {
        if (this.getColorText() == null) {
            throw new IllegalStateException("color is null");
        }
        this.normal.render(cell, grid, data, rect, gc, selected);
        LocalDate date = cell.getDate();
        if (date != null) {
            int activeFontSize;
            gc.setFont(ResourceGetter.getFontBold((int)-1));
            if (selected) {
                gc.setForeground(this.white);
            } else {
                gc.setForeground(this.getColorText());
            }
            int fontSize = activeFontSize = ResourceGetter.getFontSizeIncrement() - 1;
            if (this.mapFontSize.containsKey(new Point(fontSize, rect.width))) {
                fontSize = this.mapFontSize.get(new Point(fontSize, rect.width));
                gc.setFont(ResourceGetter.getFontBold((int)fontSize));
            } else {
                gc.setFont(ResourceGetter.getFontBold((int)fontSize));
                int maxDateHeight = Math.round((float)rect.height * 0.45f);
                int maxWidth = Math.round((float)rect.width * 0.5f);
                Point pt = gc.textExtent("88");
                while (fontSize > -10 && (pt.x - maxWidth > 0 || pt.y - maxDateHeight > 0)) {
                    gc.setFont(ResourceGetter.getFontBold((int)(--fontSize)));
                    pt = gc.textExtent("88");
                }
                this.mapFontSize.put(new Point(activeFontSize, rect.width), new Integer(fontSize));
            }
            gc.drawText(String.valueOf(date.day), rect.x + 4, rect.y + 2, true);
        }
    }

    private Font getFont() {
        if (this.font == null) {
            this.font = ResourceGetter.getFont((String)this.fontPolicyName, (int)(ResourceGetter.DEFAULT_FONT_SIZE + this.fontSizeIncrement), (int)this.fontStyle, (boolean)true);
        }
        return this.font;
    }

    public Color getColorText() {
        return this.colorText;
    }

    public Color getColorTextSelection() {
        return this.white;
    }

    public void setColorText(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color cant be null");
        }
        this.colorText = color;
    }

    public Color getColorBackground() {
        return this.normal.getColorBackground();
    }

    public Color getColorBorder() {
        return this.normal.getColorBorder();
    }

    public Color getColorSelection() {
        return this.normal.getColorSelection();
    }

    public void setColorBackground(Color colorBackground) {
        this.normal.setColorBackground(colorBackground);
    }

    public void setColorBorder(Color colorBorder) {
        this.normal.setColorBorder(colorBorder);
    }

    public void setColorSelection(Color colorSelection) {
        this.normal.setColorSelection(colorSelection);
    }

    @Override
    public void dispose() {
        ResourceGetter.removeListener((IRefreshFont)this);
        if (this.colorText != null) {
            ResourceGetter.dispose((Object)this.colorText);
        }
        if (this.white != null) {
            ResourceGetter.dispose((Object)this.white);
        }
        if (this.font != null) {
            ResourceGetter.dispose((Object)this.font);
        }
        this.normal.dispose();
    }

    public void refreshFont() {
        this.font = null;
        this.font = this.getFont();
    }

    public int getFontSizeIncrement() {
        return this.fontSizeIncrement;
    }

    public void setFontSizeIncrement(int fontSizeIncrement) {
        this.fontSizeIncrement = fontSizeIncrement;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(int fontStyle) {
        this.fontStyle = fontStyle;
    }

    public String getFontPolicyName() {
        return this.fontPolicyName;
    }

    public void setFontPolicyName(String fontPolicyName) {
        this.fontPolicyName = fontPolicyName;
    }
}

