/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public abstract class VersionedFolder {
    private static final Logger logger = Logger.getLogger(VersionedFolder.class.getName());
    private File parent;
    private String baseName;
    private String version;

    public VersionedFolder(File parent, String baseName, String version) {
        this.parent = parent;
        this.baseName = baseName;
        this.version = version;
    }

    public boolean init() {
        try {
            File folder = this.getFolder();
            if (!this.isDeployed(folder)) {
                this.fill(folder);
            }
            this.writeDoneFile();
            this.deleteOtherVersion();
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "failed to deploy or update versioned folder " + this.getFolderName(), e);
            return false;
        }
    }

    public abstract void fill(File var1) throws Exception;

    private boolean isDeployed(File folder) {
        if (!folder.exists()) {
            return false;
        }
        File file = new File(folder, "done");
        return file.exists();
    }

    private void writeDoneFile() throws IOException {
        File file = new File(this.getFolder(), "done");
        FileUtils.write((File)file, (CharSequence)"done");
    }

    public File getFolder() {
        File folder = new File(this.parent, this.getFolderName());
        return folder;
    }

    private String getFolderName() {
        return String.valueOf(this.baseName) + this.version;
    }

    private void deleteOtherVersion() {
        try {
            File[] files;
            final String noToDeleteFolderName = this.getFolderName();
            File[] fileArray = files = this.parent.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return dir.isDirectory() && name.startsWith(VersionedFolder.this.baseName) && !name.equals(noToDeleteFolderName);
                }
            });
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    FileUtils.deleteDirectory((File)file);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to delete old version folder " + file.getName(), e);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error while clean old version folders ", e);
        }
    }
}

