/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.ui.controls.MyMask;

public final class TimeMask
extends MyMask {
    private static TimeMask instance = new TimeMask();

    public static TimeMask getInstance() {
        return instance;
    }

    private TimeMask() {
        super("99:99");
    }

    @Override
    public boolean valid(CharSequence text) {
        boolean valid = super.valid(text);
        int len = text.length();
        int i = 0;
        while (valid && i < len) {
            char c = text.charAt(i);
            switch (i) {
                case 0: {
                    valid = c < '3';
                    break;
                }
                case 1: {
                    valid = text.charAt(0) == '2' && c < '4' || text.charAt(0) < '2';
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    valid = c < '6';
                    break;
                }
                case 4: {
                    break;
                }
            }
            ++i;
        }
        return valid;
    }

    public static void main(String[] args) {
        TimeMask mask = new TimeMask();
        TimeMask.assertTrue(mask.valid("23:59"));
        TimeMask.assertTrue(mask.valid("00:00"));
        TimeMask.assertTrue(mask.valid("12:23"));
        TimeMask.assertTrue(mask.valid("12:34"));
        TimeMask.assertFalse(mask.valid("24:00"));
        TimeMask.assertFalse(mask.valid("34:00"));
        TimeMask.assertFalse(mask.valid("00:61"));
        TimeMask.assertTrue(mask.valid("1"));
        TimeMask.assertFalse(mask.valid("3"));
        TimeMask.assertFalse(mask.valid("30"));
        TimeMask.assertFalse(mask.valid("12:6"));
        TimeMask.assertTrue(mask.valid("12:1"));
        TimeMask.assertFalse(mask.valid("122"));
        TimeMask.assertTrue(mask.valid("19"));
        TimeMask.assertFalse(mask.valid("56"));
    }

    private static void assertTrue(boolean value) {
        if (!value) {
            throw new RuntimeException("Assert Failed");
        }
    }

    private static void assertFalse(boolean value) {
        TimeMask.assertTrue(!value);
    }
}

