/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.ui.controls.FontAwareComposite;
import ca.infodata.ofys.ui.controls.IProgressMonitor2;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.StringUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class ProgressMonitor2Composite2
extends FontAwareComposite {
    private static final Logger logger = Logger.getLogger(IStatusHandlerImplementation.class.getName());
    private FontAwareComposite loadingComposite;
    private FontAwareComposite loadedComposite;
    private FontAwareComposite errorComposite;
    private MyLabel lblErrorMessage;
    private final IProgressMonitor2 callback;
    private final FormToolkit toolkit;

    public ProgressMonitor2Composite2(Composite parent, int style, FormToolkit toolkit) {
        super(parent, style);
        this.toolkit = toolkit;
        this.loadingComposite = this.createLoadingComposite(this, this.toolkit);
        this.loadedComposite = this.createLoadedComposite(this, this.toolkit);
        this.errorComposite = this.createErrorComposite(this, toolkit);
        FormLayout layout = new FormLayout();
        this.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.loadedComposite.setLayoutData(data);
        Point size = this.loadingComposite.computeSize(-1, -1);
        data = new FormData();
        data.top = new FormAttachment(50, -size.y / 2);
        data.left = new FormAttachment(50, -size.x / 2);
        this.loadingComposite.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.errorComposite.setLayoutData(data);
        this.callback = new IProgressMonitor2Extension();
        this.showLoadingComposite();
    }

    public void showLoadedCompositeInSwtThread() {
        if (this.isDisposed()) {
            return;
        }
        if (UI.isCurrentThreadIsUIThread()) {
            this.showLoadedComposite();
        } else {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ProgressMonitor2Composite2.this.showLoadedComposite();
                }
            });
        }
    }

    protected final void showLoadedComposite() {
        if (this.isDisposed()) {
            return;
        }
        this.updateLoadedComposite();
        this.errorComposite.setVisible(false);
        this.loadingComposite.setVisible(false);
        this.loadedComposite.setVisible(true);
    }

    protected void updateLoadedComposite() {
    }

    protected abstract FontAwareComposite createLoadedComposite(Composite var1, FormToolkit var2);

    protected void showErrorCompositeInSwtThread(final String message, final Throwable e) {
        if (this.isDisposed()) {
            return;
        }
        if (UI.isCurrentThreadIsUIThread()) {
            this.showErrorComposite(message, e);
        } else {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ProgressMonitor2Composite2.this.showErrorComposite(message, e);
                }
            });
        }
    }

    public void showErrorComposite(String message) {
        this.showErrorComposite(message, null);
    }

    public void showErrorComposite(String message, Throwable e) {
        if (this.isDisposed()) {
            return;
        }
        String message2 = StringUtils.isNotBlank((String)message) ? message : (e != null ? (StringUtils.isNotBlank((String)e.getLocalizedMessage()) ? e.getLocalizedMessage() : MessageUtil.UNEXPECTED_ERROR_MESSAGE) : MessageUtil.UNEXPECTED_ERROR_MESSAGE);
        this.updateErrorComposite(message2);
        this.loadedComposite.setVisible(false);
        this.loadingComposite.setVisible(false);
        this.errorComposite.setVisible(true);
    }

    private void updateErrorComposite(String message2) {
        this.lblErrorMessage.setText(message2);
        this.lblErrorMessage.getParent().layout(true);
    }

    private FontAwareComposite createErrorComposite(Composite parent, FormToolkit toolkit) {
        FontAwareComposite main = new FontAwareComposite(parent, 0);
        toolkit.adapt((Composite)main);
        this.lblErrorMessage = new MyLabel(main, "Error", 0x1000040, toolkit);
        this.lblErrorMessage.setFont(0, 1);
        this.lblErrorMessage.setForeground(ResourceGetter.getRedWarningColor());
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.lblErrorMessage.setLayoutData(data);
        main.setLayout((Layout)layout);
        return main;
    }

    public void showLoadingComposite() {
        this.errorComposite.setVisible(false);
        this.loadedComposite.setVisible(true);
        this.loadingComposite.setVisible(true);
    }

    private FontAwareComposite createLoadingComposite(Composite parent, FormToolkit toolkit) {
        FontAwareComposite main = new FontAwareComposite(parent, 262144);
        main.setLayout((Layout)new FillLayout());
        new ProgressBar((Composite)main, 65538);
        main.pack();
        return main;
    }

    public IProgressMonitor2 getProgressMonitor() {
        return this.callback;
    }

    final class IProgressMonitor2Extension
    implements IProgressMonitor2 {
        boolean skipResponseReceived;

        IProgressMonitor2Extension() {
        }

        public void beginTask(String name, int totalWork) {
        }

        public void done() {
            if (UI.isCurrentThreadIsUIThread()) {
                ProgressMonitor2Composite2.this.showLoadedComposite();
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ProgressMonitor2Composite2.this.showLoadedComposite();
                    }
                });
            }
        }

        public void internalWorked(double work) {
        }

        public boolean isCanceled() {
            return false;
        }

        public void setCanceled(boolean value) {
        }

        public void setTaskName(String name) {
        }

        public void subTask(String name) {
        }

        public void worked(int work) {
        }

        @Override
        public void exception(final Exception e) {
            this.skipResponseReceived = true;
            if (UI.isCurrentThreadIsUIThread()) {
                ProgressMonitor2Composite2.this.showErrorCompositeInSwtThread(e.getMessage(), e);
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ProgressMonitor2Composite2.this.showErrorCompositeInSwtThread(e.getMessage(), e);
                    }
                });
            }
        }

        @Override
        public void status(final IStatus status) {
            switch (status.getSeverity()) {
                case OK: 
                case INFO: 
                case WARNING: 
                case NEED_MORE_INFO: {
                    break;
                }
                case ERROR: {
                    this.skipResponseReceived = true;
                    if (UI.isCurrentThreadIsUIThread()) {
                        ProgressMonitor2Composite2.this.showErrorCompositeInSwtThread(status.getMessage(), null);
                    } else {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ProgressMonitor2Composite2.this.showErrorCompositeInSwtThread(status.getMessage(), null);
                            }
                        });
                    }
                    if (UI.isCurrentThreadIsUIThread()) {
                        ProgressMonitor2Composite2.this.showErrorCompositeInSwtThread(status.getMessage(), null);
                        break;
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ProgressMonitor2Composite2.this.showErrorCompositeInSwtThread(status.getMessage(), null);
                        }
                    });
                    break;
                }
                case BUG: {
                    logger.log(Level.SEVERE, status.getMessage(), status.getException());
                    this.skipResponseReceived = true;
                    if (UI.isCurrentThreadIsUIThread()) {
                        ProgressMonitor2Composite2.this.showErrorCompositeInSwtThread(status.getMessage(), status.getException());
                        break;
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ProgressMonitor2Composite2.this.showErrorCompositeInSwtThread(status.getMessage(), status.getException());
                        }
                    });
                }
            }
        }
    }

    final class IStatusHandlerImplementation
    implements IStatusHandler {
        String message;
        boolean skipResponseReceived;

        IStatusHandlerImplementation() {
        }

        public IStatusHandler.State handle(IStatus status) {
            this.message = null;
            this.skipResponseReceived = false;
            if (status == null) {
                return IStatusHandler.State.NOT_HANDLED;
            }
            switch (status.getSeverity()) {
                case OK: 
                case INFO: 
                case WARNING: 
                case NEED_MORE_INFO: {
                    break;
                }
                case ERROR: {
                    this.message = status.getMessage();
                    this.skipResponseReceived = true;
                    ProgressMonitor2Composite2.this.showErrorCompositeInSwtThread(this.message, null);
                    break;
                }
                case BUG: {
                    this.message = status.getMessage();
                    this.skipResponseReceived = true;
                    logger.log(Level.SEVERE, status.getMessage(), status.getException());
                    ProgressMonitor2Composite2.this.showErrorCompositeInSwtThread(this.message, status.getException());
                }
            }
            return IStatusHandler.State.HANDLED;
        }
    }
}

