/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.ui.controls.ControlsPlugin;
import ca.infodata.ofys.ui.controls.ICanBeRefreshed;
import ca.infodata.ofys.ui.controls.util.IDialogSettings3;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.ViewPart;

public abstract class BaseView
extends ViewPart {
    private static final Logger logger = Logger.getLogger(BaseView.class.getName());
    private Composite compMain;
    private static IWorkbenchPage page;
    protected static int correctionWidth;
    protected final IDialogSettings3 settings = ControlsPlugin.getDefault().getSettings();

    static {
        correctionWidth = Integer.MIN_VALUE;
    }

    public final void createPartControl(Composite parent) {
        this.compMain = parent;
        this.createMyPartControl(parent);
        page = this.getSite().getPage();
    }

    public abstract void createMyPartControl(Composite var1);

    public Composite getCompMain() {
        return this.compMain;
    }

    public boolean isDisposed() {
        return this.compMain.isDisposed();
    }

    public static IViewPart openView(Class<?> myClass, int mode) {
        IViewPart viewPart = null;
        String id = myClass.getName();
        try {
            IWorkbenchPage page = ControlsPlugin.getDefault().getWorkbench().getWorkbenchWindows()[0].getPages()[0];
            page.showView(id, null, mode);
            viewPart = page.findView(id);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to open view " + id, e);
        }
        return viewPart;
    }

    public static IViewPart findView(Class<?> viewClass) {
        IViewPart viewPart = null;
        String id = viewClass.getName();
        try {
            IWorkbenchPage page = ControlsPlugin.getDefault().getWorkbench().getWorkbenchWindows()[0].getPages()[0];
            viewPart = page.findView(id);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to find view " + id, e);
        }
        return viewPart;
    }

    public static IViewPart findView(String id) {
        IViewPart viewPart = null;
        try {
            IWorkbenchPage page = ControlsPlugin.getDefault().getWorkbench().getWorkbenchWindows()[0].getPages()[0];
            viewPart = page.findView(id);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to find view " + id, e);
        }
        return viewPart;
    }

    public static IViewReference findViewReference(String id) {
        IViewReference viewRef = null;
        try {
            IWorkbenchPage page = ControlsPlugin.getDefault().getWorkbench().getWorkbenchWindows()[0].getPages()[0];
            viewRef = page.findViewReference(id);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to find view " + id, e);
        }
        return viewRef;
    }

    public static IWorkbenchPage getPage() {
        return page;
    }

    public static void setPage(IWorkbenchPage p) {
        page = p;
    }

    public static void refreshViews(final Object element) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (ControlsPlugin.getDefault().getWorkbench() != null && ControlsPlugin.getDefault().getWorkbench().getWorkbenchWindows().length > 0 && ControlsPlugin.getDefault().getWorkbench().getWorkbenchWindows()[0] != null && ControlsPlugin.getDefault().getWorkbench().getWorkbenchWindows()[0].getPages().length > 0 && ControlsPlugin.getDefault().getWorkbench().getWorkbenchWindows()[0].getPages()[0] != null) {
                    IViewReference[] view = ControlsPlugin.getDefault().getWorkbench().getWorkbenchWindows()[0].getPages()[0].getViewReferences();
                    int i = 0;
                    while (i < view.length) {
                        if (view[i].getView(true) instanceof ICanBeRefreshed) {
                            ((ICanBeRefreshed)view[i].getView(true)).refresh(element);
                        }
                        ++i;
                    }
                }
            }
        });
    }
}

