/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.menu;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.AppointmentAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.ui.appointment.editor.AppointmentMainEditor;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.person.PersonMultiEditorFactory;
import ca.infodata.ofys.ui.person.patient.PatientMultiEditor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;

public class ProfessionnalAppointmentElements
implements ITreeElements {
    private static final Logger logger = Logger.getLogger(ProfessionnalAppointmentElements.class.getName());
    private ITreeElements parent;
    private IAppointment appointment;
    private EditorInput editorInput;

    public ProfessionnalAppointmentElements(ITreeElements parent, IAppointment appointment) {
        this.parent = parent;
        this.appointment = appointment;
    }

    public Object[] getChildren() {
        return null;
    }

    public Object getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return false;
    }

    public String getText() {
        return this.appointment.toString();
    }

    public String getTooltipText() {
        return this.getText();
    }

    public Image getImage() {
        return ResourceGetter.getImage((String)"images/rendez-vous.gif");
    }

    public String getEditorClass() {
        return AppointmentMainEditor.class.getName();
    }

    public IEditorInput getEditorInput() {
        this.editorInput = new EditorInput((IDataObject)this.appointment);
        return this.editorInput;
    }

    public XImageDecorator getDecorators() {
        return XImageDecorator.NULL_DECORATORS;
    }

    public IAppointment getAppointment() {
        return this.appointment;
    }

    public void showContextMenu(Control control) {
        Menu menu = new Menu(control);
        menu.setVisible(true);
        if (this.appointment != null && this.appointment.getId() != null) {
            MenuItem item = new MenuItem(menu, 64);
            item.setText(Messages.getString((String)"PTARRIVE", (String[])new String[0]));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    block4: {
                        Callback callback = new Callback((IStatusHandler)DefaultStatusHandler.getInstance());
                        try {
                            AppointmentAccessorClient.getInstance().setPatientArrived(ProfessionnalAppointmentElements.this.appointment.hashCode(), Application.get().getGlobalInstances().getSession(), ProfessionnalAppointmentElements.this.appointment.getId().intValue(), (ICallback)callback);
                        }
                        catch (CannotConnectToServerException cannotConnectToServerException) {
                            MessageUtil.cannotConnectToServerExceptionMsg();
                            if (callback != null && !callback.killed()) {
                                callback.kill();
                            }
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Failed to set patient arrived " + ProfessionnalAppointmentElements.this.appointment, e);
                            if (callback == null || callback.killed()) break block4;
                            callback.kill();
                        }
                    }
                }
            });
            item = new MenuItem(menu, 64);
            item.setText(Messages.getString((String)"PTVU", (String[])new String[0]));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    block4: {
                        Callback callback = new Callback((IStatusHandler)DefaultStatusHandler.getInstance());
                        try {
                            AppointmentAccessorClient.getInstance().setPatientSeen(ProfessionnalAppointmentElements.this.appointment.hashCode(), Application.get().getGlobalInstances().getSession(), ProfessionnalAppointmentElements.this.appointment.getId().intValue(), (ICallback)callback);
                        }
                        catch (CannotConnectToServerException cannotConnectToServerException) {
                            MessageUtil.cannotConnectToServerExceptionMsg();
                            if (callback != null && !callback.killed()) {
                                callback.kill();
                            }
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Failed to set patient seen " + ProfessionnalAppointmentElements.this.appointment, e);
                            if (callback == null || callback.killed()) break block4;
                            callback.kill();
                        }
                    }
                }
            });
            item = new MenuItem(menu, 64);
            item.setText(Messages.getString((String)"OUVRIR_FICHE_PATIENT", (String[])new String[0]));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    try {
                        if (Application.get().getGlobalInstances().getSession() != null && Application.get().getGlobalInstances().getSession().getClientPreferences() != null && Application.get().getGlobalInstances().getSession().getClientPreferences().isMultiplePatientWindows()) {
                            PersonMultiEditorFactory.openPatient((IPatient)ProfessionnalAppointmentElements.this.appointment.getPatient());
                        } else {
                            BaseEditor.openEditor((IEditorInput)new EditorInput((IDataObject)ProfessionnalAppointmentElements.this.appointment.getPatient()), (String)PatientMultiEditor.class.getName());
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to open patient " + ProfessionnalAppointmentElements.this.appointment, e);
                    }
                }
            });
        }
    }

    public int hashCode() {
        return new String(String.valueOf(this.parent.hashCode()) + " " + this.appointment.hashCode() + " " + this.getClass().getName()).hashCode();
    }

    public boolean equals(Object toCompare) {
        boolean ret = false;
        if (toCompare instanceof ProfessionnalAppointmentElements && toCompare.hashCode() == this.hashCode()) {
            ret = true;
        }
        return ret;
    }

    public void doKeyListener(Control control, KeyEvent ke) {
    }

    public int getChildrenNumberForPastille() {
        return 0;
    }
}

