/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.controller;

import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XPersonGroup;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IVisualAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateTemplate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriod;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriodType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentStatus;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentWeekTemplate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XBaseAppointmentDate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientRecall;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XReservedAppointment;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.ui.appointment.editor.controller.AppointmentControllerListener;
import ca.infodata.ofys.ui.appointment.editor.controller.Controller;
import ca.infodata.ofys.ui.appointment.editor.controller.ControllerObjectResolverImpl;
import ca.infodata.ofys.ui.appointment.editor.controller.IControllerObjectResolver;
import ca.infodata.ofys.ui.appointment.editor.controller.XObjectContainer2;
import ca.infodata.ofys.ui.appointment.editor.model2.Model;
import ca.infodata.ofys.ui.controls.IUserInteractionHelper;
import ca.infodata.util1.date.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AppointmentMainController {
    private static final Logger logger = Logger.getLogger(AppointmentMainController.class.getName());
    private final Controller controller;

    public AppointmentMainController(String id, LocalDate initialCurrentDate, Integer initialCurrentProfessional, IUserInteractionHelper helper, IControllerObjectResolver objectResolver, Model model) {
        if (id == null) {
            throw new IllegalArgumentException("id");
        }
        if (initialCurrentProfessional == null) {
            throw new NullPointerException("initialCurrentProfessional");
        }
        if (initialCurrentDate == null) {
            initialCurrentDate = LocalDate.today();
        }
        LocalDate today = initialCurrentDate;
        LocalDate start = today.withDayOfWeek(1);
        LocalDate end = today.withDayOfWeek(7);
        model.initBlock(start, end, initialCurrentProfessional);
        this.controller = new Controller(id, model, start, end, initialCurrentProfessional, helper, objectResolver);
        this.controller.setCurrentCalendarDates(initialCurrentDate);
    }

    public AppointmentMainController(String id, LocalDate initialCurrentDate, Integer initialCurrentProfessional, IUserInteractionHelper helper) {
        if (id == null) {
            throw new IllegalArgumentException("id");
        }
        if (initialCurrentProfessional == null) {
            throw new NullPointerException("initialCurrentProfessional");
        }
        if (initialCurrentDate == null) {
            initialCurrentDate = LocalDate.today();
        }
        LocalDate today = initialCurrentDate;
        LocalDate start = today.withDayOfWeek(1);
        LocalDate end = today.withDayOfWeek(7);
        Model model = Model.getInstance();
        model.initBlock(start, end, initialCurrentProfessional);
        ControllerObjectResolverImpl objectResolverImpl = new ControllerObjectResolverImpl();
        this.controller = new Controller(id, model, start, end, initialCurrentProfessional, helper, objectResolverImpl);
        this.controller.setCurrentCalendarDates(initialCurrentDate);
    }

    public AppointmentMainController(String id, IAppointment initialCurrentAppointment, IUserInteractionHelper helper) {
        if (id == null || initialCurrentAppointment == null) {
            throw new IllegalArgumentException();
        }
        LocalDate initialCurrentDate = initialCurrentAppointment.getDate();
        LocalDate start = initialCurrentDate.withDayOfWeek(1);
        LocalDate end = start.withDayOfWeek(7);
        Integer initialCurrentProfessional = initialCurrentAppointment.getIdProfessional();
        Model model = Model.getInstance();
        model.initBlock(start, end, initialCurrentProfessional);
        ControllerObjectResolverImpl objectResolverImpl = new ControllerObjectResolverImpl();
        this.controller = new Controller(id, model, start, end, initialCurrentProfessional, helper, objectResolverImpl);
        this.controller.setCurrentStartTime(initialCurrentAppointment.getStartTime().intValue());
        this.controller.setCurrentEndTime(initialCurrentAppointment.getEndTime().intValue());
        this.controller.setCurrentCalendarDates(initialCurrentDate);
        XAppointmentDate date = this.controller.getAppointmentDate(initialCurrentAppointment.getDate());
        XAppointment appointment = this.controller.getAppointment(date, initialCurrentAppointment.getStartTime().shortValue(), initialCurrentAppointment.getEndTime().shortValue());
        this.controller.setCurrentAppointment(appointment);
    }

    public void addListener(AppointmentControllerListener listener) {
        this.controller.addListener(listener);
    }

    public void assignDay(XAppointmentDateTemplate dateTemplate, LocalDate date) {
        this.controller.assignDay(dateTemplate, date);
    }

    public void assignWeek(XAppointmentWeekTemplate weekTemplate, LocalDate dateInTheWeek) {
        this.controller.assignWeek(weekTemplate, dateInTheWeek);
    }

    public void baseAppointmentDatesChanged() {
        this.controller.baseAppointmentDatesChanged();
    }

    public void copyDateTemplateToWeekTemplate(XAppointmentDateTemplate dateTemplate, XAppointmentWeekTemplate weekTemplate, int dayOfWeek) {
        this.controller.copyDateTemplateToWeekTemplate(dateTemplate, weekTemplate, dayOfWeek);
    }

    public XAppointmentDateTemplate createNewAppointmentDateTemplate() {
        return this.controller.createNewAppointmentDateTemplate();
    }

    public XAppointmentDateTemplate createNewAppointmentDateTemplateInWeekTemplate(int dayOfWeek, XAppointmentWeekTemplate weekTemplate) {
        return this.controller.createNewAppointmentDateTemplateInWeekTemplate(dayOfWeek, weekTemplate);
    }

    public XAppointment createNewAppointment(int length) {
        return this.controller.createNewAppointment(length);
    }

    public XAppointmentWeekTemplate createNewAppointmentWeekTemplate() {
        return this.controller.createNewAppointmentWeekTemplate();
    }

    public void deleteAppointmentDate(LocalDate date) {
        this.controller.deleteAppointmentDate(date);
    }

    public void deleteAppointmentDate(Collection<LocalDate> dates) {
        this.controller.deleteAppointmentDate(dates);
    }

    public void closeAppointmentDate(List<LocalDate> dates) {
        this.controller.closeAppointmentDate(dates);
    }

    public void deleteDateTemplate(XAppointmentDateTemplate dateTemplate, XAppointmentWeekTemplate week, int dayOfWeek) {
        this.controller.deleteDateTemplate(dateTemplate, week, dayOfWeek);
    }

    public void deleteDateTemplate(XAppointmentDateTemplate dateTemplate) {
        this.controller.deleteDateTemplate(dateTemplate);
    }

    public void deleteWeekTemplate(XAppointmentWeekTemplate weekTemplate) {
        this.controller.deleteWeekTemplate(weekTemplate);
    }

    public void dispose() {
        this.controller.dispose();
    }

    public IAppointment getAppointment(XAppointmentDate date, int startTime, int endTime) {
        return this.controller.getAppointment(date, startTime, endTime);
    }

    public XAppointmentDate getAppointmentDate(LocalDate date) {
        return this.controller.getAppointmentDate(date);
    }

    public List<XAppointmentDateTemplate> getAppointmentDateTemplateList() {
        return this.controller.getAppointmentDateTemplateList();
    }

    public List<XAppointmentWeekTemplate> getAppointmentWeekTemplateList() {
        return this.controller.getAppointmentWeekTemplateList();
    }

    public XBaseAppointmentDate getBaseAppointmentDate(LocalDate date) {
        return this.controller.getBaseAppointmentDate(date);
    }

    public boolean isAppointmentDateInCache(LocalDate date) {
        return this.controller.isAppointmentDateInCache(date);
    }

    public boolean isBaseAppointmentDateInCache(LocalDate date) {
        return this.controller.isBaseAppointmentDateInCache(date);
    }

    public IAppointment getCurrentAppointment() {
        return this.controller.getCurrentAppointment();
    }

    public XReservedAppointment getCurrentReservedAppointment() {
        return this.controller.getCurrentReservedAppointment();
    }

    public LocalDate getCurrentCalendarDate() {
        return this.controller.getCurrentCalendarDate();
    }

    public XAppointmentDate getCurrentAppointmentDate() {
        return this.getAppointmentDate(this.getCurrentCalendarDate());
    }

    public List<LocalDate> getCurrentCalendarDates() {
        return this.controller.getCurrentCalendarDates();
    }

    public XAppointmentDateTemplate getCurrentDateTemplate() {
        return this.controller.getCurrentDateTemplate();
    }

    public Integer getCurrentEndTime() {
        return this.controller.getCurrentEndTime();
    }

    public XAppointmentPeriod getCurrentPeriod() {
        return this.controller.getCurrentPeriod();
    }

    public XBaseProfessionnal getCurrentProfessional() {
        return this.controller.getCurrentProfessional();
    }

    public Integer getCurrentStartTime() {
        return this.controller.getCurrentStartTime();
    }

    public boolean isUsable() {
        return this.controller.isUsable();
    }

    public XAppointmentWeekTemplate getCurrentWeekTemplate() {
        return this.controller.getCurrentWeekTemplate();
    }

    public XAppointmentPeriodType getDEFAULT_APPOINTMENT_PERIOD_TYPE() {
        return this.controller.getDEFAULT_APPOINTMENT_PERIOD_TYPE();
    }

    public XAppointmentType getDEFAULT_APPOINTMENT_TYPE() {
        return this.controller.getDEFAULT_APPOINTMENT_TYPE();
    }

    public boolean isAppointmentWithinPeriod(XAppointment appointment, XAppointmentPeriod period) {
        return this.controller.isAppointmentWithinPeriod(appointment, period);
    }

    public boolean canPaste() {
        return this.controller.canPaste();
    }

    public void cancelCopyOrCut() {
        this.controller.cancelCopyOrCut();
    }

    public void cut(IAppointment object) {
        this.controller.cut(object);
    }

    public void copy(IAppointment object) {
        this.controller.copy(object);
    }

    public void paste(IUserInteractionHelper helper) {
        this.controller.paste(helper);
    }

    public boolean[] pasteFromRecall(XPatientRecall recall) {
        return this.controller.pasteRecall(recall);
    }

    public void moveDateTemplateWithinWeekTemplate(XAppointmentWeekTemplate weekTemplate, int fromDayOfWeek, int toDayOfWeek) {
        this.controller.moveDateTemplateWithinWeekTemplate(weekTemplate, fromDayOfWeek, toDayOfWeek);
    }

    public void removeListener(AppointmentControllerListener listener) {
        this.controller.removeListener(listener);
    }

    public IStatus extendsReservation(XObjectContainer2 reservation) {
        return this.controller.extendsReservation(reservation);
    }

    public IStatus saveAll() {
        return this.controller.saveAll();
    }

    public IStatus saveAll(boolean askQuestion, IStatusHandler statusHandler) {
        return this.controller.saveAll(askQuestion, statusHandler);
    }

    public void setCurrentAppointment(IAppointment appointment) {
        this.controller.setCurrentAppointment((XAppointment)appointment);
    }

    public void setCurrentReservedAppointment(XReservedAppointment appointment) {
        this.controller.setCurrentReservedAppointment(appointment);
    }

    public void setCurrentCalendarDates(List<LocalDate> dates) {
        this.controller.setCurrentCalendarDates(dates);
    }

    public void setCurrentCalendarDates(LocalDate dateInTheWeek) {
        this.controller.setCurrentCalendarDates(dateInTheWeek);
    }

    public void setCurrentDateTemplate(XAppointmentDateTemplate dateTemplate, boolean clone) {
        this.controller.setCurrentDateTemplate(dateTemplate, clone);
    }

    public void setCurrentEndTime(Integer time) {
        this.controller.setCurrentEndTime(time);
    }

    public void setCurrentPeriod(XAppointmentPeriod period) {
        this.controller.setCurrentPeriod(period);
    }

    public void setCurrentProfessional(Integer professional) {
        this.controller.setCurrentProfessional(professional);
    }

    public void setCurrentProfessional(XBaseProfessionnal professional) {
        this.controller.setCurrentProfessional(professional);
    }

    public void clearCurrents() {
        this.controller.clearCurrents();
    }

    public void setCurrents(XAppointmentWeekTemplate weekTemplate, XAppointmentDateTemplate dateTemplate, XAppointmentPeriod period) {
        this.controller.setCurrents(weekTemplate, dateTemplate, period);
    }

    public void setCurrentStartTime(Integer time) {
        this.controller.setCurrentStartTime(time);
    }

    public EditableDataObjectList<XAppointmentDateTemplate> getLstAppointmentDateTemplate() {
        return this.controller.getAppointmentDateTemplateList();
    }

    public Collection<XAppointmentPeriodType> getLstAppointmentPeriodType() {
        return this.controller.getLstAppointmentPeriodType();
    }

    public Collection<XAppointmentType> getLstAppointmentType() {
        return this.controller.getLstAppointmentType();
    }

    public EditableDataObjectList<XAppointmentWeekTemplate> getLstAppointmentWeekTemplate() {
        return this.controller.getAppointmentWeekTemplateList();
    }

    public Collection<XBaseProfessionnal> getLstProfessional() {
        return this.controller.getLstProfessional();
    }

    public Collection<XPersonGroup> getLstPersonGroup() {
        return this.controller.getLstPersonGroup();
    }

    public void moveAppointmentDateCursor(List<LocalDate> dates) {
        this.controller.moveAppointmentDateCursor(this.controller.getCurrentCalendarDates(), dates);
    }

    public void moveBaseAppointmentDateCursor(LocalDate start, LocalDate end) {
        this.controller.moveBaseAppointmentDateCursor(start, end);
    }

    public void deletePeriod(XAppointmentPeriod period) {
        this.controller.deletePeriod(period);
    }

    public void closePeriod(XAppointmentPeriod period) {
        this.controller.closePeriod(period);
    }

    public void setMoveBaseAppointmentDateMonth(boolean moveBaseAppointmentDateMonth) {
        this.controller.setMoveBaseAppointmentDateMonth(moveBaseAppointmentDateMonth);
    }

    public void setMoveAppointmentDateWeek(boolean moveAppointmentDateWeek) {
        this.controller.setMoveAppointmentDateWeek(moveAppointmentDateWeek);
    }

    public void deleteAppointment(IAppointment appointment) {
        this.controller.deleteAppointment((XAppointment)appointment);
    }

    public void undeleteAppointment(IAppointment appointment) {
        this.controller.undeleteAppointment((XAppointment)appointment);
    }

    Controller getController() {
        return this.controller;
    }

    protected void finalize() throws Throwable {
        logger.log(Level.FINE, this + " was finalized by gc");
        super.finalize();
    }

    public boolean isDisposed() {
        return this.controller.isDisposed();
    }

    public boolean isDirty() {
        return this.controller.isDirty();
    }

    public void setPatientStatus(IAppointment appointment, XPatientStatus status) {
        this.controller.setPatientStatus((XAppointment)appointment, status);
    }

    public void setAppointmentStatus(IAppointment appointment, XAppointmentStatus state) {
        this.controller.setAppointmentStatus((XAppointment)appointment, state);
    }

    public void addAppointmentNote(IAppointment appointment, String note) {
        this.controller.addAppointmentNote((XAppointment)appointment, note);
    }

    public void replaceAppointmentNote(IAppointment appointment, String note) {
        this.controller.replaceAppointmentNote((XAppointment)appointment, note);
    }

    public XAppointmentPeriod createNewPeriod(XAppointmentDateTemplate dateTemplate, int startTime, int endTime) {
        return this.controller.createNewPeriod(dateTemplate, startTime, endTime);
    }

    public boolean isSaving() {
        return this.controller.isSaving();
    }

    public String toString() {
        return this.controller.toString();
    }

    public IEditableDataObjectList<? extends IAppointment> getAppointments(XAppointmentDate date) {
        return this.controller.getAppointments(date);
    }

    public IEditableDataObjectList<XReservedAppointment> getReservedAppointment(XAppointmentDate date) {
        return this.controller.getReservedAppointments(date);
    }

    public void cancelAll() {
        this.controller.cancelAll();
    }

    public IVisualAppointment getAppointment(IVisualAppointment appointment) {
        if (appointment instanceof XAppointment) {
            return this.controller.getAppointment((XAppointment)appointment);
        }
        return appointment;
    }

    public XAppointmentDateTemplate getAppointmentDateTemplate(XAppointmentDateTemplate w) {
        return this.controller.getAppointmentDateTemplate(w);
    }

    public XAppointmentWeekTemplate getAppointmentWeekTemplate(XAppointmentWeekTemplate w) {
        return this.controller.getAppointmentWeekTemplate(w);
    }

    public void setEndTime(IAppointment appointment, int t) {
        this.controller.setEndTime((XAppointment)appointment, t);
    }

    public void setTimes(IAppointment appointment, int start, int end) {
        this.controller.setTimes((XAppointment)appointment, start, end);
    }

    public boolean canSeeAndModifyAppointment(IAppointment appointment) {
        return this.controller.canSeeAndModifyAppointment(appointment);
    }

    public IUserInteractionHelper getHelper() {
        return this.controller.getHelper();
    }

    public IControllerObjectResolver getObjectResolver() {
        return this.controller.getObjectResolver();
    }

    public void moveApppointmentToApppointmentDate(IAppointment a, XAppointmentDate d) {
        this.controller.moveApppointmentToApppointmentDate((XAppointment)a, d);
    }
}

