/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.control;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateDeGardeType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateMessageType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateStatistics2;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentStatus;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XBaseAppointmentDate;
import ca.infodata.ofys.ui.appointment.control.AppointmentCalendarGridData;
import ca.infodata.ofys.ui.appointment.control.IAppointmentMode;
import ca.infodata.ofys.ui.controls.calendar.grid.CalendarCell;
import ca.infodata.ofys.ui.controls.calendar.grid.CalendarCellRenderer;
import ca.infodata.ofys.ui.controls.grid.CellRenderer;
import ca.infodata.ofys.ui.controls.grid.Grid;
import ca.infodata.ofys.ui.controls.grid.GridData;
import ca.infodata.ofys.ui.controls.util.PreferencesSettings;
import ca.infodata.ofys.ui.library.IRefreshFont;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.util1.IntegerRange;
import ca.infodata.util1.Range;
import ca.infodata.util1.RangeNotation;
import ca.infodata.util1.StringUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class StatisticCellRenderer
implements CellRenderer<CalendarCell, AppointmentCalendarGridData>,
IRefreshFont {
    public static final String CALENDAR_STATS_EXCLUDED_PERIOD_TYPES = "appointment/calendar.stats.excluded.period.types";
    public static final String CALENDAR_STATS_INCLUDE_APPOINTMENT_OUTSIDE_PERIOD = "appointment/calendar.stats.include.appointment.outside.period";
    public static final String CALENDAR_STATS_INCLUDE_OVERBOOKING = "appointment/calendar.stats.include.appointment.overbooking";
    private Font fontSmallNormal;
    private final Color colorText;
    private final Color colorBackground;
    private final CalendarCellRenderer calendar;
    private final Color colorBackgroundSelection;
    private final Color colorStatistic;
    private final Color colorStatisticSelection;
    private final Color colorStatistic2;
    private final Color colorStatisticSelection2;
    private final Color red;
    private final Color pink;
    private final Color darkGreen;
    private IAppointmentMode.Mode mode;
    private static final int[] empty_int_array = new int[0];
    Map<Point, Integer> mapFontSize = new HashMap<Point, Integer>();

    public StatisticCellRenderer() {
        this.fontSmallNormal = ResourceGetter.getFontSmallNormal();
        this.mode = IAppointmentMode.Mode.APPOINTMENT;
        this.colorText = ResourceGetter.getColor((int)0, (int)0, (int)0);
        XSession session = Application.get().getGlobalInstances().getSession();
        this.colorBackground = session != null ? ResourceGetter.getColor((int[])session.getClientPreferences().getColorCalendarBackground()) : ResourceGetter.getColor((int)255, (int)255, (int)255);
        this.colorBackgroundSelection = ResourceGetter.darkenColor((RGB)this.colorBackground.getRGB());
        this.colorStatistic = session != null ? ResourceGetter.getColor((int[])session.getClientPreferences().getColorCalendarSchedule()) : ResourceGetter.getColor((int)62, (int)143, (int)229);
        this.colorStatisticSelection = ResourceGetter.darkenColor((RGB)this.colorStatistic.getRGB());
        this.colorStatistic2 = ResourceGetter.getColor((int)100, (int)255, (int)100);
        this.colorStatisticSelection2 = ResourceGetter.darkenColor((RGB)this.colorStatistic2.getRGB());
        this.red = ResourceGetter.getRedWarningColor();
        this.pink = ResourceGetter.getColor((int)255, (int)192, (int)203);
        this.darkGreen = ResourceGetter.getColor((int)0, (int)150, (int)0);
        this.calendar = new CalendarCellRenderer();
        this.calendar.setFontPolicyName(ResourceGetter.P_LOCAL_FONTD);
        this.calendar.setFontSizeIncrement(1);
        this.calendar.setFontStyle(0);
        this.calendar.setColorBorder(ResourceGetter.getColor((int)0, (int)0, (int)0));
        this.calendar.setColorText(this.colorText);
        ResourceGetter.addListener((IRefreshFont)this);
    }

    public static int[] getExcludedPeriodTypesPref() {
        int[] value = PreferencesSettings.getInstance().getIntArray(CALENDAR_STATS_EXCLUDED_PERIOD_TYPES);
        if (value == null) {
            value = empty_int_array;
        }
        return value;
    }

    public static void setExcludedPeriodTypesPref(IntArrayList periodTypeIds) {
        PreferencesSettings.getInstance().putIntArray(CALENDAR_STATS_EXCLUDED_PERIOD_TYPES, periodTypeIds.elements());
    }

    public static boolean getIncludeAppointmentOutsidePeriod() {
        return PreferencesSettings.getInstance().getBoolean(CALENDAR_STATS_INCLUDE_APPOINTMENT_OUTSIDE_PERIOD, false);
    }

    public static void setIncludeAppointmentOutsidePeriod(boolean value) {
        PreferencesSettings.getInstance().put(CALENDAR_STATS_INCLUDE_APPOINTMENT_OUTSIDE_PERIOD, value);
    }

    public static boolean getIncludeOverbooking() {
        return PreferencesSettings.getInstance().getBoolean(CALENDAR_STATS_INCLUDE_OVERBOOKING, false);
    }

    public static void setIncludeOverbooking(boolean value) {
        PreferencesSettings.getInstance().put(CALENDAR_STATS_INCLUDE_OVERBOOKING, value);
    }

    public void render(CalendarCell cell, Grid<?, ?> grid, AppointmentCalendarGridData data, Rectangle rect, GC gc, boolean selected) {
        boolean doesProfReplace;
        int maxDateHeight;
        int fontSize;
        int activeFontSize;
        XBaseAppointmentDate xdate = data.getStatistic(cell.getDate());
        XAppointmentDateStatistics2 statistics = xdate == null ? null : xdate.getStatistic();
        EnumSet typesProf = xdate == null ? null : xdate.getMessageTypes();
        EnumSet typesAll = xdate == null ? null : xdate.getMessageTypesAll();
        ArrayList typeCol = new ArrayList();
        if (typesProf != null) {
            typeCol.addAll(typesProf);
        }
        if (typesAll != null) {
            typeCol.addAll(typesAll);
        }
        EnumSet<Object> types = typeCol.isEmpty() ? EnumSet.noneOf(XAppointmentDateMessageType.class) : EnumSet.copyOf(typeCol);
        if (statistics == null || statistics.periods.isEmpty() && statistics.appointments.isEmpty()) {
            this.calendar.setColorBackground(this.colorBackground);
            this.calendar.setColorSelection(this.colorBackgroundSelection);
            this.calendar.render(cell, grid, (GridData)data, rect, gc, selected);
            this.drawStripesInBackground(rect, gc, xdate, types);
        } else {
            Point pt;
            int activeFontSize2;
            int nbAppointment;
            int[] excludedPeriodTypesPref = StatisticCellRenderer.getExcludedPeriodTypesPref();
            boolean includeOverbooking = StatisticCellRenderer.getIncludeOverbooking();
            boolean includeAppointmentOutsidePeriod = StatisticCellRenderer.getIncludeAppointmentOutsidePeriod();
            int nbSpace = statistics.computeNbSpace(excludedPeriodTypesPref);
            int nbSpaceUsed = statistics.computeNbSpaceUsed(excludedPeriodTypesPref, includeOverbooking);
            if (includeAppointmentOutsidePeriod) {
                nbSpaceUsed += statistics.computeNbAppointmentOutsidePeriods();
            }
            if ((nbAppointment = this.computeNbAppointment(statistics)) > 0 && statistics.periods.isEmpty()) {
                this.calendar.setColorBackground(this.colorStatistic2);
                this.calendar.setColorSelection(this.colorStatisticSelection2);
            } else {
                this.calendar.setColorBackground(this.colorStatistic);
                this.calendar.setColorSelection(this.colorStatisticSelection);
            }
            this.calendar.render(cell, grid, (GridData)data, rect, gc, selected);
            this.drawStripesInBackground(rect, gc, xdate, types);
            if (selected) {
                gc.setForeground(this.calendar.getColorTextSelection());
            } else {
                gc.setForeground(this.colorText);
            }
            String info = "";
            if (nbSpace <= 0) {
                info = String.valueOf(info) + (nbAppointment > 0 ? Integer.valueOf(nbAppointment) : " - ") + " / -";
            } else {
                info = String.valueOf(info) + nbSpaceUsed;
                info = String.valueOf(info) + " / ";
                info = String.valueOf(info) + (nbSpace > 0 ? Integer.valueOf(nbSpace) : " - ");
                boolean stillHaveFreeSpace = statistics.hasFreeSpaceAbsolute(excludedPeriodTypesPref);
                if (!stillHaveFreeSpace) {
                    gc.setForeground(ResourceGetter.getColor((int)225, (int)50, (int)50));
                }
            }
            int fontSize2 = activeFontSize2 = ResourceGetter.getFontSizeIncrement();
            if (this.mapFontSize.containsKey(new Point(fontSize2, rect.width))) {
                fontSize2 = this.mapFontSize.get(new Point(fontSize2, rect.width));
                gc.setFont(ResourceGetter.getFontNormal((int)fontSize2));
                pt = gc.textExtent("88 / 88");
            } else {
                gc.setFont(ResourceGetter.getFontNormal((int)fontSize2));
                int maxWidth = rect.width - 4;
                int maxSpaceHeight = Math.round((float)rect.height * 0.35f);
                pt = gc.textExtent("88 / 88");
                while (fontSize2 > -10 && (pt.x - maxWidth > 0 || pt.y - maxSpaceHeight > 0)) {
                    gc.setFont(ResourceGetter.getFontNormal((int)(--fontSize2)));
                    pt = gc.textExtent("88 / 88");
                }
                this.mapFontSize.put(new Point(activeFontSize2, rect.width), new Integer(fontSize2));
            }
            gc.drawText(info, rect.x + Math.round((float)(rect.width - pt.x) / 2.0f), rect.y + rect.height - pt.y - 1, true);
            gc.setFont(ResourceGetter.getFontNormal());
            if (statistics.appointments.size() > 0) {
                boolean toMove = false;
                boolean wantsToMoveAhead = false;
                int i = 0;
                while (!(i >= statistics.appointments.size() || toMove && wantsToMoveAhead)) {
                    XAppointmentDateStatistics2.Appointment a = (XAppointmentDateStatistics2.Appointment)statistics.appointments.get(i);
                    if (XAppointmentStatus.TO_MOVE.equals((Object)a.status)) {
                        toMove = true;
                    }
                    if (XAppointmentStatus.WANT_TO_MOVE_AHEAD.equals((Object)a.status)) {
                        wantsToMoveAhead = true;
                    }
                    ++i;
                }
                if (toMove) {
                    Color f = gc.getForeground();
                    gc.setForeground(ResourceGetter.getColor((int)237, (int)127, (int)16));
                    pt = gc.textExtent("\u25b2");
                    gc.drawText("\u25b2", rect.x + (int)((float)rect.width / 4.0f) + 1, rect.y + (int)((float)rect.height / 2.0f) - (int)((float)pt.y / 2.0f) + 1, true);
                    gc.setForeground(f);
                }
                if (wantsToMoveAhead) {
                    Color f = gc.getBackground();
                    gc.setBackground(ResourceGetter.getColor((int)237, (int)127, (int)16));
                    int ptw = gc.textExtent((String)"\u25b2").x - 6;
                    gc.fillOval(rect.x + rect.width - ptw - 4, rect.y + 4, ptw, ptw);
                    gc.setBackground(f);
                }
            }
        }
        String message = xdate == null ? null : xdate.getMessage();
        String messageAll = xdate == null ? null : xdate.getMessageAll();
        XBaseProfessionnal prof = data.getController().getCurrentProfessional();
        XBaseProfessionnal whoReplaceProf = PersonUiPlugin.getDefault().getWhoReplaceProf(prof.getId(), cell.getDate());
        if (whoReplaceProf != null) {
            types = EnumSet.of(XAppointmentDateMessageType.ABSENT_ALL_DAY);
        }
        if (StringUtils.isNotBlank((String)message)) {
            fontSize = activeFontSize = ResourceGetter.getFontSizeIncrement();
            gc.setFont(ResourceGetter.getFontBold((int)fontSize));
            Point pt = gc.textExtent("M");
            maxDateHeight = Math.round((float)rect.height * 0.3f);
            while (pt.y - maxDateHeight > 0) {
                gc.setFont(ResourceGetter.getFontBold((int)(--fontSize)));
                pt = gc.textExtent("M");
            }
            int textHeight = pt.y;
            if (selected) {
                gc.setForeground(this.calendar.getColorTextSelection());
            } else {
                gc.setForeground(this.colorText);
            }
            gc.drawText("M", rect.x + 4, rect.y + (int)((float)rect.height / 2.0f) - (int)((float)textHeight / 2.0f) + 1, true);
        }
        if (StringUtils.isNotBlank((String)messageAll)) {
            fontSize = activeFontSize = ResourceGetter.getFontSizeIncrement();
            gc.setFont(ResourceGetter.getFontItalic((int)fontSize));
            Point pt = gc.textExtent("M");
            maxDateHeight = Math.round((float)rect.height * 0.3f);
            while (pt.y - maxDateHeight > 0) {
                gc.setFont(ResourceGetter.getFontItalic((int)(--fontSize)));
                pt = gc.textExtent("M");
            }
            int textHeight = pt.y;
            if (selected) {
                gc.setForeground(this.calendar.getColorTextSelection());
            } else {
                gc.setForeground(this.colorText);
            }
            gc.drawText("M", rect.x + (int)((float)rect.width / 2.0f), rect.y + (int)((float)rect.height / 2.0f) - (int)((float)textHeight / 2.0f) + 1, true);
        }
        if (doesProfReplace = PersonUiPlugin.getDefault().doesProfReplace(prof.getId(), cell.getDate())) {
            Font font = gc.getFont();
            gc.setFont(ResourceGetter.getFontBold((int)-1));
            gc.setForeground(this.red);
            Point dateSize = gc.textExtent(String.valueOf(cell.getDate().day));
            gc.drawText("R", rect.x + 4 + dateSize.x + 5, rect.y + 3);
            gc.setFont(font);
        }
    }

    protected void drawStripesInBackground(Rectangle rect, GC gc, XBaseAppointmentDate xdate, EnumSet<XAppointmentDateMessageType> types) {
        EnumSet types1;
        int lineWidth = gc.getLineWidth();
        if (types != null && !types.isEmpty()) {
            int y2;
            int y1;
            gc.setForeground(this.red);
            gc.setLineWidth(4);
            if (types.contains(XAppointmentDateMessageType.ABSENT_ALL_DAY)) {
                y1 = rect.y + 2;
                y2 = rect.y + rect.height;
                gc.drawLine(rect.x + rect.width - 2, y1, rect.x + rect.width - 2, y2);
            } else {
                if (types.contains(XAppointmentDateMessageType.ABSENT_AM)) {
                    y1 = rect.y + 2;
                    y2 = rect.y + rect.height / 3;
                    gc.drawLine(rect.x + rect.width - 2, y1, rect.x + rect.width - 2, y2);
                }
                if (types.contains(XAppointmentDateMessageType.ABSENT_PM)) {
                    y1 = rect.y + rect.height / 3;
                    y2 = rect.y + rect.height / 3 * 2;
                    gc.drawLine(rect.x + rect.width - 2, y1, rect.x + rect.width - 2, y2);
                }
                if (types.contains(XAppointmentDateMessageType.ABSENT_EVE)) {
                    y1 = rect.y + rect.height / 3 * 2;
                    y2 = rect.y + rect.height;
                    gc.drawLine(rect.x + rect.width - 2, y1, rect.x + rect.width - 2, y2);
                }
            }
        }
        EnumSet enumSet = types1 = xdate == null ? null : xdate.getDeGardeTypes();
        if (types1 != null) {
            int y2;
            int y1;
            int lineWidth1 = gc.getLineWidth();
            gc.setForeground(this.darkGreen);
            gc.setLineWidth(4);
            if (types1.contains(XAppointmentDateDeGardeType.AM)) {
                y1 = rect.y + 2;
                y2 = rect.y + rect.height / 3;
                gc.drawLine(rect.x + rect.width - 6, y1, rect.x + rect.width - 6, y2);
            }
            if (types1.contains(XAppointmentDateDeGardeType.PM)) {
                y1 = rect.y + rect.height / 3;
                y2 = rect.y + rect.height / 3 * 2;
                gc.drawLine(rect.x + rect.width - 6, y1, rect.x + rect.width - 6, y2);
            }
            if (types1.contains(XAppointmentDateDeGardeType.SOIR)) {
                y1 = rect.y + rect.height / 3 * 2;
                y2 = rect.y + rect.height;
                gc.drawLine(rect.x + rect.width - 6, y1, rect.x + rect.width - 6, y2);
            }
            gc.setLineWidth(lineWidth1);
        }
        gc.setLineWidth(lineWidth);
    }

    private int computeNbAppointment(XAppointmentDateStatistics2 statistics) {
        if (statistics.appointments.size() == 0) {
            return 0;
        }
        if (statistics.periods.isEmpty()) {
            return statistics.appointments.size();
        }
        ArrayList<IntegerRange> pranges = new ArrayList<IntegerRange>();
        for (XAppointmentDateStatistics2.Period period : statistics.periods) {
            if (period.startTime >= period.endTime) continue;
            pranges.add(new IntegerRange(Integer.valueOf(period.startTime), Integer.valueOf(period.endTime), RangeNotation.LEFT_CLOSED));
        }
        int count = 0;
        for (XAppointmentDateStatistics2.Appointment a : statistics.appointments) {
            if (a.startTime >= a.endTime) {
                a.endTime = a.startTime + 5;
            }
            IntegerRange arange = new IntegerRange(Integer.valueOf(a.startTime), Integer.valueOf(a.endTime), RangeNotation.LEFT_CLOSED);
            boolean interect = false;
            for (IntegerRange prange : pranges) {
                if (!arange.intersect((Range)prange)) continue;
                interect = true;
                break;
            }
            if (interect) continue;
            ++count;
        }
        return count;
    }

    public void setMode(IAppointmentMode.Mode mode) {
        this.mode = mode;
    }

    public IAppointmentMode.Mode getMode() {
        return this.mode;
    }

    public void dispose() {
        ResourceGetter.removeListener((IRefreshFont)this);
        ResourceGetter.dispose((Object)this.pink);
        ResourceGetter.dispose((Object)this.red);
        ResourceGetter.dispose((Object)this.colorText);
        ResourceGetter.dispose((Object)this.colorBackground);
        ResourceGetter.dispose((Object)this.colorBackgroundSelection);
        ResourceGetter.dispose((Object)this.colorStatistic);
        ResourceGetter.dispose((Object)this.colorStatisticSelection);
        ResourceGetter.dispose((Object)this.fontSmallNormal);
        this.calendar.dispose();
    }

    public void refreshFont() {
        this.fontSmallNormal = ResourceGetter.getFont((int)-1, (int)0);
        this.calendar.refreshFont();
    }
}

