/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.control;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.AppointmentAccessorClient;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XObjectContainer;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentStatus;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentTypeStatus;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.data.middle.dataobjects.preferences.XClientPreferences;
import ca.infodata.ofys.data.middle.dataobjects.professionnal.XProfessionnalType;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.appointment.control.AppointmentTreeContentProvider;
import ca.infodata.ofys.ui.appointment.editor.controller.AppointmentMainController;
import ca.infodata.ofys.ui.controls.ControlWrapper;
import ca.infodata.ofys.ui.controls.IControl;
import ca.infodata.ofys.ui.controls.IProgressMonitorWithLog;
import ca.infodata.ofys.ui.controls.IRunnableWithProgressWithLog;
import ca.infodata.ofys.ui.controls.MyProgressMonitorDialogWithLog;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.windows.AbstractSingleInputWindows;
import ca.infodata.ofys.ui.intro.cache.CacheChecker;
import ca.infodata.ofys.ui.intro.cache.ICacheProvider;
import ca.infodata.ofys.ui.intro.cache.NotAvailableWayOfGettingCacheException;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.site.SitePlugin;
import ca.infodata.ofys.util.json.IJsonReader;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SendAppointmentsConfirmationDialog
extends AbstractSingleInputWindows {
    private static final Logger logger = Logger.getLogger(SendAppointmentsConfirmationDialog.class.getName());
    private static final String GROUP_OF_X_PTS = Messages.getString((String)"GROUP_OF_X_PTS", (String[])new String[0]);
    private CheckboxTreeViewer list;
    private MyButton chkThoseNotConfirmed;
    private MyButton chkThoseWithEmail;
    private MyButton chkThoseWithCell;
    private Shell shell;
    private boolean thoseNotConfirmed = true;
    private boolean thoseWithEmail = false;
    private boolean thoseWithCell = false;
    boolean isHubEnabled = false;
    private LocalDate date;
    private IEditableDataObjectList<? extends IAppointment> appointments;
    private ArrayList<IAppointment> listInput;
    private Set<IAppointment> checkedAppt;

    public SendAppointmentsConfirmationDialog(Shell shell, LocalDate date, AppointmentMainController controller) {
        super(shell, MessageFormat.format(Messages.getString((String)"RVDateControl.SEND_CONFIRMS_EMAIL", (String[])new String[0]), LocalDateFormat.format((LocalDate)date, (String)FormatDateProvider.getFormatDate().toString())), null);
        this.date = date;
        this.appointments = controller.getAppointments(controller.getAppointmentDate(date));
        this.checkedAppt = new HashSet<IAppointment>();
        this.listInput = new ArrayList();
        XClientPreferences clientPreferences = Application.get().getGlobalInstances().getSession().getClientPreferences();
        this.isHubEnabled = clientPreferences != null && clientPreferences.isHubEnabled();
    }

    public boolean getUseOnlyEmail() {
        return this.thoseWithEmail;
    }

    public boolean getUseOnlyCell() {
        return this.thoseWithCell;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean btnPressed(int btnId) {
        this.input = this.checkedAppt;
        if (btnId != 0) return true;
        if (this.checkedAppt.size() > 0) {
            if (!MessageDialog.openConfirm((Shell)this.shell, (String)Messages.getString((String)"QUESTION", (String[])new String[0]), (String)Messages.getString((String)"CONFIRMER_COURRIEL_RDVS", (String[])new String[0]))) return false;
            this.send();
            return true;
        } else {
            MessageUtil.infoMsg((Shell)this.shell, (String)Messages.getString((String)"RVDateControl.NO_MESSAGE_TO_SEND", (String[])new String[0]));
        }
        return true;
    }

    protected IControl createControlOverride(Composite parent, FormToolkit toolkit) {
        this.shell = parent.getShell();
        MyLabel lblInfo = new MyLabel(parent, 64);
        lblInfo.setText(Messages.getString((String)"SEND_CONFIRMS_EMAIL_INFO", (String[])new String[0]));
        this.chkThoseNotConfirmed = new MyButton(parent, Messages.getString((String)"ONLY_THOSE_NOT_CONFIRMED", (String[])new String[0]), 32, toolkit);
        this.chkThoseNotConfirmed.setSelection(true);
        this.chkThoseNotConfirmed.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SendAppointmentsConfirmationDialog.this.thoseNotConfirmed = ((Button)e.widget).getSelection();
                SendAppointmentsConfirmationDialog.this.refreshListInput();
            }
        });
        this.chkThoseWithEmail = new MyButton(parent, Messages.getString((String)"ONLY_THOSE_WITH_EMAIL", (String[])new String[0]), 32, toolkit);
        this.chkThoseWithEmail.setSelection(false);
        this.chkThoseWithEmail.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SendAppointmentsConfirmationDialog.this.thoseWithEmail = ((Button)e.widget).getSelection();
                SendAppointmentsConfirmationDialog.this.thoseWithCell = false;
                SendAppointmentsConfirmationDialog.this.chkThoseWithCell.setSelection(false);
                SendAppointmentsConfirmationDialog.this.refreshListInput();
            }
        });
        this.chkThoseWithCell = new MyButton(parent, Messages.getString((String)"ONLY_THOSE_WITH_CELL_TEXTO", (String[])new String[0]), 32, toolkit);
        this.chkThoseWithCell.setSelection(false);
        this.chkThoseWithCell.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SendAppointmentsConfirmationDialog.this.thoseWithCell = ((Button)e.widget).getSelection();
                SendAppointmentsConfirmationDialog.this.thoseWithEmail = false;
                SendAppointmentsConfirmationDialog.this.chkThoseWithEmail.setSelection(false);
                SendAppointmentsConfirmationDialog.this.refreshListInput();
            }
        });
        this.list = new CheckboxTreeViewer(parent, 2048){

            protected void handleDoubleSelect(SelectionEvent event) {
                super.handleDoubleSelect(event);
            }
        };
        this.list.setContentProvider((IContentProvider)new AppointmentTreeContentProvider());
        this.list.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IAppointment x = (IAppointment)element;
                JoinList s = new JoinList(" ");
                boolean hasEmail = false;
                boolean hasCell = false;
                List patientsOrAdhoc = x.getPatientsOrAdhoc((IJsonReader)Application.get().getGsonProcessor());
                for (IPatient patient : patientsOrAdhoc) {
                    hasEmail = hasEmail || StringUtils.isNotBlank((CharSequence)patient.getEmailPrincContact());
                    boolean bl = hasCell = hasCell || StringUtils.isNotBlank((CharSequence)patient.getCell());
                }
                if (hasEmail) {
                    s.add((CharSequence)"<E>");
                }
                if (hasCell) {
                    s.add((CharSequence)"<T>");
                }
                if (patientsOrAdhoc.size() > 1) {
                    s.add((CharSequence)MessageFormat.format(GROUP_OF_X_PTS, patientsOrAdhoc.size()));
                } else if (patientsOrAdhoc.size() == 1) {
                    s.add((CharSequence)((XPatient)patientsOrAdhoc.get(0)).getName());
                }
                s.add((CharSequence)x.getStartTimeInString());
                s.add((CharSequence)x.getDuree());
                s.add(": ", x.getStatus().toString());
                return s.toString();
            }
        });
        this.refreshListInput();
        this.list.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                IAppointment x = (IAppointment)element;
                return SendAppointmentsConfirmationDialog.this.checkedAppt.contains(x);
            }

            public boolean isGrayed(Object element) {
                return false;
            }
        });
        this.list.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                IAppointment x = (IAppointment)event.getElement();
                if (event.getChecked()) {
                    SendAppointmentsConfirmationDialog.this.checkedAppt.add(x);
                } else {
                    SendAppointmentsConfirmationDialog.this.checkedAppt.remove(x);
                }
            }
        });
        parent.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        lblInfo.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblInfo.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.chkThoseNotConfirmed.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.chkThoseNotConfirmed.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.chkThoseWithEmail.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.chkThoseWithEmail.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.chkThoseWithCell.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.chkThoseWithCell.getControl(), 5);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.height = 300;
        this.list.getTree().setLayoutData((Object)data);
        ControlWrapper control = new ControlWrapper((Control)this.list.getTree());
        return control;
    }

    protected void refreshListInput() {
        this.listInput.clear();
        if (this.appointments != null) {
            this.listInput.addAll((Collection<IAppointment>)this.appointments);
            boolean useOnlyCell = this.getUseOnlyCell();
            boolean useOnlyEmail = this.getUseOnlyEmail();
            boolean onlyNotConfirmed = this.thoseNotConfirmed;
            Iterator<IAppointment> iterator = this.listInput.iterator();
            while (iterator.hasNext()) {
                IAppointment a = iterator.next();
                boolean toRemove = false;
                if (Boolean.TRUE.equals(a.getIsDeleted()) || a.getPatientStatus() == XPatientStatus.CANCEL || a.getPatientStatus() == XPatientStatus.CANCEL_LESS_24H) {
                    toRemove = true;
                } else {
                    ICacheProvider provider = CacheChecker.getInstance().getCacheProvider(XAppointmentType.class);
                    if (provider != null) {
                        try {
                            XAppointmentType at = (XAppointmentType)provider.getById(a.getTypeAppointment());
                            if (at != null && (at.getStatus().contains(XAppointmentTypeStatus.NO_COMM) || at.getStatus().contains(XAppointmentTypeStatus.IS_TODO))) {
                                toRemove = true;
                            }
                        }
                        catch (NotAvailableWayOfGettingCacheException notAvailableWayOfGettingCacheException) {}
                    }
                }
                if (!toRemove) {
                    boolean isConfirmed;
                    boolean hasCell = false;
                    List patientsOrAdhoc = a.getPatientsOrAdhoc((IJsonReader)Application.get().getGsonProcessor());
                    for (IPatient patient : patientsOrAdhoc) {
                        boolean bl = hasCell = hasCell || StringUtils.isNotBlank((CharSequence)patient.getCell());
                    }
                    boolean hasEmail = false;
                    for (IPatient patient : patientsOrAdhoc) {
                        boolean bl = hasEmail = hasEmail || StringUtils.isNotBlank((CharSequence)patient.getEmailPrincContact());
                    }
                    if (!hasCell && !hasEmail) {
                        toRemove = true;
                    }
                    if (!toRemove && useOnlyCell) {
                        boolean bl = toRemove = !hasCell;
                    }
                    if (!toRemove && useOnlyEmail) {
                        boolean bl = toRemove = !hasEmail;
                    }
                    if (!toRemove && onlyNotConfirmed && (isConfirmed = a.getStatus().isOneOf(new XAppointmentStatus[]{XAppointmentStatus.CONFIRMED, XAppointmentStatus.CONFIRMATION_TEXTO_ENVOI, XAppointmentStatus.CONFIRMATION_TEXTO_RECUE, XAppointmentStatus.CONFIRMATION_MAIL_ENVOI, XAppointmentStatus.CONFIRMATION_MAIL_RECUE}))) {
                        toRemove = true;
                    }
                }
                if (!toRemove) {
                    boolean canSendConfirm = true;
                    if (this.isHubEnabled) {
                        XBaseProfessionnal prof = PersonUiPlugin.getDefault().getBaseProfessionnal(a.getIdProfessional());
                        XProfessionnalType professionnalType = prof.getProfessionalType() == null ? XProfessionnalType.AUTRES : prof.getProfessionalType();
                        boolean bl = canSendConfirm = !professionnalType.equals((Object)XProfessionnalType.MD_OMNIPRATICIEN) && !professionnalType.equals((Object)XProfessionnalType.RESIDENT) && !professionnalType.equals((Object)XProfessionnalType.EXTERNE) && !professionnalType.equals((Object)XProfessionnalType.INFIRMIERE_PRATICIENNE) && !professionnalType.equals((Object)XProfessionnalType.INFIRMIERE);
                    }
                    if (!canSendConfirm) {
                        toRemove = true;
                    }
                }
                if (!toRemove) continue;
                iterator.remove();
            }
        }
        this.checkedAppt.clear();
        Collections.sort(this.listInput, new Comparator<IAppointment>(){

            @Override
            public int compare(IAppointment o1, IAppointment o2) {
                return o1.getStartTime().compareTo(o2.getStartTime());
            }
        });
        this.checkedAppt.addAll(this.listInput);
        this.list.setInput(this.listInput);
    }

    private void send() {
        final ArrayList<IAppointment> items = new ArrayList<IAppointment>(this.checkedAppt);
        if (items.size() > 0) {
            Collections.sort(items, new Comparator<IAppointment>(){

                @Override
                public int compare(IAppointment o1, IAppointment o2) {
                    return o1.getStartTime().compareTo(o2.getStartTime());
                }
            });
            final StatusException[] statusException = new StatusException[1];
            MyProgressMonitorDialogWithLog dialog = new MyProgressMonitorDialogWithLog(UI.getWorkbenchShell());
            try {
                dialog.runWithLog(true, false, new IRunnableWithProgressWithLog(){

                    public void run(IProgressMonitorWithLog monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(MessageFormat.format(Messages.getString((String)"RVDateControl.SEND_CONFIRMS_EMAIL", (String[])new String[0]), String.valueOf(Messages.getString((String)"DATE", (String[])new String[0]).toLowerCase()) + " " + LocalDateFormat.format((LocalDate)SendAppointmentsConfirmationDialog.this.date, (String)FormatDateProvider.getFormatDate().toString())), items.size());
                        try {
                            ComStrategy comStrategy = SendAppointmentsConfirmationDialog.this.getComStrategy();
                            for (IAppointment appointment : items) {
                                ArrayList<ComContact> contacts = new ArrayList<ComContact>();
                                contacts.addAll(SendAppointmentsConfirmationDialog.buildContacts(appointment, comStrategy));
                                HashMap<String, Map<String, Serializable>> mapMails = SendAppointmentsConfirmationDialog.buildMapMails(contacts);
                                if (contacts.size() > 0) {
                                    monitor.subTask(DateUtil.mtos((Integer)appointment.getStartTime().intValue(), (Character)Character.valueOf('h')));
                                    monitor.tab();
                                    try {
                                        XObjectContainer data;
                                        ReturnObject response = AppointmentAccessorClient.getInstance().sendEmails(Application.get().getGlobalInstances().getSession(), appointment.getId().intValue(), mapMails);
                                        monitor.status((IStatus)response.getStatus());
                                        if (response.getStatus().isOkToProceed() && (data = (XObjectContainer)response.getObj()) != null) {
                                            for (IMinimalEditableDataObject e : data.getObjects()) {
                                                Application.get().getGlobalInstances().getNotificationSystem().sendDataObjectUpdatedNotification((IDataObject)e);
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        logger.log(Level.SEVERE, "failed to send email... ", e);
                                        monitor.log(Level.SEVERE, "Erreur... ", (Throwable)e);
                                    }
                                    monitor.untab();
                                    Thread.sleep(210L);
                                }
                                monitor.worked(1);
                            }
                            monitor.done();
                        }
                        catch (StatusException e) {
                            statusException[0] = e;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            catch (Exception e1) {
                logger.log(Level.WARNING, "Error", e1);
                MessageUtil.show((Shell)this.shell, (Exception)e1);
            }
            if (statusException[0] != null) {
                MessageUtil.show((Shell)this.shell, (IStatus)statusException[0].getStatus());
            }
        }
    }

    protected ComStrategy getComStrategy() {
        ComStrategy strategy = ComStrategy.USE_EMAIL_FIRST;
        if (this.getUseOnlyCell()) {
            strategy = ComStrategy.USE_ONLY_CELL;
        } else if (this.getUseOnlyEmail()) {
            strategy = ComStrategy.USE_ONLY_EMAIL;
        }
        return strategy;
    }

    public static HashMap<String, Map<String, Serializable>> toMapMails(List<IAppointment> appointments, ComStrategy comStrategy) {
        if (comStrategy == null) {
            throw new NullPointerException("comStrategy");
        }
        ArrayList<ComContact> contacts = new ArrayList<ComContact>();
        for (IAppointment appointment : appointments) {
            contacts.addAll(SendAppointmentsConfirmationDialog.buildContacts(appointment, comStrategy));
        }
        HashMap<String, Map<String, Serializable>> mapMails = SendAppointmentsConfirmationDialog.buildMapMails(contacts);
        return mapMails;
    }

    protected static HashMap<String, Map<String, Serializable>> buildMapMails(List<ComContact> contacts) {
        HashMap<String, Map<String, Serializable>> map = new HashMap<String, Map<String, Serializable>>(contacts.size());
        for (ComContact c : contacts) {
            String key = String.valueOf(c.contact) + "~" + WordUtils.capitalizeFully((String)(String.valueOf(c.patient.getFirstName()) + " " + c.patient.getLastName())) + "~" + c.patient.getId();
            HashMap<String, Object> value = new HashMap<String, Object>();
            value.put("id", c.appointment.id);
            value.put("date", c.appointment.date);
            value.put("start", c.appointment.start);
            value.put("duree", c.appointment.duree);
            value.put("site", c.appointment.siteName);
            value.put("prof", c.appointment.profNames);
            map.put(key, value);
        }
        return map;
    }

    static List<ComContact> buildContacts(IAppointment appointment, ComStrategy comStrategy) {
        if (appointment == null) {
            throw new NullPointerException("appointment");
        }
        comStrategy = comStrategy == null ? ComStrategy.USE_EMAIL_FIRST : comStrategy;
        ComAppointment comAppointment = new ComAppointment(appointment);
        ArrayList<ComContact> comContacts = new ArrayList<ComContact>();
        HashSet<Integer> setIdPt = new HashSet<Integer>();
        for (IPatient xp : appointment.getPatientsOrAdhoc((IJsonReader)Application.get().getGsonProcessor())) {
            if (setIdPt.contains(xp.getId())) continue;
            switch (comStrategy) {
                case USE_ONLY_CELL: {
                    if (!StringUtils.isNotEmpty((CharSequence)xp.getCell())) break;
                    comContacts.add(new ComContact(xp, xp.getCell(), comAppointment));
                    setIdPt.add(xp.getId());
                    break;
                }
                case USE_ONLY_EMAIL: {
                    if (!StringUtils.isNotEmpty((CharSequence)xp.getEmailPrincContact())) break;
                    comContacts.add(new ComContact(xp, xp.getEmailPrincContact(), comAppointment));
                    setIdPt.add(xp.getId());
                    break;
                }
                case USE_EMAIL_FIRST: {
                    if (StringUtils.isNotEmpty((CharSequence)xp.getEmailPrincContact())) {
                        comContacts.add(new ComContact(xp, xp.getEmailPrincContact(), comAppointment));
                        setIdPt.add(xp.getId());
                        break;
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)xp.getCell())) break;
                    comContacts.add(new ComContact(xp, xp.getCell(), comAppointment));
                    setIdPt.add(xp.getId());
                }
            }
        }
        return comContacts;
    }

    static class ComAppointment {
        int id;
        String date;
        int start;
        String duree;
        String siteName;
        String profNames;

        ComAppointment(IAppointment appointment) {
            this.id = appointment.getId();
            this.date = appointment.getDate().formatSlash();
            this.start = appointment.getStartTime().shortValue();
            this.duree = appointment.getDuree();
            String siteName2 = "";
            XSite site = SitePlugin.getDefault().getSite(appointment.getSite());
            if (site != null && site.getNameCommon() != null) {
                siteName2 = site.getNameCommon().trim();
                siteName2 = "Site 1".equals(siteName2) ? "" : (siteName2.length() < 16 ? siteName2 : String.valueOf(siteName2.substring(0, 14)) + ".");
            }
            this.siteName = siteName2;
            JoinList list = new JoinList("; ");
            for (Integer idProf : appointment.getIdProfessionals()) {
                XBaseProfessionnal prof = PersonUiPlugin.getDefault().getBaseProfessionnal(idProf);
                String name = WordUtils.capitalizeFully((String)(String.valueOf(prof.getFirstName()) + " " + prof.getLastName()), (char[])new char[]{' ', '-', '\'', '.'});
                list.add((CharSequence)name);
            }
            this.profNames = list.toString();
        }
    }

    static class ComContact {
        IPatient patient;
        String contact;
        ComAppointment appointment;

        ComContact(IPatient patient, String contact, ComAppointment appointment) {
            this.patient = patient;
            this.appointment = appointment;
            this.contact = contact;
        }
    }

    public static enum ComStrategy {
        USE_ONLY_CELL,
        USE_ONLY_EMAIL,
        USE_EMAIL_FIRST;

    }
}

