/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.util.math;

import ca.infodata.ofys.util.math.DirectSearchFactorization;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public final class NumberUtils {
    private static final Logger logger = Logger.getLogger(NumberUtils.class.getName());

    private NumberUtils() {
        throw new UnsupportedOperationException();
    }

    public static Integer failsafeParseInt(String s) {
        if (!StringUtils.isBlank((CharSequence)s) && StringUtils.isNumeric((CharSequence)s)) {
            try {
                return Integer.parseInt(s);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "BUG : Failed to convert " + s + " to Integer. operation should have been sucessful", e);
            }
        }
        return null;
    }

    public static int getGreatestCommonFactor(int[] n) {
        int greatestCommonFactor = 1;
        DirectSearchFactorization dsf = new DirectSearchFactorization(NumberUtils.max(n));
        ObjectRBTreeSet primes = new ObjectRBTreeSet();
        for (int i : n) {
            primes.add((Object)dsf.getPrimeFactorsInt(i));
        }
        IntArrayList allPrimeNumbers = NumberUtils.getAllPrimeNumbers((ObjectRBTreeSet<IntArrayList>)primes);
        IntListIterator intListIterator = allPrimeNumbers.iterator();
        while (intListIterator.hasNext()) {
            int i = (Integer)intListIterator.next();
            greatestCommonFactor *= i;
        }
        return greatestCommonFactor;
    }

    private static IntArrayList getAllPrimeNumbers(ObjectRBTreeSet<IntArrayList> primes) {
        IntArrayList allPrimeNumbers = new IntArrayList();
        IntArrayList numbersToReturn = new IntArrayList();
        ObjectRBTreeSet primesTemp = new ObjectRBTreeSet();
        primesTemp.addAll(primes);
        allPrimeNumbers.addAll((IntList)primes.first());
        numbersToReturn.addAll((IntList)primes.first());
        primesTemp.remove(primes.first());
        IntListIterator intListIterator = allPrimeNumbers.iterator();
        while (intListIterator.hasNext()) {
            int i = (Integer)intListIterator.next();
            boolean removeObj = false;
            for (IntArrayList set : primesTemp) {
                if (!set.contains(i)) {
                    removeObj = true;
                    continue;
                }
                set.rem(i);
            }
            if (!removeObj) continue;
            numbersToReturn.rem(i);
        }
        return numbersToReturn;
    }

    public static SortedSet<Integer> getPrimes(int upTo) {
        int i;
        int size = upTo + 1;
        boolean[] flags = new boolean[size];
        TreeSet<Integer> primes = new TreeSet<Integer>();
        double limit = Math.sqrt(size);
        for (int i2 = 2; i2 < size; ++i2) {
            flags[i2] = true;
        }
        int j = 2;
        for (i = j + j; i < size; i += j) {
            flags[i] = false;
        }
        j = 3;
        while ((double)j <= limit) {
            if (flags[j]) {
                for (i = j + j; i < size; i += j) {
                    flags[i] = false;
                }
            }
            j += 2;
        }
        for (i = 2; i < size; ++i) {
            if (!flags[i]) continue;
            primes.add(new Integer(i));
        }
        return primes;
    }

    public static int min(int[] i) {
        return org.apache.commons.lang3.math.NumberUtils.min((int[])i);
    }

    public static int max(int[] i) {
        return org.apache.commons.lang3.math.NumberUtils.max((int[])i);
    }

    public static boolean isNumber(String s) {
        return org.apache.commons.lang3.math.NumberUtils.isCreatable((String)s);
    }

    public static String doubleToStringDec(Double d, int nbDec) {
        if (d != null) {
            return NumberUtils.doubleToStringDec(String.valueOf(d), nbDec);
        }
        return "0." + StringUtils.repeat((String)"0000", (int)nbDec);
    }

    public static float Round(Number nVal, int Rpl) {
        if (nVal != null) {
            double p = Math.pow(10.0, Rpl);
            double val = nVal.doubleValue() * p;
            double tmp = Math.round(val);
            return (float)(tmp / p);
        }
        return 0.0f;
    }

    public static String doubleToStringDec(double d, int nbDec) {
        return new BigDecimal(d).setScale(nbDec, 4).toString();
    }

    public static String doubleToStringDec(String d, int nbDec) {
        return new BigDecimal(d).setScale(nbDec, 4).toString();
    }

    public static String doubleToString2Dec(Double d) {
        if (d != null) {
            return NumberUtils.doubleToStringDec(d, 2);
        }
        return "0.00";
    }

    public static String doubleToString2Dec(String s) {
        if (s != null && s.trim().length() > 0) {
            return NumberUtils.doubleToStringDec(s, 2);
        }
        return "0.00";
    }

    public static String stringFormatNumber(String s, int dec) {
        if (s != null && s.trim().length() > 0 && NumberUtils.isNumber(s)) {
            return new BigDecimal(s).setScale(dec, 4).toString();
        }
        return "0.00";
    }

    public static String doubleToString2Dec(String s, int len) {
        s = NumberUtils.doubleToString2Dec(s);
        while (s.length() < len) {
            s = "0" + s;
        }
        return s;
    }

    public static String doubleToString2Dec(double d, int len) {
        String s = NumberUtils.doubleToString2Dec(new Double(d));
        while (s.length() < len) {
            s = "0" + s;
        }
        return s;
    }

    public static int max(List<Integer> array) {
        int m = -999999999;
        if (array != null && array.size() > 0) {
            for (Integer i : array) {
                if (i <= m) continue;
                m = i;
            }
        }
        return m;
    }

    public static int min(List<Integer> array) {
        int m = 999999999;
        if (array != null && array.size() > 0) {
            for (Integer i : array) {
                if (i >= m) continue;
                m = i;
            }
        }
        return m;
    }

    public static Double fractionToDouble(String fraction) {
        Double d = null;
        if (fraction != null) {
            if ((fraction = StringUtils.remove((String)fraction, (char)' ')).contains("/")) {
                String[] numbers = fraction.split("/");
                if (numbers.length == 2) {
                    BigDecimal d1 = BigDecimal.valueOf(Double.valueOf(numbers[0]));
                    BigDecimal d2 = BigDecimal.valueOf(Double.valueOf(numbers[1]));
                    BigDecimal response = d1.divide(d2, MathContext.DECIMAL128);
                    d = new Double(response.doubleValue());
                }
            } else {
                d = Double.valueOf(fraction);
            }
        }
        if (d == null) {
            d = new Double(0.0);
        }
        return d;
    }

    public static int toIntExact(long value) {
        if ((long)((int)value) != value) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)value;
    }
}

