/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.util;

import ca.infodata.ofys.data.middle.dataobjects.IImportance;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ICloneable;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.OrderedDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.OrderedDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.util.EnumWithValue;
import ca.infodata.util1.ClosureAR;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import ca.infodata.util1.date.PartialDate;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MiscUtil {
    private static final Logger logger = Logger.getLogger(MiscUtil.class.getName());
    public static final char[] alphaChars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    public static final char[] alphanumericChars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
    public static final char[] numericChars = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
    private static final char[] passwordChars;
    private static final ThreadLocal<Long> time1;
    private static final ThreadLocal<Long> time2;

    private MiscUtil() {
        throw new UnsupportedOperationException();
    }

    public static byte fromBoolean(Boolean a) {
        if (a == null) {
            return -128;
        }
        return a != false ? (byte)1 : 0;
    }

    public static Boolean toBoolean(byte a) {
        if (a == -128) {
            return null;
        }
        return a == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    public static short fromShort(Short a) {
        if (a == null) {
            return Short.MIN_VALUE;
        }
        return a;
    }

    public static Short toShort(short a) {
        if (a == Short.MIN_VALUE) {
            return null;
        }
        return a;
    }

    public static int fromIntToByte(Integer a) {
        if (a == null) {
            return -128;
        }
        return a;
    }

    public static Integer toInt(byte a) {
        if (a == -128) {
            return null;
        }
        return new Integer(a);
    }

    public static int fromInt(Integer a) {
        if (a == null) {
            return Integer.MIN_VALUE;
        }
        return a;
    }

    public static Integer toInt(int a) {
        if (a == Integer.MIN_VALUE) {
            return null;
        }
        return new Integer(a);
    }

    public static short fromIntToShort(Integer a) {
        if (a == null) {
            return Short.MIN_VALUE;
        }
        return a.shortValue();
    }

    public static Integer toInt(short a) {
        if (a == Short.MIN_VALUE) {
            return null;
        }
        return new Integer(a);
    }

    public static long fromLong(Long a) {
        if (a == null) {
            return Long.MIN_VALUE;
        }
        return a;
    }

    public static Long toLong(long a) {
        if (a == Long.MIN_VALUE) {
            return null;
        }
        return a;
    }

    public static int fromIntArr(int[] a) {
        if (a == null) {
            return Integer.MIN_VALUE;
        }
        return MiscUtil.transfertIntegerArrayToInteger(a);
    }

    public static int[] toIntArr(int a) {
        if (a == Integer.MIN_VALUE) {
            return null;
        }
        return MiscUtil.transfertIntToIntegerArray(new Integer(a));
    }

    public static int[] transfertIntToIntegerArray(Integer intValue) {
        if (intValue == null) {
            return null;
        }
        int[] ret = new int[]{(intValue & 0xFF0000) / 65536, (intValue & 0xFF00) / 256 % 256, intValue % 256};
        return ret;
    }

    public static Integer transfertIntegerArrayToInteger(int[] coul) {
        if (coul == null) {
            return null;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.valueOf(coul[0] * (int)Math.pow(16.0, 4.0) + coul[1] * (int)Math.pow(16.0, 2.0) + coul[2]));
        }
        return new Integer(coul[0] * (int)Math.pow(16.0, 4.0) + coul[1] * (int)Math.pow(16.0, 2.0) + coul[2]);
    }

    public static String randomPassword(int len) {
        return String.valueOf(StringUtils.random((char[])passwordChars, (int)len));
    }

    public static boolean isCollectionOfType(Object source, Class<?> type) {
        return source instanceof Collection && (((Collection)source).isEmpty() || type.isAssignableFrom(((Collection)source).iterator().next().getClass()));
    }

    public static boolean isInstanceOrCollectionOfType(Object source, Class<?> type) {
        return source != null && (type.isAssignableFrom(source.getClass()) || source instanceof Collection && (((Collection)source).isEmpty() || type.isAssignableFrom(((Collection)source).iterator().next().getClass())));
    }

    public static boolean isInstanceOfOne(Object source, Class<?> ... classes) {
        if (source == null) {
            return false;
        }
        for (Class<?> c : classes) {
            if (!c.isInstance(source)) continue;
            return true;
        }
        return false;
    }

    public static void ensureIsInstanceOf(Object obj, Class<?> ... classes) {
        for (Class<?> c : classes) {
            if (!c.isInstance(obj)) continue;
            return;
        }
        String s = "obj (" + (obj == null ? null : obj.getClass().getSimpleName()) + ") must be instance of " + new JoinList(" or ", (Object[])classes).toString();
        throw new IllegalArgumentException(s);
    }

    public static <T> void addArrayToList(T[] source, List<T> target) {
        for (T element : source) {
            target.add(element);
        }
    }

    public static long factoriel(long n) {
        long fact = 1L;
        int i = 1;
        while ((long)i <= n) {
            fact *= (long)i;
            ++i;
        }
        return fact;
    }

    public static String[][] getPossibilityFrom(String[] baseList) {
        int nbChx = baseList.length;
        int nbPoss = (int)MiscUtil.factoriel(nbChx);
        String[][] newTable = new String[nbPoss][nbChx];
        if (nbChx == 0) {
            return null;
        }
        if (nbChx == 1) {
            newTable[0][0] = baseList[0];
        } else if (nbChx == 2) {
            newTable[0][0] = baseList[0];
            newTable[0][1] = baseList[1];
            newTable[1][0] = baseList[1];
            newTable[1][1] = baseList[0];
        }
        return newTable;
    }

    public static int[] pastelColor(int[] rgbColor) {
        int colorMaxVal;
        if (Math.max(rgbColor[0], Math.max(rgbColor[1], rgbColor[2])) <= 100 || rgbColor[0] + rgbColor[1] + rgbColor[2] <= 255) {
            float totColor = rgbColor[0] + rgbColor[1] + rgbColor[2];
            float pr = (float)rgbColor[0] / totColor;
            float pg = (float)rgbColor[1] / totColor;
            float pb = (float)rgbColor[2] / totColor;
            float dif = 260.0f - totColor;
            rgbColor[0] = rgbColor[0] + (int)(dif * pr);
            rgbColor[1] = rgbColor[1] + (int)(dif * pg);
            rgbColor[2] = rgbColor[2] + (int)(dif * pb);
        }
        if (rgbColor[0] == (colorMaxVal = Math.max(rgbColor[0], Math.max(rgbColor[1], rgbColor[2])))) {
            rgbColor[0] = Math.min((int)((double)rgbColor[0] * 1.3), 255);
        }
        if (rgbColor[1] == colorMaxVal) {
            rgbColor[1] = Math.min((int)((double)rgbColor[1] * 1.3), 255);
        }
        if (rgbColor[2] == colorMaxVal) {
            rgbColor[2] = Math.min((int)((double)rgbColor[2] * 1.3), 255);
        }
        return rgbColor;
    }

    public static <T> void addArrayToList(int[] source, List<Integer> target) {
        if (source == null) {
            return;
        }
        for (int element : source) {
            target.add(element);
        }
    }

    public static <T> List<T> asList(T[] array) {
        if (array == null) {
            return null;
        }
        ArrayList list = new ArrayList(array.length);
        MiscUtil.addArrayToList(array, list);
        return list;
    }

    public static boolean objectsAreEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static boolean objectsAreEquals(Object o1, Object o2, Object o3) {
        if (o1 == o2 && o2 == o3) {
            return true;
        }
        if (o1 == null || o2 == null || o3 == null) {
            return false;
        }
        return o1.equals(o2) && o2.equals(o3);
    }

    public static boolean objectsAreEqualsByTag(IEditableDataObject o1, IEditableDataObject o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2) || o1.equalsByTag(o2);
    }

    public static boolean areObjectsEquals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static Boolean numberToBoolean(Number i) {
        if (i == null) {
            return null;
        }
        if (i.intValue() != 0 && i.intValue() != 1) {
            throw new IllegalArgumentException("i is not in (0,1,null) : " + i);
        }
        return i.intValue() == 1;
    }

    public static Integer booleanToInteger(Boolean b) {
        if (b == null) {
            return null;
        }
        return b != false ? 1 : 0;
    }

    public static Short booleanToShort(Boolean b) {
        if (b == null) {
            return null;
        }
        return b != false ? new Short(1) : new Short(0);
    }

    public static boolean isTrue(Integer i) {
        Boolean b = MiscUtil.numberToBoolean(i);
        return Boolean.TRUE.equals(b);
    }

    public static boolean isFalse(Integer i) {
        Boolean b = MiscUtil.numberToBoolean(i);
        return Boolean.FALSE.equals(b);
    }

    public static <T extends ICloneable> List<T> deepClone(List<T> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ICloneable> list2 = new ArrayList<ICloneable>(list.size());
        for (ICloneable t : list) {
            list2.add((ICloneable)t.clone());
        }
        return list2;
    }

    public static <T> List<T> clone(List<T> list) {
        if (list == null) {
            return null;
        }
        return new ArrayList<T>(list);
    }

    public static <T> Set<T> clone(Set<T> set) {
        if (set == null) {
            return null;
        }
        return new HashSet<T>(set);
    }

    public static <T extends ICloneable> Set<T> deepClone(Set<T> list) {
        if (list == null) {
            return null;
        }
        HashSet<ICloneable> list2 = new HashSet<ICloneable>(list.size());
        for (ICloneable t : list) {
            list2.add((ICloneable)t.clone());
        }
        return list2;
    }

    public static String[] toArray(List<String> list) {
        if (list == null) {
            return null;
        }
        int size = list.size();
        String[] array = new String[size];
        list.toArray(array);
        for (int i = 0; i < size; ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    public static int[] toIntArray(List<Integer> list) {
        if (list == null) {
            return null;
        }
        int size = list.size();
        int[] array = new int[size];
        for (int i = 0; i < size; ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    public static boolean isDirty(Collection<? extends IMinimalEditableDataObject> c) {
        boolean dirty = false;
        Iterator<? extends IMinimalEditableDataObject> iterator = c.iterator();
        while (!dirty && iterator.hasNext()) {
            dirty = iterator.next().isDirty();
        }
        return dirty;
    }

    public static long showTime(String msg) {
        if ("1".equals(msg)) {
            time1.set(System.currentTimeMillis());
            return 0L;
        }
        time2.set(System.currentTimeMillis());
        long time = time2.get() - time1.get();
        System.out.println(msg + ": " + time);
        time1.set(System.currentTimeMillis());
        return time;
    }

    public static <T extends IMinimalEditableDataObject> T cloneKeepTag(T t) {
        Integer tag = t.getTag();
        IMinimalEditableDataObject c = (IMinimalEditableDataObject)t.clone();
        c.setTag(tag);
        return (T)c;
    }

    public static <T extends IMinimalEditableDataObject> List<T> deepCloneKeepTag(List<T> list) {
        if (list == null) {
            return null;
        }
        ArrayList<IMinimalEditableDataObject> list2 = new ArrayList<IMinimalEditableDataObject>(list.size());
        for (IMinimalEditableDataObject t : list) {
            list2.add(MiscUtil.cloneKeepTag(t));
        }
        return list2;
    }

    public static <T extends IMinimalEditableDataObject> LinkedHashSet<T> mergeKeepDirty(Collection<T> list1, Collection<T> list2) {
        LinkedHashSet<IMinimalEditableDataObject> res = new LinkedHashSet<IMinimalEditableDataObject>((list1 == null ? 0 : list1.size()) + (list2 == null ? 0 : list2.size()));
        if (list1 != null) {
            for (IMinimalEditableDataObject t : list1) {
                if (t == null || !t.isDirty()) continue;
                res.add(t);
            }
        }
        if (list2 != null) {
            for (IMinimalEditableDataObject t : list2) {
                if (t == null || !t.isDirty()) continue;
                res.add(t);
            }
        }
        if (list1 != null) {
            for (IMinimalEditableDataObject t : list1) {
                if (t == null || t.isDirty()) continue;
                res.add(t);
            }
        }
        if (list2 != null) {
            for (IMinimalEditableDataObject t : list2) {
                if (t == null || t.isDirty()) continue;
                res.add(t);
            }
        }
        return res;
    }

    public static Object[] add(Object[] array, Object item) {
        if (array == null) {
            array = new Object[]{item};
            return array;
        }
        Object[] array2 = new Object[array.length + 1];
        System.arraycopy(array, 0, array2, 0, array.length);
        array2[array2.length - 1] = item;
        return array2;
    }

    public static <T> List<List<T>> split(int size, List<T> col) {
        if (col == null) {
            throw new NullPointerException("col");
        }
        if (col.isEmpty()) {
            return new ArrayList<List<T>>();
        }
        ArrayList<List<T>> list = new ArrayList<List<T>>();
        int listSize = col.size();
        int count = listSize / size;
        for (int i = 0; i < count; ++i) {
            list.add(col.subList(i * size, i * size + size));
        }
        int mod = listSize % size;
        if (mod != 0) {
            list.add(col.subList(count * size, listSize));
        }
        return list;
    }

    public static void main(String[] args) {
        List<Integer> list = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15);
        JoinList joinList = new JoinList("\n", MiscUtil.split(8, list));
        System.out.println(joinList);
    }

    public static <T, R> ArrayList<R> map(Collection<T> col, ClosureAR<T, R> closure) {
        if (closure == null) {
            throw new NullPointerException("closure");
        }
        if (col == null) {
            return null;
        }
        if (col.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (T t : col) {
            list.add(closure.execute(t));
        }
        return list;
    }

    public static Integer getCombinedValueFromEnumSet(EnumSet eSet) {
        int value = 0;
        for (Object o : eSet.toArray()) {
            if (!(o instanceof EnumWithValue)) continue;
            value += ((EnumWithValue)o).getValue();
        }
        return new Integer(value);
    }

    public static String propertiesToData(Properties properties) {
        if (properties == null) {
            return null;
        }
        StringWriter writer = new StringWriter(properties.size() * 30);
        try {
            properties.store(writer, "");
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed to store inputs " + properties + " into StringWriter", e);
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    public static <T extends Comparable<T>> void trySort(List<T> list) {
        try {
            Collections.sort(list);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to sort list. Continue unsorted", e);
        }
    }

    public static <T> void trySort(List<T> list, Comparator<T> comparator) {
        try {
            Collections.sort(list, comparator);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to sort list. Continue unsorted", e);
        }
    }

    public static <T> void tryReverse(List<T> list) {
        try {
            Collections.reverse(list);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to reverse list order. Continue anyway", e);
        }
    }

    public static IPartialDate getPartialDate(String rawText) {
        PartialDate date = null;
        int len = (rawText = StringUtils.replace((String)rawText, (String)"[-/ ]", (String)"")).length();
        if (len <= 4) {
            try {
                int year = Integer.parseInt(rawText);
                date = PartialDate.from(null, null, (Integer)year);
            }
            catch (NumberFormatException e) {
                date = null;
            }
        } else if (len <= 6) {
            try {
                int year = Integer.parseInt(rawText.substring(0, 4));
                int month = Integer.parseInt(rawText.substring(4, rawText.length()));
                date = PartialDate.from(null, (Integer)(month == 0 ? null : Integer.valueOf(month)), (Integer)year);
            }
            catch (NumberFormatException e) {
                date = null;
            }
        } else if (len < 10) {
            try {
                int year = Integer.parseInt(rawText.substring(0, 4));
                int month = Integer.parseInt(rawText.substring(4, 6));
                int day = Integer.parseInt(rawText.substring(6, rawText.length()));
                date = PartialDate.from((Integer)(day == 0 ? null : Integer.valueOf(day)), (Integer)month, (Integer)year);
            }
            catch (NumberFormatException e) {
                date = null;
            }
        } else if (rawText.length() == 10) {
            try {
                date = LocalDateFormat.parse((String)rawText, (String)FormatDateProvider.getFormatDate().toString());
            }
            catch (ParseException e) {
                date = null;
            }
        } else {
            date = null;
        }
        return date;
    }

    public static String getStackTraceAsString(Throwable t) {
        StringWriter errors = new StringWriter();
        t.printStackTrace(new PrintWriter(errors));
        return errors.toString();
    }

    public static int fromLocalDate(LocalDate ld) {
        if (ld == null) {
            return Short.MIN_VALUE;
        }
        return ld.dayFrom1970;
    }

    public static LocalDate toLocalDate(int i) {
        if (i == Short.MIN_VALUE) {
            return null;
        }
        return LocalDate.fromDayFrom1970((int)i);
    }

    public static short fromLocalDateToShort(LocalDate ld) {
        if (ld == null) {
            return Short.MIN_VALUE;
        }
        return (short)ld.dayFrom1970;
    }

    public static LocalDate toLocalDate(short i) {
        if (i == Short.MIN_VALUE) {
            return null;
        }
        return LocalDate.fromDayFrom1970((short)i);
    }

    public static String toString(String s) {
        if ("\u2020".equals(s)) {
            return null;
        }
        return s;
    }

    public static String fromString(String s) {
        if (s == null) {
            return "\u2020";
        }
        return s;
    }

    public static <T extends EditableDataObject> EditableDataObjectList extracted(Kryo k, Input in, short b, Class<T> c) {
        EditableDataObjectList<EditableDataObject> lst = new EditableDataObjectList<EditableDataObject>(b);
        for (short j = 0; j < b; j = (short)(j + 1)) {
            EditableDataObject pt = (EditableDataObject)k.readObject(in, c);
            lst.add(pt);
        }
        return lst;
    }

    public static <T extends OrderedDataObject> OrderedDataObjectList orderedExtracted(Kryo k, Input in, short b, Class<T> c) {
        OrderedDataObjectList<OrderedDataObject> lst = new OrderedDataObjectList<OrderedDataObject>();
        for (short j = 0; j < b; j = (short)(j + 1)) {
            OrderedDataObject pt = (OrderedDataObject)k.readObject(in, c);
            lst.add(pt);
        }
        return lst;
    }

    public static void trySort(EditableDataObjectList list, Comparator<IImportance> comparator) {
        try {
            Collections.sort(list, comparator);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to sort list. Continue unsorted", e);
        }
    }

    static {
        StringBuilder b = new StringBuilder(100);
        for (int i = 33; i < 126; ++i) {
            b.append((char)i);
        }
        passwordChars = b.toString().toCharArray();
        time1 = new ThreadLocal<Long>(){

            @Override
            protected Long initialValue() {
                return 0L;
            }
        };
        time2 = new ThreadLocal<Long>(){

            @Override
            protected Long initialValue() {
                return 0L;
            }
        };
    }
}

