/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.status.service;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XUserRole;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import java.util.EnumSet;

public final class LoginService {
    public static final String BAD_PASSWORD_BAD_LOGIN = "BAD_PASSWORD_BAD_LOGIN";
    public static final String SECURITY_VALIDATION_FAILED = "SECURITY_VALIDATION_FAILED";
    public static final String SECURITY_AUTOLOG_FAILED = "SECURITY_AUTOLOG_FAILED";
    public static final String SECURITY_AUTOLOG_DISABLED = "SECURITY_AUTOLOG_DISABLED";
    public static final String OTHER_SESSION_ON_SAME_STATION = "OTHER_SESSION_ON_SAME_STATION";
    public static final String OTHER_SESSION_FOR_SAME_USER_DO_LOGIN = "OTHER_SESSION_FOR_SAME_USER_DO_LOGIN";
    public static final String OTHER_SESSION_FOR_SAME_USER_DO_LOGOUT = "OTHER_SESSION_FOR_SAME_USER_DO_LOGOUT";
    public static final String PASSWORD_EXPIRED = "PASSWORD_EXPIRED";
    public static final String NO_ACTIVE_SESSION_FOUND = "NO_ACTIVE_SESSION_FOUND";
    public static final String CLIENT_DOES_NOT_EXIST = "CLIENT_DOES_NOT_EXIST";
    public static final String MAXIMUM_ACTIVE_SESSION_FOR_ROLE_HAS_BEEN_REACHED = "MAXIMUM_ACTIVE_SESSION_FOR_ROLE_HAS_BEEN_REACHED";
    public static final String USER_BLOCKED = "USER_BLOCKED";
    public static final String CLIENT_IS_NOT_ACTIVE = "CLIENT_IS_NOT_ACTIVE";
    public static final String CLIENT_LICENCE_IS_EXPIRED = "CLIENT_LICENCE_IS_EXPIRED";
    public static final String USER_RESPONSABILITIES = "USER_RESPONSABILITIES";
    public static final String USER_INVALID_DATE_RANGE = "USER_INVALID_DATE_RANGE";
    public static final String TWO_FACTOR_UNCONFIGURED = "TWO_FACTOR_UNCONFIGURED";
    public static final String TWO_FACTOR_INVALID = "TWO_FACTOR_INVALID";
    public static final String TWO_FACTOR_VALID = "TWO_FACTOR_VALID";
    public static final String TWO_FACTOR_SUSPENDED = "TWO_FACTOR_SUSPENDED";
    public static final String LOGIN_MESSAGE = "LOGIN_MESSAGE";

    public static IStatus newBAD_PASSWORD_BAD_LOGIN() {
        return new Status.Builder().setCode(BAD_PASSWORD_BAD_LOGIN).setSeverity(IStatus.Severity.ERROR).setMessage(Messages.getString("NOM_DUSAGER_OU_MOT_DE_PASSE_INCORRECT", new String[0])).build();
    }

    public static IStatus newCLIENT_IS_NOT_ACTIVE() {
        return new Status.Builder().setCode(CLIENT_IS_NOT_ACTIVE).setSeverity(IStatus.Severity.ERROR).setMessage(Messages.getString("CLIENT_NON_ACTIF", new String[0])).build();
    }

    public static IStatus newCLIENT_LICENCE_IS_EXPIRED() {
        return new Status.Builder().setCode(CLIENT_LICENCE_IS_EXPIRED).setSeverity(IStatus.Severity.ERROR).setMessage(Messages.getString("LICENCE_EXPIREE", new String[0])).build();
    }

    public static final IStatus newSECURITY_VALIDATION_FAILED() {
        return new Status.Builder().setCode(SECURITY_VALIDATION_FAILED).setSeverity(IStatus.Severity.ERROR).setMessage(Messages.getString("LES_VALIDATIONS_DE_SECURITE_SUR_VOTRE_ORDINATEUR_ONT_ECHOUEES_VEUILLEZ_CONTACTER_LOGICIELS_INFODATA_INC", new String[0])).build();
    }

    public static final IStatus newSECURITY_AUTOLOG_FORCED_OUT_OF_DOMAIN() {
        return new Status.Builder().setCode(SECURITY_AUTOLOG_FAILED).setSeverity(IStatus.Severity.ERROR).setMessage(Messages.getString("SECURITY_AUTOLOG_FORCED_OUT_OF_DOMAIN", new String[0])).build();
    }

    public static final IStatus newSECURITY_AUTOLOG_DISABLED() {
        return new Status.Builder().setCode(SECURITY_AUTOLOG_DISABLED).setSeverity(IStatus.Severity.ERROR).setMessage(Messages.getString(SECURITY_AUTOLOG_DISABLED, new String[0])).build();
    }

    public static final IStatus newOTHER_SESSION_ON_SAME_STATION() {
        return new Status.Builder().setCode(OTHER_SESSION_ON_SAME_STATION).setSeverity(IStatus.Severity.INFO).setMessage(Messages.getString("AUTRE_SESSION_EN_COURS_STATION", new String[0])).build();
    }

    public static final IStatus newOTHER_SESSION_FOR_SAME_USER() {
        return new Status.Builder().setCode(OTHER_SESSION_FOR_SAME_USER_DO_LOGIN).setSeverity(IStatus.Severity.INFO).setMessage(Messages.getString("AUTRE_SESSION_EN_COURS_USER_DO_LOGIN", new String[0])).build();
    }

    public static final IStatus newOTHER_SESSION_FOR_SAME_USER_LOGOUT() {
        return new Status.Builder().setCode(OTHER_SESSION_FOR_SAME_USER_DO_LOGOUT).setSeverity(IStatus.Severity.INFO).setMessage(Messages.getString("AUTRE_SESSION_EN_COURS_USER_DO_LOGOUT", new String[0])).build();
    }

    public static final IStatus newPASSWORD_IS_EXPIRED() {
        return new Status.Builder().setCode(PASSWORD_EXPIRED).setSeverity(IStatus.Severity.WARNING).setMessage(Messages.getString("VOTRE_MOT_DE_PASSE_EST_EXPIRE_VOUS_DEVEZ_EN_CREER_UN_NOUVEAU", new String[0])).build();
    }

    public static final IStatus newTWO_FACTOR_NOT_CONFIGURED() {
        return new Status.Builder().setCode(TWO_FACTOR_UNCONFIGURED).setSeverity(IStatus.Severity.WARNING).setMessage(Messages.getString("AUTH_2_FACTEUR_ACTIVE_NONCONFIGURE", new String[0])).build();
    }

    public static final IStatus newLOGIN_MESSAGE(String loginMessage) {
        return new Status.Builder().setCode(LOGIN_MESSAGE).setSeverity(IStatus.Severity.WARNING).setMessage(loginMessage).build();
    }

    public static final IStatus newTWO_FACTOR_CODE_INVALID() {
        return new Status.Builder().setCode(TWO_FACTOR_INVALID).setSeverity(IStatus.Severity.ERROR).setMessage(Messages.getString("AUTH_2_FACTEUR_INVALIDE", new String[0])).build();
    }

    public static final IStatus newTWO_FACTOR_CODE_VALID_RESPONSE(String email) {
        return new Status.Builder().setCode(TWO_FACTOR_VALID).setSeverity(IStatus.Severity.OK).setMessage(email).build();
    }

    public static final IStatus newTWO_FACTOR_SUSPENDED_RESPONSE(String suspensionDate) {
        return new Status.Builder().setCode(TWO_FACTOR_SUSPENDED).setSeverity(IStatus.Severity.OK).setMessage(suspensionDate).build();
    }

    public static final IStatus newNO_ACTIVE_SESSION_FOUND() {
        return new Status.Builder().setCode(NO_ACTIVE_SESSION_FOUND).setSeverity(IStatus.Severity.ERROR).setMessage(Messages.getString(NO_ACTIVE_SESSION_FOUND, new String[0])).build();
    }

    public static final IStatus newUSER_BLOCKED() {
        return new Status.Builder().setCode(USER_BLOCKED).setSeverity(IStatus.Severity.ERROR).setMessage(Messages.getString("UTILISATEUR_BLOQUE", new String[0])).build();
    }

    public static final IStatus newCLIENT_DOES_NOT_EXIST() {
        return new Status.Builder().setCode(CLIENT_DOES_NOT_EXIST).setSeverity(IStatus.Severity.ERROR).setMessage(Messages.getString("CODE_CLIENT_INVALIDE_CONTACTEZ_INFODATA", new String[0])).build();
    }

    public static final IStatus newMAXIMUM_ACTIVE_SESSION_FOR_ROLE_HAS_BEEN_REACHED(int maxActiveSession, EnumSet<XUserRole> roles) {
        return LoginService.newMAXIMUM_ACTIVE_SESSION_FOR_ROLE_HAS_BEEN_REACHED(maxActiveSession, XUserRole.getMaxXUserRoleValueFromEnumSet(roles));
    }

    public static final IStatus newMAXIMUM_ACTIVE_SESSION_FOR_ROLE_HAS_BEEN_REACHED(int maxActiveSession, XUserRole role) {
        if (role == null) {
            throw new NullPointerException("role");
        }
        String text = Messages.getString("OUVERTURE_DE_SESSION_REFUSEE._LE_NOMBRE_MAXIMUM_DE_?_SESSION(S)_ACTIVE(S)_POUR_LE_ROLE_?_A_ETE_ATTEINT.", new String[0]);
        text = text.replaceFirst("\\?", String.valueOf(maxActiveSession));
        text = text.replaceFirst("\\?", role.toString());
        return new Status.Builder().setCode(MAXIMUM_ACTIVE_SESSION_FOR_ROLE_HAS_BEEN_REACHED).setSeverity(IStatus.Severity.ERROR).setMessage(text).build();
    }

    public static IStatus newUSER_RESPONSABILITIES() {
        return new Status.Builder().setCode(USER_RESPONSABILITIES).setSeverity(IStatus.Severity.INFO).setMessage(Messages.getString("MESSAGE_RESPONSABILITES", new String[0])).build();
    }

    public static IStatus newUSER_INVALID_DATE_RANGE() {
        return new Status.Builder().setCode(USER_INVALID_DATE_RANGE).setSeverity(IStatus.Severity.ERROR).setMessage(Messages.getString("UTILISATEUR_INACTIF", new String[0])).build();
    }
}

