/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.status;

import ca.infodata.ofys.status.IStatus;
import java.io.Serializable;

public class Status
implements IStatus {
    private static final long serialVersionUID = 1L;
    public static final IStatus OK_STATUS = new Status("OK", IStatus.Severity.OK, "", null, null);
    public static final IStatus UNSUPPORTED_OPERATION_STATUS = new Status("UNSUPPORTED_OPERATION", IStatus.Severity.ERROR, "", null, null);
    private IStatus.Severity severity;
    private String message;
    private transient Throwable exception;
    private String code;
    private Serializable data;

    public Status() {
    }

    public Status(IStatus.Severity severity) {
        this(severity, "", null);
    }

    public Status(IStatus.Severity severity, String message) {
        this(severity, message, null);
    }

    public Status(String code, IStatus.Severity severity, String message) {
        this(code, severity, message, null, null);
    }

    public Status(IStatus.Severity severity, Throwable exception) {
        this(severity, null, exception);
    }

    public Status(IStatus.Severity severity, String message, Throwable exception) {
        this("NULL_CODE", severity, message, exception, null);
    }

    public Status(String code, IStatus.Severity severity, String message, Throwable exception, Serializable data) {
        if (code == null || severity == null) {
            throw new NullPointerException();
        }
        this.severity = severity;
        this.message = message == null ? "" : message;
        this.exception = exception;
        this.code = code;
        this.data = data;
    }

    @Override
    public Serializable getData() {
        return this.data;
    }

    @Override
    public void setData(Serializable data) {
        this.data = data;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public Throwable getException() {
        return this.exception;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public IStatus.Severity getSeverity() {
        return this.severity;
    }

    @Override
    public boolean isOK() {
        return this.severity == IStatus.Severity.OK;
    }

    @Override
    public boolean isOkToProceed() {
        return this.severity == IStatus.Severity.OK || this.severity == IStatus.Severity.INFO || this.severity == IStatus.Severity.WARNING;
    }

    public String toString() {
        return String.format("Status %s, Code %s, Message: %s, Exception: %s", new Object[]{this.severity, this.code, this.message, this.exception});
    }

    private Object readResolve() {
        if (OK_STATUS.getCode().equals(this.getCode()) && OK_STATUS.getSeverity() == this.getSeverity() && OK_STATUS.getMessage().equals(this.getMessage()) && OK_STATUS.getClass().equals(this.getClass())) {
            return OK_STATUS;
        }
        return this;
    }

    public boolean equalsByCode(IStatus other) {
        if (other != null && !"NULL_CODE".equals(this.getCode()) && !"NULL_CODE".equals(other.getCode())) {
            return this.getCode().equals(other.getCode());
        }
        return false;
    }

    @Override
    public IStatus getStatus(String code) {
        if (code == null) {
            throw new IllegalArgumentException();
        }
        if (this.getCode().equals(code)) {
            return this;
        }
        return null;
    }

    @Override
    public IStatus getStatus(IStatus.Severity severity) {
        if (severity == null) {
            throw new IllegalArgumentException();
        }
        if (severity == this.getSeverity()) {
            return this;
        }
        return null;
    }

    public void setSeverity(IStatus.Severity severity) {
        this.severity = severity;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public boolean isLessSevereThan(IStatus.Severity severity) {
        if (severity == null) {
            return false;
        }
        IStatus.Severity s = this.getSeverity();
        return s.ordinal() < severity.ordinal();
    }

    public static final class Builder {
        private IStatus.Severity severity;
        private String message = "";
        private Throwable exception;
        private String code = "NULL_CODE";
        private Serializable data;

        public Serializable getData() {
            return this.data;
        }

        public IStatus.Severity getSeverity() {
            return this.severity;
        }

        public String getMessage() {
            return this.message;
        }

        public Throwable getException() {
            return this.exception;
        }

        public String getCode() {
            return this.code;
        }

        public Builder setData(Serializable data) {
            this.data = data;
            return this;
        }

        public Builder setSeverity(IStatus.Severity severity) {
            this.severity = severity;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setException(Throwable exception) {
            this.exception = exception;
            return this;
        }

        public Builder setCode(String code) {
            this.code = code;
            return this;
        }

        public Status build() {
            return new Status(this.code, this.severity, this.message, this.exception, this.data);
        }
    }
}

