/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.mb.listener.object;

import ca.infodata.ofys.mb.listener.object.IObjectListener;
import ca.infodata.ofys.mb.listener.object.ObjectListenerMXBean;
import ca.infodata.ofys.mb.listener.object.WeakEqualReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ObjectListenerManager {
    private static final Logger logger = Logger.getLogger(ObjectListenerManager.class.getName());
    private static final Logger loggerClean = Logger.getLogger(ObjectListenerManager.class.getName() + ".Clean");
    static final ObjectListenerManager instance = new ObjectListenerManager();
    final ConcurrentHashMap<Key, CopyOnWriteArraySet<WeakReference<IObjectListener<?>>>> managers = new ConcurrentHashMap();
    final ConcurrentHashMap<Key, Boolean> disabledObjects = new ConcurrentHashMap();
    private Thread cleanupThread;
    private static ObjectListenerMXBean objectListenerMXBean = null;
    public static final String LISTENER_MXBEAN_NAME = "ca.infodata.ofys.mb.listener.object:type=ObjectListenerMXBean";

    protected ObjectListenerManager() {
        this.createAndStartCleanupThread();
    }

    private void createAndStartCleanupThread() {
        this.cleanupThread = new ThreadExtension("ListenerManager cleanup thread");
        this.cleanupThread.setPriority(1);
        this.cleanupThread.setDaemon(true);
        this.cleanupThread.start();
    }

    public static void addListener(Object object, IObjectListener listener) {
        if (listener == null || object == null) {
            return;
        }
        Key key = new Key(object);
        CopyOnWriteArraySet<WeakEqualReference<IObjectListener>> manager = new CopyOnWriteArraySet<WeakEqualReference<IObjectListener>>();
        CopyOnWriteArraySet<WeakEqualReference<IObjectListener>> oldManager = ObjectListenerManager.instance.managers.putIfAbsent(key, manager);
        if (oldManager != null) {
            oldManager.add(new WeakEqualReference<IObjectListener>(listener));
        } else {
            manager.add(new WeakEqualReference<IObjectListener>(listener));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "ObjectListenerManager.addListener " + key + " " + listener);
        }
    }

    public static void disable(Object object) {
        if (object == null) {
            return;
        }
        Key key = new Key(object);
        ObjectListenerManager.instance.disabledObjects.put(key, false);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "ObjectListenerManager.disable " + key);
        }
    }

    public static void enable(Object object) {
        ObjectListenerManager.enable(object, false);
    }

    public static void enable(Object object, boolean fireIfModified) {
        if (object == null) {
            return;
        }
        Key key = new Key(object);
        Boolean flag = ObjectListenerManager.instance.disabledObjects.remove(key);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "ObjectListenerManager.enable " + key);
        }
        if (fireIfModified && flag != null && flag.booleanValue()) {
            ObjectListenerManager.fireObjectModified(object);
        }
    }

    public static void removeListener(Object object, IObjectListener listener) {
        if (object == null || listener == null) {
            return;
        }
        Key key = new Key(object);
        CopyOnWriteArraySet<WeakReference<IObjectListener<?>>> manager = ObjectListenerManager.instance.managers.get(key);
        if (manager != null) {
            manager.remove(new WeakEqualReference<IObjectListener>(listener));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "ObjectListenerManager.removeListener " + key + " " + listener);
        }
    }

    public static void removeListener(IObjectListener listener) {
        if (listener == null) {
            return;
        }
        for (Map.Entry<Key, CopyOnWriteArraySet<WeakReference<IObjectListener<?>>>> next : ObjectListenerManager.instance.managers.entrySet()) {
            CopyOnWriteArraySet<WeakReference<IObjectListener<?>>> value = next.getValue();
            value.remove(new WeakEqualReference<IObjectListener>(listener));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "ObjectListenerManager.removeListener " + listener);
        }
    }

    public static void remove(Object object) {
        if (object == null) {
            return;
        }
        Key key = new Key(object);
        ObjectListenerManager.instance.managers.remove(key);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "ObjectListenerManager.remove " + key);
        }
    }

    public static boolean isListenerOn(Object object, IObjectListener listener) {
        boolean listenerOn;
        if (object == null || listener == null) {
            return false;
        }
        Key key = new Key(object);
        CopyOnWriteArraySet<WeakReference<IObjectListener<?>>> manager = ObjectListenerManager.instance.managers.get(key);
        boolean bl = listenerOn = manager != null && manager.contains(new WeakEqualReference<IObjectListener>(listener));
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "ObjectListenerManager.listenerOn " + key + " : " + listenerOn);
        }
        return listenerOn;
    }

    public static boolean isListened(Object object) {
        boolean listened;
        if (object == null) {
            return false;
        }
        Key key = new Key(object);
        boolean bl = listened = ObjectListenerManager.instance.managers.get(key) != null;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "ObjectListenerManager.isListened " + key + " : " + listened);
        }
        return listened;
    }

    public static void fireObjectModified(Object object) {
        if (object == null) {
            return;
        }
        Key key = new Key(object);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "ObjectListenerManager.fireObjectModified " + key);
        }
        if (ObjectListenerManager.instance.disabledObjects.containsKey(key)) {
            ObjectListenerManager.instance.disabledObjects.put(key, true);
        } else {
            CopyOnWriteArraySet<WeakReference<IObjectListener<?>>> manager = ObjectListenerManager.instance.managers.get(key);
            if (manager != null) {
                for (WeakReference<IObjectListener<?>> weakReference : manager) {
                    IObjectListener listener = (IObjectListener)weakReference.get();
                    if (listener == null) continue;
                    listener.objectModified(object);
                }
            }
        }
    }

    public static synchronized ObjectListenerMXBean getObjectListenerMXBean() {
        if (objectListenerMXBean == null) {
            objectListenerMXBean = new ObjectListenerMXBean();
        }
        return objectListenerMXBean;
    }

    private final class ThreadExtension
    extends Thread {
        private ThreadExtension(String name) {
            super(name);
        }

        @Override
        public void run() {
            super.run();
            block2: while (true) {
                try {
                    TimeUnit.SECONDS.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                loggerClean.finer("Cleaning listeners....");
                Iterator<Map.Entry<Key, CopyOnWriteArraySet<WeakReference<IObjectListener<?>>>>> iterator = ObjectListenerManager.this.managers.entrySet().iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block2;
                    Map.Entry<Key, CopyOnWriteArraySet<WeakReference<IObjectListener<?>>>> item = iterator.next();
                    if (loggerClean.isLoggable(Level.FINEST)) {
                        loggerClean.finer("Cleaning... " + item.getKey());
                    }
                    ArrayList toRemoves = new ArrayList();
                    for (WeakReference<IObjectListener<?>> ref : item.getValue()) {
                        if (ref.get() != null) continue;
                        toRemoves.add(ref);
                    }
                    item.getValue().removeAll(toRemoves);
                    if (toRemoves.size() > 0 && logger.isLoggable(Level.FINE)) {
                        loggerClean.fine("Removed " + toRemoves.size() + " weak reference from manager " + item.getValue() + " for hashcode " + item.getKey());
                    }
                    if (!item.getValue().isEmpty()) continue;
                    if (loggerClean.isLoggable(Level.FINE)) {
                        loggerClean.fine("No listener on manager " + item.getValue() + " for hashcode " + item.getKey() + ". Removed");
                    }
                    iterator.remove();
                }
                break;
            }
        }
    }

    public static final class Key {
        final String objectClassName;
        final WeakReference<Object> object;
        final int hashcode;

        public Key(Object object) {
            this.objectClassName = object.getClass().getName();
            this.object = new WeakReference<Object>(object);
            this.hashcode = System.identityHashCode(object);
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return this.hashcode == other.hashcode;
        }

        public String toString() {
            StringBuilder b = new StringBuilder(100);
            b.append("Key [");
            b.append(this.objectClassName);
            b.append(", ");
            b.append(this.object.get());
            b.append(", ");
            b.append(this.hashcode);
            b.append("]");
            return b.toString();
        }

        public String getObjectClassName() {
            return this.objectClassName;
        }

        public Object getObject() {
            return this.object.get();
        }
    }
}

