/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.variablereplacer;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPerson;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IVariablesReplacer;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;

public class PersonVariableReplacer
implements IVariablesReplacer<IPerson> {
    private IPerson person;
    private LocalDate today = LocalDate.today();

    @Override
    public void setDataObject(IPerson dataObject) {
        this.person = dataObject;
    }

    @Override
    public void setToday(LocalDate today) {
        this.today = today;
    }

    @Override
    public String replaceVariables(String text) {
        String textToReplaceBy;
        int varIndexEnd;
        int varIndex;
        StringBuffer textToReturn = new StringBuffer(text);
        while ((varIndex = textToReturn.indexOf("[aujourd'hui]")) > -1) {
            varIndexEnd = varIndex + "[aujourd'hui]".length();
            textToReplaceBy = LocalDateFormat.format((LocalDate)this.today, (String)FormatDateProvider.getFormatDate().toString());
            textToReturn = textToReturn.replace(varIndex, varIndexEnd, textToReplaceBy);
        }
        while ((varIndex = textToReturn.indexOf("[titre]")) > -1) {
            varIndexEnd = varIndex + "[titre]".length();
            textToReplaceBy = this.person.getTitle();
            textToReturn = textToReturn.replace(varIndex, varIndexEnd, textToReplaceBy);
        }
        while ((varIndex = textToReturn.indexOf("[sexe]")) > -1) {
            varIndexEnd = varIndex + "[sexe]".length();
            String gender = this.person.getGender();
            String textToReplaceBy2 = "";
            if (gender == null || gender.equals("I")) {
                textToReplaceBy2 = Messages.getString("INCONNU", new String[0]);
            } else if (gender.equals("M")) {
                textToReplaceBy2 = Messages.getString("MASCULIN", new String[0]);
            } else if (gender.equals("F")) {
                textToReplaceBy2 = Messages.getString("FEMININ", new String[0]);
            }
            textToReturn = textToReturn.replace(varIndex, varIndexEnd, textToReplaceBy2);
        }
        while ((varIndex = textToReturn.indexOf("[datedenaissance]")) > -1) {
            varIndexEnd = varIndex + "[datedenaissance]".length();
            textToReplaceBy = LocalDateFormat.format((LocalDate)this.person.getBirthDate(), (String)FormatDateProvider.getFormatDate().toString());
            textToReturn = textToReturn.replace(varIndex, varIndexEnd, textToReplaceBy);
        }
        while ((varIndex = textToReturn.indexOf("[nom]")) > -1) {
            varIndexEnd = varIndex + "[nom]".length();
            textToReplaceBy = this.person.getName();
            textToReturn = textToReturn.replace(varIndex, varIndexEnd, textToReplaceBy);
        }
        return textToReturn.toString();
    }
}

