/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.sxapi;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.medication.XDrugStrength;
import ca.infodata.ofys.data.middle.dataobjects.sxapi.XAlertItemLevel;
import ca.infodata.ofys.data.middle.dataobjects.sxapi.XAlertItemType;
import ca.infodata.ofys.data.middle.dataobjects.sxapi.XAllergyItem;
import ca.infodata.ofys.data.middle.dataobjects.sxapi.XDrugItem;
import ca.infodata.ofys.data.middle.dataobjects.sxapi.XIntoleranceItem;
import ca.infodata.util1.StringUtils;
import java.io.Serializable;

public class XAlertItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String category;
    private String description;
    private long reference1Type;
    private long reference2Type;
    private long type;
    private XDrugItem reference1Drug;
    private XDrugItem reference2Drug;
    private XAllergyItem reference1Allergy;
    private XAllergyItem reference2Allergy;
    private XIntoleranceItem reference1Intolerance;
    private XIntoleranceItem reference2Intolerance;

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getReference1Type() {
        return this.reference1Type;
    }

    public void setReference1Type(long reference1Type) {
        this.reference1Type = reference1Type;
    }

    public long getReference2Type() {
        return this.reference2Type;
    }

    public void setReference2Type(long reference2Type) {
        this.reference2Type = reference2Type;
    }

    public long getType() {
        return this.type;
    }

    public void setType(long type) {
        this.type = type;
    }

    public XDrugItem getReference1Drug() {
        return this.reference1Drug;
    }

    public void setReference1Drug(XDrugItem reference1Drug) {
        this.reference1Drug = reference1Drug;
    }

    public XDrugItem getReference2Drug() {
        return this.reference2Drug;
    }

    public void setReference2Drug(XDrugItem reference2Drug) {
        this.reference2Drug = reference2Drug;
    }

    public XAllergyItem getReference1Allergy() {
        return this.reference1Allergy;
    }

    public void setReference1Allergy(XAllergyItem reference1Allergy) {
        this.reference1Allergy = reference1Allergy;
    }

    public XAllergyItem getReference2Allergy() {
        return this.reference2Allergy;
    }

    public void setReference2Allergy(XAllergyItem reference2Allergy) {
        this.reference2Allergy = reference2Allergy;
    }

    public XIntoleranceItem getReference1Intolerance() {
        return this.reference1Intolerance;
    }

    public void setReference1Intolerance(XIntoleranceItem reference1Intolerance) {
        this.reference1Intolerance = reference1Intolerance;
    }

    public XIntoleranceItem getReference2Intolerance() {
        return this.reference2Intolerance;
    }

    public void setReference2Intolerance(XIntoleranceItem reference2Intolerance) {
        this.reference2Intolerance = reference2Intolerance;
    }

    public String toString() {
        return String.format("XAlertItem [category=%s, description=%s, reference1Type=%s, reference2Type=%s, type=%s, reference1Drug=%s, reference2Drug=%s, reference1Allergy=%s, reference2Allergy=%s, reference1Intolerance=%s, reference2Intolerance=%s]", this.category, this.description, this.reference1Type, this.reference2Type, this.type, this.reference1Drug, this.reference2Drug, this.reference1Allergy, this.reference2Allergy, this.reference1Intolerance, this.reference2Intolerance);
    }

    public XAlertItemLevel getDrugAlertLevel(XDrugStrength drug) {
        XAlertItemLevel drugAlertLevel = null;
        if (drug != null) {
            String drugName = drug.getGenericName() + " " + drug.getCommercialName();
            drugName = StringUtils.convertNonAscii((String)drugName);
            String ref1name = "";
            switch ((int)this.getReference1Type()) {
                case 10: {
                    ref1name = this.getReference1Drug().getCommercialName();
                    break;
                }
                case 12: {
                    ref1name = this.getReference1Allergy().getName();
                    break;
                }
                case 16: {
                    ref1name = this.getReference1Intolerance().getName();
                }
            }
            String ref2name = "";
            switch ((int)this.getReference2Type()) {
                case 10: {
                    ref2name = this.getReference2Drug().getCommercialName();
                    break;
                }
                case 12: {
                    ref2name = this.getReference2Allergy().getName();
                    break;
                }
                case 16: {
                    ref2name = this.getReference2Intolerance().getName();
                }
            }
            if (drugName.contains(ref1name.toUpperCase()) || drugName.contains(ref2name.toUpperCase())) {
                int alertLevel = (int)this.getType();
                int alc = 100;
                int food = 100;
                int interact = 100;
                int gf = 100;
                if (ref1name.startsWith("ALCOOL") || ref1name.startsWith("ALCOHOL")) {
                    alc = alertLevel;
                } else if (ref1name.startsWith("GRAPEFRUIT") || ref1name.contains("PAMPLEMOUSSE")) {
                    gf = alertLevel;
                } else if (ref1name.startsWith("FOOD") || ref1name.startsWith("NOURRITURE")) {
                    food = alertLevel;
                } else {
                    interact = alertLevel;
                }
                drugAlertLevel = new XAlertItemLevel(interact, food, alc, gf);
            }
        }
        return drugAlertLevel;
    }

    public String getFormattedToString() {
        String _ALLERGIE__ = Messages.getString("JavaSxApiSearchService._ALLERGIE__", new String[0]);
        String _PATHOLOGIE__ = Messages.getString("JavaSxApiSearchService._PATHOLOGIE__", new String[0]);
        StringBuilder text = new StringBuilder(500);
        text.append(XAlertItemType.getAlertItemTypeText((int)this.getType())).append(" :  ");
        switch ((int)this.getReference1Type()) {
            case 10: {
                text.append(this.getReference1Drug().getCommercialName()).append(" ");
                break;
            }
            case 12: {
                text.append(_ALLERGIE__).append(this.getReference1Allergy().getName()).append(" ");
                break;
            }
            case 16: {
                System.out.println(this.getReference1Intolerance().getName());
            }
        }
        switch ((int)this.getReference2Type()) {
            case 10: {
                text.append("--> ").append(this.getReference2Drug().getCommercialName()).append(" ");
                break;
            }
            case 12: {
                text.append(";").append(_ALLERGIE__).append(this.getReference2Allergy().getName()).append(" ");
                break;
            }
            case 16: {
                System.out.println(this.getReference2Intolerance().getName());
            }
        }
        return text.toString();
    }
}

